.\"
.\" $XFree86: xc/doc/man/Xi/XSeBMap.man,v 1.3 2003/04/28 22:18:15 herrb Exp $
.\"
.\"
.\" Copyright ([\d,\s]*) by Hewlett-Packard Company, Ardent Computer, 
.\" 
.\" Permission to use, copy, modify, distribute, and sell this documentation 
.\" for any purpose and without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" Ardent, and Hewlett-Packard make no representations about the 
.\" suitability for any purpose of the information in this document.  It is 
.\" provided \`\`as is'' without express or implied warranty.
.\" 
.\" $Xorg: XSeBMap.man,v 1.3 2000/08/17 19:41:57 cpqbld Exp $
.ds xL Programming With Xlib
.TH XSetDeviceButtonMapping 3X11 __xorgversion__ "X FUNCTIONS"
.SH NAME
XSetDeviceButtonMapping, XGetDeviceButtonMapping \- query or change device button mappings
.SH SYNTAX
.HP
int XSetDeviceButtonMapping\^(\^Display *\fIdisplay\fP\^, XDevice
*\fIdevice\fP\^, unsigned char \fImap\fP\^[]\^, int \fInmap\fP\^); 
.HP
int XGetDeviceButtonMapping\^(\^Display *\fIdisplay\fP\^, XDevice
*\fIdevice\fP\^, unsigned char \fImap_return\fP\^[]\^, int \fInmap\fP\^); 
.SH ARGUMENTS
.TP 12
.I display
Specifies the connection to the X server.
.TP 12
.I device
Specifies the device whose button mapping is to be queried or changed.
.TP 12
.I map
Specifies the mapping list.
.TP 12
.I map_return
Returns the mapping list.
.TP 12
.I nmap
Specifies the number of items in the mapping list.
.SH DESCRIPTION
The \fIXSetDeviceButtonMapping\fP
request sets the mapping of the specified device.
If it succeeds, the X server generates a
\fIDeviceMappingNotify\fP event, and
\fIXSetDeviceButtonMapping\fP returns \fIMappingSuccess\fP.
Element map[i] defines the logical button number for the physical button
i+1.
The length of the list must be the same as
\fIXGetDeviceButtonMapping\fP
would return, or a \fIBadValue\fP
error results.
A zero element disables a button, and elements are not restricted in
value by the number of physical buttons.
However, no two elements can have the same nonzero value,
or a \fIBadValue\fP error results.
If any of the buttons to be altered are logically in the down state,
\fIXSetDeviceButtonMapping\fP returns \fIMappingBusy\fP,
and the mapping is not changed.
.LP
\fIXSetDeviceButtonMapping\fP
can generate \fIBadDevice\fP, \fIBadMatch\fP, and  \fIBadValue\fP errors.
.LP
The \fIXGetDeviceButtonMapping\fP
request returns the current mapping of the specified device.
Buttons are numbered starting from one.
\fIXGetDeviceButtonMapping\fP
returns the number of physical buttons actually on the device.
The nominal mapping for a device is map[i]=i+1.
The nmap argument specifies the length of the array where the device
mapping is returned, and only the first nmap elements are returned 
in map_return.
.LP
\fIXGetDeviceButtonMapping\fP
can generate \fIBadDevice\fP or \fIBadMatch\fP errors.
.SH DIAGNOSTICS
.TP 12
\fIBadDevice\fP
An invalid device was specified.  The specified device does not exist or has 
not been opened by this client via \fIXOpenInputDevice\fP.  This error may
also occur if the specified device is the X keyboard or X pointer device.
.TP 12
\fIBadMatch\fP
This error may occur if an \fIXGetDeviceButtonMapping\fP or 
\fIXSetDeviceButtonMapping\fP request was made 
specifying a device that has no buttons.
.TP 12
\fIBadValue\fP
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XChangeDeviceKeyboardControl(3X),
.br
XChangeDeviceKeyMapping(3X)
.br
XChangeDeviceModifierMapping(3X)
.br
.br
\fI\*(xL\fP
