require '_h2ph_pre.ph';

unless(defined(&VA_SUN4U_VPG)) {
    sub VA_SUN4U_VPG {
	local($va) = @_;
	eval q(((($va) >> 13) & 31));
    }
}
unless(defined(&VA_SUN4U_OFF)) {
    sub VA_SUN4U_OFF {
	local($va) = @_;
	eval q(((($va)) & 0x1fff));
    }
}
unless(defined(&VA_VPG)) {
    sub VA_VPG {
	local($va) = @_;
	eval q( &VA_SUN4U_VPG($va));
    }
}
unless(defined(&VA_OFF)) {
    sub VA_OFF {
	local($va) = @_;
	eval q( &VA_SUN4U_OFF($va));
    }
}
unless(defined(&PG_SHIFT4U)) {
    sub PG_SHIFT4U () {	13;}
}
unless(defined(&MMU_PAGE_ALIGN)) {
    sub MMU_PAGE_ALIGN () {	8192;}
}
unless(defined(&TSBVA)) {
    sub TSBVA {
	local($i) = @_;
	eval q((( ($tsb[&(i)]->{tag}->{f}->{tag_va})<<22)|((($i)<<13)&0x3ff000)));
    }
}
unless(defined(&_LOCORE)) {
    if(0) {
    } else {
    }
}
unless(defined(&CTX_MASK)) {
    sub CTX_MASK () {	((1<<13)-1);}
}
unless(defined(&TSB_TAG_CTX_SHIFT)) {
    sub TSB_TAG_CTX_SHIFT () {	48;}
}
unless(defined(&TSB_TAG_VA_SHIFT)) {
    sub TSB_TAG_VA_SHIFT () {	22;}
}
unless(defined(&TSB_TAG_G)) {
    sub TSB_TAG_G () {	0x8000000000000000;}
}
unless(defined(&TSB_TAG_CTX)) {
    sub TSB_TAG_CTX {
	local($t) = @_;
	eval q((((($t))>> &TSB_TAG_CTX_SHIFT) &CTX_MASK));
    }
}
unless(defined(&TSB_TAG_VA)) {
    sub TSB_TAG_VA {
	local($t) = @_;
	eval q((((($t))<< &TSB_TAG_VA_SHIFT)));
    }
}
unless(defined(&TSB_TAG)) {
    sub TSB_TAG {
	local($g,$ctx,$va) = @_;
	eval q(((((!=0))<<63)|(( &CTX_MASK)<< &TSB_TAG_CTX_SHIFT)|(($va)>> &TSB_TAG_VA_SHIFT)));
    }
}
unless(defined(&PGSZ_8K)) {
    sub PGSZ_8K () {	0;}
}
unless(defined(&PGSZ_64K)) {
    sub PGSZ_64K () {	1;}
}
unless(defined(&PGSZ_512K)) {
    sub PGSZ_512K () {	2;}
}
unless(defined(&PGSZ_4M)) {
    sub PGSZ_4M () {	3;}
}
unless(defined(&PGSZ_SHIFT)) {
    sub PGSZ_SHIFT () {	61;}
}
unless(defined(&PG_SZ)) {
    sub PG_SZ {
	local($s) = @_;
	eval q((1<<(12+($s?(3*$s):1))));
    }
}
unless(defined(&TLB_SZ)) {
    sub TLB_SZ {
	local($s) = @_;
	eval q(((($s))<< &PGSZ_SHIFT));
    }
}
unless(defined(&TLB_V)) {
    sub TLB_V () {	0x8000000000000000;}
}
unless(defined(&TLB_8K)) {
    sub TLB_8K () {	 &TLB_SZ( &PGSZ_8K);}
}
unless(defined(&TLB_64K)) {
    sub TLB_64K () {	 &TLB_SZ( &PGSZ_64K);}
}
unless(defined(&TLB_512K)) {
    sub TLB_512K () {	 &TLB_SZ( &PGSZ_512K);}
}
unless(defined(&TLB_4M)) {
    sub TLB_4M () {	 &TLB_SZ( &PGSZ_4M);}
}
unless(defined(&TLB_SZ_MASK)) {
    sub TLB_SZ_MASK () {	0x6000000000000000;}
}
unless(defined(&TLB_NFO)) {
    sub TLB_NFO () {	0x1000000000000000;}
}
unless(defined(&TLB_IE)) {
    sub TLB_IE () {	0x800000000000000;}
}
unless(defined(&TLB_SOFT2_MASK)) {
    sub TLB_SOFT2_MASK () {	0x7fe000000000000;}
}
unless(defined(&TLB_DIAG_MASK)) {
    sub TLB_DIAG_MASK () {	0x1fe0000000000;}
}
unless(defined(&TLB_PA_MASK)) {
    sub TLB_PA_MASK () {	0x1ffffffe000;}
}
unless(defined(&TLB_SOFT_MASK)) {
    sub TLB_SOFT_MASK () {	0x1f80;}
}
unless(defined(&TLB_ACCESS)) {
    sub TLB_ACCESS () {	0x200;}
}
unless(defined(&TLB_MODIFY)) {
    sub TLB_MODIFY () {	0x800;}
}
unless(defined(&TLB_REAL_W)) {
    sub TLB_REAL_W () {	0x400;}
}
unless(defined(&TLB_TSB_LOCK)) {
    sub TLB_TSB_LOCK () {	0x1000;}
}
unless(defined(&TLB_EXEC)) {
    sub TLB_EXEC () {	0x100;}
}
unless(defined(&TLB_EXEC_ONLY)) {
    sub TLB_EXEC_ONLY () {	0x80;}
}
unless(defined(&TLB_L)) {
    sub TLB_L () {	0x40;}
}
unless(defined(&TLB_CACHE_MASK)) {
    sub TLB_CACHE_MASK () {	0x30;}
}
unless(defined(&TLB_CP)) {
    sub TLB_CP () {	0x20;}
}
unless(defined(&TLB_CV)) {
    sub TLB_CV () {	0x10;}
}
unless(defined(&TLB_E)) {
    sub TLB_E () {	0x8;}
}
unless(defined(&TLB_P)) {
    sub TLB_P () {	0x4;}
}
unless(defined(&TLB_W)) {
    sub TLB_W () {	0x2;}
}
unless(defined(&TLB_G)) {
    sub TLB_G () {	0x1;}
}
unless(defined(&TSB_DATA)) {
    sub TSB_DATA {
	local($g,$sz,$pa,$priv,$write,$cache,$aliased,$valid,$ie) = @_;
	eval q(((? &TLB_V:0)| &TLB_SZ|((($pa)) &TLB_PA_MASK)|(($cache)?(($aliased)? &TLB_CP: &TLB_CACHE_MASK): &TLB_E)|(($priv)? &TLB_P:0)|(($write)? &TLB_W:0)|(($g)? &TLB_G:0)|(($ie)? &TLB_IE:0)));
    }
}
unless(defined(&MMU_CACHE_VIRT)) {
    sub MMU_CACHE_VIRT () {	0x3;}
}
unless(defined(&MMU_CACHE_PHYS)) {
    sub MMU_CACHE_PHYS () {	0x2;}
}
unless(defined(&MMU_CACHE_NONE)) {
    sub MMU_CACHE_NONE () {	0x;}
}
unless(defined(&IOPTE_PPN_MASK)) {
    sub IOPTE_PPN_MASK () {	0x7ffff00;}
}
unless(defined(&IOPTE_PPN_SHIFT)) {
    sub IOPTE_PPN_SHIFT () {	8;}
}
unless(defined(&IOPTE_RSVD)) {
    sub IOPTE_RSVD () {	0xf1;}
}
unless(defined(&IOPTE_WRITE)) {
    sub IOPTE_WRITE () {	0x4;}
}
unless(defined(&IOPTE_VALID)) {
    sub IOPTE_VALID () {	0x2;}
}
1;
