require '_h2ph_pre.ph';

unless(defined(&PPC_IN_PDATA)) {
    sub PPC_IN_PDATA () {	0x;}
}
unless(defined(&PPC_IN_PSTAT)) {
    sub PPC_IN_PSTAT () {	0x1;}
}
unless(defined(&PPC_IN_CTRL)) {
    sub PPC_IN_CTRL () {	0x2;}
}
unless(defined(&PPC_IN_PWEIRD)) {
    sub PPC_IN_PWEIRD () {	0x3;}
}
unless(defined(&PPC_OUT_PDATA)) {
    sub PPC_OUT_PDATA () {	0x;}
}
unless(defined(&PPC_OUT_PSTAT)) {
    sub PPC_OUT_PSTAT () {	0x1;}
}
unless(defined(&PPC_OUT_PCTRL)) {
    sub PPC_OUT_PCTRL () {	0x2;}
}
unless(defined(&PPC_OUT_PWEIRD)) {
    sub PPC_OUT_PWEIRD () {	0x3;}
}
unless(defined(&PPC_IACK_PDATA)) {
    sub PPC_IACK_PDATA () {	0x1fc;}
}
unless(defined(&PPC_IACK_PSTAT)) {
    sub PPC_IACK_PSTAT () {	0x1fd;}
}
unless(defined(&PPC_IACK_PCTRL)) {
    sub PPC_IACK_PCTRL () {	0x1fe;}
}
unless(defined(&PPC_IACK_PWEIRD)) {
    sub PPC_IACK_PWEIRD () {	0x1ff;}
}
unless(defined(&PPC_PSTAT_ERROR)) {
    sub PPC_PSTAT_ERROR () {	0x8;}
}
unless(defined(&PPC_PSTAT_SELECT)) {
    sub PPC_PSTAT_SELECT () {	0x10;}
}
unless(defined(&PPC_PSTAT_PAPER)) {
    sub PPC_PSTAT_PAPER () {	0x20;}
}
unless(defined(&PPC_PSTAT_ACK)) {
    sub PPC_PSTAT_ACK () {	0x40;}
}
unless(defined(&PPC_PSTAT_BUSY)) {
    sub PPC_PSTAT_BUSY () {	0x80;}
}
unless(defined(&PPC_CTRL_STROBE)) {
    sub PPC_CTRL_STROBE () {	0x1;}
}
unless(defined(&PPC_CTRL_AFX)) {
    sub PPC_CTRL_AFX () {	0x2;}
}
unless(defined(&PPC_CTRL_INIT)) {
    sub PPC_CTRL_INIT () {	0x4;}
}
unless(defined(&PPC_CTRL_SLCT)) {
    sub PPC_CTRL_SLCT () {	0x8;}
}
unless(defined(&PPC_CTRL_IRQE)) {
    sub PPC_CTRL_IRQE () {	0x10;}
}
unless(defined(&PPC_CTRL_OUTPUT)) {
    sub PPC_CTRL_OUTPUT () {	0x20;}
}
unless(defined(&STC_CCR)) {
    sub STC_CCR () {	0x1;}
}
unless(defined(&STC_SRER)) {
    sub STC_SRER () {	0x2;}
}
unless(defined(&STC_COR1)) {
    sub STC_COR1 () {	0x3;}
}
unless(defined(&STC_COR2)) {
    sub STC_COR2 () {	0x4;}
}
unless(defined(&STC_COR3)) {
    sub STC_COR3 () {	0x5;}
}
unless(defined(&STC_CCSR)) {
    sub STC_CCSR () {	0x6;}
}
unless(defined(&STC_RDCR)) {
    sub STC_RDCR () {	0x7;}
}
unless(defined(&STC_SCHR1)) {
    sub STC_SCHR1 () {	0x9;}
}
unless(defined(&STC_SCHR2)) {
    sub STC_SCHR2 () {	0xa;}
}
unless(defined(&STC_SCHR3)) {
    sub STC_SCHR3 () {	0xb;}
}
unless(defined(&STC_SCHR4)) {
    sub STC_SCHR4 () {	0xc;}
}
unless(defined(&STC_MCOR1)) {
    sub STC_MCOR1 () {	0x10;}
}
unless(defined(&STC_MCOR2)) {
    sub STC_MCOR2 () {	0x11;}
}
unless(defined(&STC_MCR)) {
    sub STC_MCR () {	0x12;}
}
unless(defined(&STC_RTPR)) {
    sub STC_RTPR () {	0x18;}
}
unless(defined(&STC_MSVR)) {
    sub STC_MSVR () {	0x28;}
}
unless(defined(&STC_MSVRTS)) {
    sub STC_MSVRTS () {	0x29;}
}
unless(defined(&STC_MSVDTR)) {
    sub STC_MSVDTR () {	0x2a;}
}
unless(defined(&STC_RBPRH)) {
    sub STC_RBPRH () {	0x31;}
}
unless(defined(&STC_RBPRL)) {
    sub STC_RBPRL () {	0x32;}
}
unless(defined(&STC_RBR)) {
    sub STC_RBR () {	0x33;}
}
unless(defined(&STC_TBPRH)) {
    sub STC_TBPRH () {	0x39;}
}
unless(defined(&STC_TBPRL)) {
    sub STC_TBPRL () {	0x3a;}
}
unless(defined(&STC_GSVR)) {
    sub STC_GSVR () {	0x40;}
}
unless(defined(&STC_GSCR1)) {
    sub STC_GSCR1 () {	0x41;}
}
unless(defined(&STC_GSCR2)) {
    sub STC_GSCR2 () {	0x42;}
}
unless(defined(&STC_GSCR3)) {
    sub STC_GSCR3 () {	0x43;}
}
unless(defined(&STC_MSMR)) {
    sub STC_MSMR () {	0x61;}
}
unless(defined(&STC_TSMR)) {
    sub STC_TSMR () {	0x62;}
}
unless(defined(&STC_RSMR)) {
    sub STC_RSMR () {	0x63;}
}
unless(defined(&STC_CAR)) {
    sub STC_CAR () {	0x64;}
}
unless(defined(&STC_SRSR)) {
    sub STC_SRSR () {	0x65;}
}
unless(defined(&STC_SRCR)) {
    sub STC_SRCR () {	0x66;}
}
unless(defined(&STC_GFRCR)) {
    sub STC_GFRCR () {	0x6b;}
}
unless(defined(&STC_PPRH)) {
    sub STC_PPRH () {	0x70;}
}
unless(defined(&STC_PPRL)) {
    sub STC_PPRL () {	0x71;}
}
unless(defined(&STC_MRAR)) {
    sub STC_MRAR () {	0x75;}
}
unless(defined(&STC_TRAR)) {
    sub STC_TRAR () {	0x76;}
}
unless(defined(&STC_RRAR)) {
    sub STC_RRAR () {	0x77;}
}
unless(defined(&STC_RDR)) {
    sub STC_RDR () {	0x78;}
}
unless(defined(&STC_RCSR)) {
    sub STC_RCSR () {	0x7a;}
}
unless(defined(&STC_TDR)) {
    sub STC_TDR () {	0x7b;}
}
unless(defined(&STC_EOSRR)) {
    sub STC_EOSRR () {	0x7f;}
}
unless(defined(&STC_REGMAPSIZE)) {
    sub STC_REGMAPSIZE () {	0x80;}
}
unless(defined(&CD180_GFRCR_REV_B)) {
    sub CD180_GFRCR_REV_B () {	0x81;}
}
unless(defined(&CD180_GFRCR_REV_C)) {
    sub CD180_GFRCR_REV_C () {	0x82;}
}
unless(defined(&CD180_SRCR_PKGTYP)) {
    sub CD180_SRCR_PKGTYP () {	0x80;}
}
unless(defined(&CD180_SRCR_REGACKEN)) {
    sub CD180_SRCR_REGACKEN () {	0x40;}
}
unless(defined(&CD180_SRCR_DAISYEN)) {
    sub CD180_SRCR_DAISYEN () {	0x20;}
}
unless(defined(&CD180_SRCR_GLOBPRI)) {
    sub CD180_SRCR_GLOBPRI () {	0x10;}
}
unless(defined(&CD180_SRCR_UNFAIR)) {
    sub CD180_SRCR_UNFAIR () {	0x8;}
}
unless(defined(&CD180_SRCR_AUTOPRI)) {
    sub CD180_SRCR_AUTOPRI () {	0x2;}
}
unless(defined(&CD180_SRCR_PRISEL)) {
    sub CD180_SRCR_PRISEL () {	0x1;}
}
unless(defined(&CD180_PPRH)) {
    sub CD180_PPRH () {	0xf0;}
}
unless(defined(&CD180_PPRL)) {
    sub CD180_PPRL () {	0x;}
}
unless(defined(&CD180_GSVR_USERMASK)) {
    sub CD180_GSVR_USERMASK () {	0xf8;}
}
unless(defined(&CD180_GSVR_IMASK)) {
    sub CD180_GSVR_IMASK () {	0x7;}
}
unless(defined(&CD180_GSVR_NOREQUEST)) {
    sub CD180_GSVR_NOREQUEST () {	0x;}
}
unless(defined(&CD180_GSVR_STATCHG)) {
    sub CD180_GSVR_STATCHG () {	0x1;}
}
unless(defined(&CD180_GSVR_TXDATA)) {
    sub CD180_GSVR_TXDATA () {	0x2;}
}
unless(defined(&CD180_GSVR_RXGOOD)) {
    sub CD180_GSVR_RXGOOD () {	0x3;}
}
unless(defined(&CD180_GSVR_reserved1)) {
    sub CD180_GSVR_reserved1 () {	0x4;}
}
unless(defined(&CD180_GSVR_reserved2)) {
    sub CD180_GSVR_reserved2 () {	0x5;}
}
unless(defined(&CD180_GSVR_reserved3)) {
    sub CD180_GSVR_reserved3 () {	0x6;}
}
unless(defined(&CD180_GSVR_RXEXCEPTION)) {
    sub CD180_GSVR_RXEXCEPTION () {	0x7;}
}
unless(defined(&CD180_SRSR_MREQINT)) {
    sub CD180_SRSR_MREQINT () {	0x1;}
}
unless(defined(&CD180_SRSR_MREQEXT)) {
    sub CD180_SRSR_MREQEXT () {	0x2;}
}
unless(defined(&CD180_SRSR_TREQINT)) {
    sub CD180_SRSR_TREQINT () {	0x4;}
}
unless(defined(&CD180_SRSR_TREQEXT)) {
    sub CD180_SRSR_TREQEXT () {	0x8;}
}
unless(defined(&CD180_SRSR_RREQINT)) {
    sub CD180_SRSR_RREQINT () {	0x10;}
}
unless(defined(&CD180_SRSR_RREQEXT)) {
    sub CD180_SRSR_RREQEXT () {	0x20;}
}
unless(defined(&CD180_SRSR_ILV_MASK)) {
    sub CD180_SRSR_ILV_MASK () {	0xc0;}
}
unless(defined(&CD180_SRSR_ILV_NONE)) {
    sub CD180_SRSR_ILV_NONE () {	0x;}
}
unless(defined(&CD180_SRSR_ILV_RX)) {
    sub CD180_SRSR_ILV_RX () {	0xc0;}
}
unless(defined(&CD180_SRSR_ILV_TX)) {
    sub CD180_SRSR_ILV_TX () {	0x80;}
}
unless(defined(&CD180_SRSR_ILV_MODEM)) {
    sub CD180_SRSR_ILV_MODEM () {	0x40;}
}
unless(defined(&CD180_GSCR_CHANNEL)) {
    sub CD180_GSCR_CHANNEL {
	local($gscr) = @_;
	eval q(((($gscr) >> 2) & 7));
    }
}
unless(defined(&CD180_RDCR_MASK)) {
    sub CD180_RDCR_MASK () {	0xf;}
}
unless(defined(&CD180_RCSR_TO)) {
    sub CD180_RCSR_TO () {	0x80;}
}
unless(defined(&CD180_RCSR_SCD2)) {
    sub CD180_RCSR_SCD2 () {	0x40;}
}
unless(defined(&CD180_RCSR_SCD1)) {
    sub CD180_RCSR_SCD1 () {	0x20;}
}
unless(defined(&CD180_RCSR_SCD0)) {
    sub CD180_RCSR_SCD0 () {	0x10;}
}
unless(defined(&CD180_RCSR_BE)) {
    sub CD180_RCSR_BE () {	0x8;}
}
unless(defined(&CD180_RCSR_PE)) {
    sub CD180_RCSR_PE () {	0x4;}
}
unless(defined(&CD180_RCSR_FE)) {
    sub CD180_RCSR_FE () {	0x2;}
}
unless(defined(&CD180_RCSR_OE)) {
    sub CD180_RCSR_OE () {	0x1;}
}
unless(defined(&CD180_SRER_DSR)) {
    sub CD180_SRER_DSR () {	0x80;}
}
unless(defined(&CD180_SRER_CD)) {
    sub CD180_SRER_CD () {	0x40;}
}
unless(defined(&CD180_SRER_CTS)) {
    sub CD180_SRER_CTS () {	0x20;}
}
unless(defined(&CD180_SRER_RXD)) {
    sub CD180_SRER_RXD () {	0x10;}
}
unless(defined(&CD180_SRER_RXSCD)) {
    sub CD180_SRER_RXSCD () {	0x8;}
}
unless(defined(&CD180_SRER_TXD)) {
    sub CD180_SRER_TXD () {	0x4;}
}
unless(defined(&CD180_SRER_TXE)) {
    sub CD180_SRER_TXE () {	0x2;}
}
unless(defined(&CD180_SRER_NNDT)) {
    sub CD180_SRER_NNDT () {	0x1;}
}
unless(defined(&CD180_CCR_CMD_RESET)) {
    sub CD180_CCR_CMD_RESET () {	0x80;}
}
unless(defined(&CD180_CCR_RESETALL)) {
    sub CD180_CCR_RESETALL () {	0x1;}
}
unless(defined(&CD180_CCR_RESETCHAN)) {
    sub CD180_CCR_RESETCHAN () {	0x;}
}
unless(defined(&CD180_CCR_CMD_COR)) {
    sub CD180_CCR_CMD_COR () {	0x40;}
}
unless(defined(&CD180_CCR_CORCHG1)) {
    sub CD180_CCR_CORCHG1 () {	0x2;}
}
unless(defined(&CD180_CCR_CORCHG2)) {
    sub CD180_CCR_CORCHG2 () {	0x4;}
}
unless(defined(&CD180_CCR_CORCHG3)) {
    sub CD180_CCR_CORCHG3 () {	0x8;}
}
unless(defined(&CD180_CCR_CMD_SPC)) {
    sub CD180_CCR_CMD_SPC () {	0x20;}
}
unless(defined(&CD180_CCR_SSPC0)) {
    sub CD180_CCR_SSPC0 () {	0x1;}
}
unless(defined(&CD180_CCR_SSPC1)) {
    sub CD180_CCR_SSPC1 () {	0x2;}
}
unless(defined(&CD180_CCR_SSPC2)) {
    sub CD180_CCR_SSPC2 () {	0x4;}
}
unless(defined(&CD180_CCR_CMD_CHAN)) {
    sub CD180_CCR_CMD_CHAN () {	0x10;}
}
unless(defined(&CD180_CCR_CHAN_TXEN)) {
    sub CD180_CCR_CHAN_TXEN () {	0x8;}
}
unless(defined(&CD180_CCR_CHAN_TXDIS)) {
    sub CD180_CCR_CHAN_TXDIS () {	0x4;}
}
unless(defined(&CD180_CCR_CHAN_RXEN)) {
    sub CD180_CCR_CHAN_RXEN () {	0x2;}
}
unless(defined(&CD180_CCR_CHAN_RXDIS)) {
    sub CD180_CCR_CHAN_RXDIS () {	0x1;}
}
unless(defined(&CD180_COR1_EVENPAR)) {
    sub CD180_COR1_EVENPAR () {	0x;}
}
unless(defined(&CD180_COR1_ODDPAR)) {
    sub CD180_COR1_ODDPAR () {	0x80;}
}
unless(defined(&CD180_COR1_PARMODE_NO)) {
    sub CD180_COR1_PARMODE_NO () {	0x;}
}
unless(defined(&CD180_COR1_PARMODE_FORCE)) {
    sub CD180_COR1_PARMODE_FORCE () {	0x20;}
}
unless(defined(&CD180_COR1_PARMODE_NORMAL)) {
    sub CD180_COR1_PARMODE_NORMAL () {	0x40;}
}
unless(defined(&CD180_COR1_PARMODE_NA)) {
    sub CD180_COR1_PARMODE_NA () {	0x60;}
}
unless(defined(&CD180_COR1_IGNPAR)) {
    sub CD180_COR1_IGNPAR () {	0x10;}
}
unless(defined(&CD180_COR1_STOP1)) {
    sub CD180_COR1_STOP1 () {	0x;}
}
unless(defined(&CD180_COR1_STOP15)) {
    sub CD180_COR1_STOP15 () {	0x4;}
}
unless(defined(&CD180_COR1_STOP2)) {
    sub CD180_COR1_STOP2 () {	0x8;}
}
unless(defined(&CD180_COR1_STOP25)) {
    sub CD180_COR1_STOP25 () {	0xc;}
}
unless(defined(&CD180_COR1_CS5)) {
    sub CD180_COR1_CS5 () {	0x;}
}
unless(defined(&CD180_COR1_CS6)) {
    sub CD180_COR1_CS6 () {	0x1;}
}
unless(defined(&CD180_COR1_CS7)) {
    sub CD180_COR1_CS7 () {	0x2;}
}
unless(defined(&CD180_COR1_CS8)) {
    sub CD180_COR1_CS8 () {	0x3;}
}
unless(defined(&CD180_COR2_IXM)) {
    sub CD180_COR2_IXM () {	0x80;}
}
unless(defined(&CD180_COR2_TXIBE)) {
    sub CD180_COR2_TXIBE () {	0x40;}
}
unless(defined(&CD180_COR2_ETC)) {
    sub CD180_COR2_ETC () {	0x20;}
}
unless(defined(&CD180_COR2_LLM)) {
    sub CD180_COR2_LLM () {	0x10;}
}
unless(defined(&CD180_COR2_RLM)) {
    sub CD180_COR2_RLM () {	0x8;}
}
unless(defined(&CD180_COR2_RTSAO)) {
    sub CD180_COR2_RTSAO () {	0x4;}
}
unless(defined(&CD180_COR2_CTSAE)) {
    sub CD180_COR2_CTSAE () {	0x2;}
}
unless(defined(&CD180_COR2_DSRAE)) {
    sub CD180_COR2_DSRAE () {	0x1;}
}
unless(defined(&CD180_COR3_XON2)) {
    sub CD180_COR3_XON2 () {	0x80;}
}
unless(defined(&CD180_COR3_XON1)) {
    sub CD180_COR3_XON1 () {	0x;}
}
unless(defined(&CD180_COR3_XOFF2)) {
    sub CD180_COR3_XOFF2 () {	0x40;}
}
unless(defined(&CD180_COR3_XOFF1)) {
    sub CD180_COR3_XOFF1 () {	0x;}
}
unless(defined(&CD180_COR3_FCT)) {
    sub CD180_COR3_FCT () {	0x20;}
}
unless(defined(&CD180_COR3_SCDE)) {
    sub CD180_COR3_SCDE () {	0x10;}
}
unless(defined(&CD180_COR3_RXFIFO_MASK)) {
    sub CD180_COR3_RXFIFO_MASK () {	0xf;}
}
unless(defined(&CD180_CCSR_RXEN)) {
    sub CD180_CCSR_RXEN () {	0x80;}
}
unless(defined(&CD180_CCSR_RXFLOFF)) {
    sub CD180_CCSR_RXFLOFF () {	0x40;}
}
unless(defined(&CD180_CCSR_RXFLON)) {
    sub CD180_CCSR_RXFLON () {	0x20;}
}
unless(defined(&CD180_CCSR_TXEN)) {
    sub CD180_CCSR_TXEN () {	0x8;}
}
unless(defined(&CD180_CCSR_TXFLOFF)) {
    sub CD180_CCSR_TXFLOFF () {	0x4;}
}
unless(defined(&CD180_CCSR_TXFLON)) {
    sub CD180_CCSR_TXFLON () {	0x2;}
}
unless(defined(&CD180_RBR_RXD)) {
    sub CD180_RBR_RXD () {	0x40;}
}
unless(defined(&CD180_RBR_STARTHUNT)) {
    sub CD180_RBR_STARTHUNT () {	0x20;}
}
unless(defined(&CD180_MCR_DSR)) {
    sub CD180_MCR_DSR () {	0x80;}
}
unless(defined(&CD180_MCR_CD)) {
    sub CD180_MCR_CD () {	0x40;}
}
unless(defined(&CD180_MCR_CTS)) {
    sub CD180_MCR_CTS () {	0x20;}
}
unless(defined(&CD180_MCOR1_DSRZD)) {
    sub CD180_MCOR1_DSRZD () {	0x80;}
}
unless(defined(&CD180_MCOR1_CDZD)) {
    sub CD180_MCOR1_CDZD () {	0x40;}
}
unless(defined(&CD180_MCOR1_CTSZD)) {
    sub CD180_MCOR1_CTSZD () {	0x40;}
}
unless(defined(&CD180_MCOR1_DTRTHRESH)) {
    sub CD180_MCOR1_DTRTHRESH () {	0xf;}
}
unless(defined(&CD180_MCOR2_DSROD)) {
    sub CD180_MCOR2_DSROD () {	0x80;}
}
unless(defined(&CD180_MCOR2_CDOD)) {
    sub CD180_MCOR2_CDOD () {	0x40;}
}
unless(defined(&CD180_MCOR2_CTSOD)) {
    sub CD180_MCOR2_CTSOD () {	0x20;}
}
unless(defined(&CD180_MSVR_DSR)) {
    sub CD180_MSVR_DSR () {	0x80;}
}
unless(defined(&CD180_MSVR_CD)) {
    sub CD180_MSVR_CD () {	0x40;}
}
unless(defined(&CD180_MSVR_CTS)) {
    sub CD180_MSVR_CTS () {	0x20;}
}
unless(defined(&CD180_MSVR_DTR)) {
    sub CD180_MSVR_DTR () {	0x2;}
}
unless(defined(&CD180_MSVR_RTS)) {
    sub CD180_MSVR_RTS () {	0x1;}
}
unless(defined(&CD180_MSVRTS_RTS)) {
    sub CD180_MSVRTS_RTS () {	0x1;}
}
unless(defined(&CD180_MSVDTR_DTR)) {
    sub CD180_MSVDTR_DTR () {	0x2;}
}
unless(defined(&DTR_REG_OFFSET)) {
    sub DTR_REG_OFFSET () {	0x400;}
}
unless(defined(&DTR_REG_LEN)) {
    sub DTR_REG_LEN () {	0x8;}
}
unless(defined(&STC_REG_OFFSET)) {
    sub STC_REG_OFFSET () {	0x800;}
}
unless(defined(&STC_REG_LEN)) {
    sub STC_REG_LEN () {	0x80;}
}
unless(defined(&ISTC_REG_OFFSET)) {
    sub ISTC_REG_OFFSET () {	0xc00;}
}
unless(defined(&ISTC_REG_LEN)) {
    sub ISTC_REG_LEN () {	 &STC_REG_LEN;}
}
unless(defined(&PPC_REG_OFFSET)) {
    sub PPC_REG_OFFSET () {	0xe00;}
}
unless(defined(&PPC_REG_LEN)) {
    sub PPC_REG_LEN () {	0x200;}
}
unless(defined(&SPIF_MAX_CARDS)) {
    sub SPIF_MAX_CARDS () {	4;}
}
unless(defined(&SPIF_MAX_TTY)) {
    sub SPIF_MAX_TTY () {	8;}
}
unless(defined(&SPIF_MAX_BPP)) {
    sub SPIF_MAX_BPP () {	1;}
}
unless(defined(&SPIF_CARD)) {
    sub SPIF_CARD {
	local($x) = @_;
	eval q((( &minor($x) >> 6) & 0x3));
    }
}
unless(defined(&SPIF_PORT)) {
    sub SPIF_PORT {
	local($x) = @_;
	eval q(( &minor($x) & 0x7));
    }
}
unless(defined(&STTY_DIALOUT)) {
    sub STTY_DIALOUT {
	local($x) = @_;
	eval q(( &minor($x) & 0x10));
    }
}
unless(defined(&STTY_RX_FIFO_THRESHOLD)) {
    sub STTY_RX_FIFO_THRESHOLD () {	4;}
}
unless(defined(&STTY_RX_DTR_THRESHOLD)) {
    sub STTY_RX_DTR_THRESHOLD () {	7;}
}
unless(defined(&CD180_TX_FIFO_SIZE)) {
    sub CD180_TX_FIFO_SIZE () {	8;}
}
unless(defined(&SPIF_MSMR)) {
    sub SPIF_MSMR () {	(0x80 |  &STC_MRAR);}
}
unless(defined(&SPIF_TSMR)) {
    sub SPIF_TSMR () {	(0x80 |  &STC_TRAR);}
}
unless(defined(&SPIF_RSMR)) {
    sub SPIF_RSMR () {	(0x80 |  &STC_RRAR);}
}
unless(defined(&SPIF_OSC9)) {
    sub SPIF_OSC9 () {	1;}
}
unless(defined(&SPIF_OSC10)) {
    sub SPIF_OSC10 () {	2;}
}
unless(defined(&SERIAL_INTR)) {
    sub SERIAL_INTR () {	0;}
}
unless(defined(&PARALLEL_INTR)) {
    sub PARALLEL_INTR () {	1;}
}
unless(defined(&STTYF_CDCHG)) {
    sub STTYF_CDCHG () {	0x1;}
}
unless(defined(&STTYF_RING_OVERFLOW)) {
    sub STTYF_RING_OVERFLOW () {	0x2;}
}
unless(defined(&STTYF_DONE)) {
    sub STTYF_DONE () {	0x4;}
}
unless(defined(&STTYF_SET_BREAK)) {
    sub STTYF_SET_BREAK () {	0x8;}
}
unless(defined(&STTYF_CLR_BREAK)) {
    sub STTYF_CLR_BREAK () {	0x10;}
}
unless(defined(&STTYF_STOP)) {
    sub STTYF_STOP () {	0x20;}
}
unless(defined(&STTY_RBUF_SIZE)) {
    sub STTY_RBUF_SIZE () {	(2* 512);}
}
1;
