require '_h2ph_pre.ph';

unless(defined(&RAY_MAXSSIDLEN)) {
    sub RAY_MAXSSIDLEN () {	32;}
}
unless(defined(&RAY_COR)) {
    sub RAY_COR () {	(0x);}
}
unless(defined(&RAY_CCSR)) {
    sub RAY_CCSR () {	(0x1);}
}
unless(defined(&RAY_PIN)) {
    sub RAY_PIN () {	(0x2);}
}
unless(defined(&RAY_SOCKETCOPY)) {
    sub RAY_SOCKETCOPY () {	(0x3);}
}
unless(defined(&RAY_HCSIR)) {
    sub RAY_HCSIR () {	(0x5);}
}
unless(defined(&RAY_ECFIR)) {
    sub RAY_ECFIR () {	(0x6);}
}
unless(defined(&RAY_AR0)) {
    sub RAY_AR0 () {	(0x8);}
}
unless(defined(&RAY_AR1)) {
    sub RAY_AR1 () {	(0x9);}
}
if(0) {
    eval 'sub RAY_PMR () {0xa;}' unless defined(&RAY_PMR);
    eval 'sub RAY_TMR () {0xb;}' unless defined(&RAY_TMR);
    eval 'sub RAY_FCWR () {0x10;}' unless defined(&RAY_FCWR);
    eval 'sub RAY_TMC1 () {0x14;}' unless defined(&RAY_TMC1);
    eval 'sub RAY_TMC2 () {0x15;}' unless defined(&RAY_TMC2);
    eval 'sub RAY_TMC3 () {0x16;}' unless defined(&RAY_TMC3);
    eval 'sub RAY_TMC4 () {0x17;}' unless defined(&RAY_TMC4);
}
unless(defined(&RAY_COR_CFG_NUM)) {
    sub RAY_COR_CFG_NUM () {	0x1;}
}
unless(defined(&RAY_COR_CFG_MASK)) {
    sub RAY_COR_CFG_MASK () {	0x3f;}
}
unless(defined(&RAY_COR_LEVEL_IRQ)) {
    sub RAY_COR_LEVEL_IRQ () {	0x40;}
}
unless(defined(&RAY_COR_RESET)) {
    sub RAY_COR_RESET () {	0x80;}
}
unless(defined(&RAY_CCS_IRQ)) {
    sub RAY_CCS_IRQ () {	0x2;}
}
unless(defined(&RAY_CCS_POWER_DOWN)) {
    sub RAY_CCS_POWER_DOWN () {	0x4;}
}
unless(defined(&RAY_HCSIR_IRQ)) {
    sub RAY_HCSIR_IRQ () {	0x1;}
}
unless(defined(&RAY_ECSIR_IRQ)) {
    sub RAY_ECSIR_IRQ () {	0x1;}
}
unless(defined(&RAY_AR0_ON)) {
    sub RAY_AR0_ON () {	0x57;}
}
unless(defined(&RAY_AR1_ON)) {
    sub RAY_AR1_ON () {	0x82;}
}
unless(defined(&RAY_PMR_PC2PM)) {
    sub RAY_PMR_PC2PM () {	0x2;}
}
unless(defined(&RAY_PMR_PC2CAL)) {
    sub RAY_PMR_PC2CAL () {	0x10;}
}
unless(defined(&RAY_PMR_MLSE)) {
    sub RAY_PMR_MLSE () {	0x20;}
}
unless(defined(&RAY_TMR_TEST)) {
    sub RAY_TMR_TEST () {	0x8;}
}
unless(defined(&RAY_SRAM_MEM_BASE)) {
    sub RAY_SRAM_MEM_BASE () {	0;}
}
unless(defined(&RAY_SRAM_MEM_SIZE)) {
    sub RAY_SRAM_MEM_SIZE () {	0xc000;}
}
unless(defined(&RAY_SCB_BASE)) {
    sub RAY_SCB_BASE () {	0x;}
}
unless(defined(&RAY_STATUS_BASE)) {
    sub RAY_STATUS_BASE () {	0x100;}
}
unless(defined(&RAY_HOST_TO_ECF_BASE)) {
    sub RAY_HOST_TO_ECF_BASE () {	0x200;}
}
unless(defined(&RAY_ECF_TO_HOST_BASE)) {
    sub RAY_ECF_TO_HOST_BASE () {	0x300;}
}
unless(defined(&RAY_CCS_BASE)) {
    sub RAY_CCS_BASE () {	0x400;}
}
unless(defined(&RAY_RCS_BASE)) {
    sub RAY_RCS_BASE () {	0x800;}
}
unless(defined(&RAY_APOINT_TIM_BASE)) {
    sub RAY_APOINT_TIM_BASE () {	0xc00;}
}
unless(defined(&RAY_SSID_LIST_BASE)) {
    sub RAY_SSID_LIST_BASE () {	0xd00;}
}
unless(defined(&RAY_TX_BASE)) {
    sub RAY_TX_BASE () {	0x1000;}
}
unless(defined(&RAY_TX_SIZE)) {
    sub RAY_TX_SIZE () {	0x7000;}
}
unless(defined(&RAY_TX_END)) {
    sub RAY_TX_END () {	0x8000;}
}
unless(defined(&RAY_RX_BASE)) {
    sub RAY_RX_BASE () {	0x8000;}
}
unless(defined(&RAY_RX_END)) {
    sub RAY_RX_END () {	0xc000;}
}
unless(defined(&RAY_RX_MASK)) {
    sub RAY_RX_MASK () {	0x3fff;}
}
unless(defined(&RAY_ECFS_RESERVED0)) {
    sub RAY_ECFS_RESERVED0 () {	0x1;}
}
unless(defined(&RAY_ECFS_PROC_SELF_TEST)) {
    sub RAY_ECFS_PROC_SELF_TEST () {	0x2;}
}
unless(defined(&RAY_ECFS_PROG_MEM_CHECKSUM)) {
    sub RAY_ECFS_PROG_MEM_CHECKSUM () {	0x4;}
}
unless(defined(&RAY_ECFS_DATA_MEM_TEST)) {
    sub RAY_ECFS_DATA_MEM_TEST () {	0x8;}
}
unless(defined(&RAY_ECFS_RX_CALIBRATION)) {
    sub RAY_ECFS_RX_CALIBRATION () {	0x10;}
}
unless(defined(&RAY_ECFS_FW_VERSION_COMPAT)) {
    sub RAY_ECFS_FW_VERSION_COMPAT () {	0x20;}
}
unless(defined(&RAY_ECFS_RERSERVED1)) {
    sub RAY_ECFS_RERSERVED1 () {	0x40;}
}
unless(defined(&RAY_ECFS_TEST_COMPLETE)) {
    sub RAY_ECFS_TEST_COMPLETE () {	0x80;}
}
unless(defined(&RAY_ECFS_CARD_OK)) {
    sub RAY_ECFS_CARD_OK () {	 &RAY_ECFS_TEST_COMPLETE;}
}
unless(defined(&RAY_PID_NET_TYPE)) {
    sub RAY_PID_NET_TYPE () {	0;}
}
unless(defined(&RAY_PID_AP_STATUS)) {
    sub RAY_PID_AP_STATUS () {	1;}
}
unless(defined(&RAY_PID_SSID)) {
    sub RAY_PID_SSID () {	2;}
}
unless(defined(&RAY_PID_SCAN_MODE)) {
    sub RAY_PID_SCAN_MODE () {	3;}
}
unless(defined(&RAY_PID_APM_MODE)) {
    sub RAY_PID_APM_MODE () {	4;}
}
unless(defined(&RAY_PID_MAC_ADDR)) {
    sub RAY_PID_MAC_ADDR () {	5;}
}
unless(defined(&RAY_PID_FRAG_THRESH)) {
    sub RAY_PID_FRAG_THRESH () {	6;}
}
unless(defined(&RAY_PID_DWELL_TIME)) {
    sub RAY_PID_DWELL_TIME () {	7;}
}
unless(defined(&RAY_PID_BEACON_PERIOD)) {
    sub RAY_PID_BEACON_PERIOD () {	8;}
}
unless(defined(&RAY_PID_DTIM_INT)) {
    sub RAY_PID_DTIM_INT () {	9;}
}
unless(defined(&RAY_PID_MAX_RETRY)) {
    sub RAY_PID_MAX_RETRY () {	10;}
}
unless(defined(&RAY_PID_ACK_TIMO)) {
    sub RAY_PID_ACK_TIMO () {	11;}
}
unless(defined(&RAY_PID_SIFS)) {
    sub RAY_PID_SIFS () {	12;}
}
unless(defined(&RAY_PID_DIFS)) {
    sub RAY_PID_DIFS () {	13;}
}
unless(defined(&RAY_PID_PIFS)) {
    sub RAY_PID_PIFS () {	14;}
}
unless(defined(&RAY_PID_RTS_THRESH)) {
    sub RAY_PID_RTS_THRESH () {	15;}
}
unless(defined(&RAY_PID_SCAN_DWELL_PERIOD)) {
    sub RAY_PID_SCAN_DWELL_PERIOD () {	16;}
}
unless(defined(&RAY_PID_MAX_SCAN_DWELL_PERIOD)) {
    sub RAY_PID_MAX_SCAN_DWELL_PERIOD () {	17;}
}
unless(defined(&RAY_PID_ASSOC_TIMO)) {
    sub RAY_PID_ASSOC_TIMO () {	18;}
}
unless(defined(&RAY_PID_ADHOC_SCAN_CYCLE)) {
    sub RAY_PID_ADHOC_SCAN_CYCLE () {	19;}
}
unless(defined(&RAY_PID_INFRA_SCAN_CYCLE)) {
    sub RAY_PID_INFRA_SCAN_CYCLE () {	20;}
}
unless(defined(&RAY_PID_INFRA_SUPER_SCAN_CYCLE)) {
    sub RAY_PID_INFRA_SUPER_SCAN_CYCLE () {	21;}
}
unless(defined(&RAY_PID_PROMISC)) {
    sub RAY_PID_PROMISC () {	22;}
}
unless(defined(&RAY_PID_UNIQ_WORD)) {
    sub RAY_PID_UNIQ_WORD () {	23;}
}
unless(defined(&RAY_PID_SLOT_TIME)) {
    sub RAY_PID_SLOT_TIME () {	24;}
}
unless(defined(&RAY_PID_ROAM_LOW_SNR_THRESH)) {
    sub RAY_PID_ROAM_LOW_SNR_THRESH () {	25;}
}
unless(defined(&RAY_PID_LOW_SNR_COUNT)) {
    sub RAY_PID_LOW_SNR_COUNT () {	26;}
}
unless(defined(&RAY_PID_INFRA_MISSED_BEACON_COUNT)) {
    sub RAY_PID_INFRA_MISSED_BEACON_COUNT () {	27;}
}
unless(defined(&RAY_PID_ADHOC_MISSED_BEACON_COUNT)) {
    sub RAY_PID_ADHOC_MISSED_BEACON_COUNT () {	28;}
}
unless(defined(&RAY_PID_COUNTRY_CODE)) {
    sub RAY_PID_COUNTRY_CODE () {	29;}
}
unless(defined(&RAY_PID_HOP_SEQ)) {
    sub RAY_PID_HOP_SEQ () {	30;}
}
unless(defined(&RAY_PID_HOP_SEQ_LEN)) {
    sub RAY_PID_HOP_SEQ_LEN () {	31;}
}
unless(defined(&RAY_PID_CW_MAX)) {
    sub RAY_PID_CW_MAX () {	32;}
}
unless(defined(&RAY_PID_CW_MIN)) {
    sub RAY_PID_CW_MIN () {	33;}
}
unless(defined(&RAY_PID_NOISE_FILTER_GAIN)) {
    sub RAY_PID_NOISE_FILTER_GAIN () {	34;}
}
unless(defined(&RAY_PID_NOISE_LIMIT_OFFSET)) {
    sub RAY_PID_NOISE_LIMIT_OFFSET () {	35;}
}
unless(defined(&RAY_PID_RSSI_THRESH_OFFSET)) {
    sub RAY_PID_RSSI_THRESH_OFFSET () {	36;}
}
unless(defined(&RAY_PID_BUSY_THRESH_OFFSET)) {
    sub RAY_PID_BUSY_THRESH_OFFSET () {	37;}
}
unless(defined(&RAY_PID_SYNC_THRESH)) {
    sub RAY_PID_SYNC_THRESH () {	38;}
}
unless(defined(&RAY_PID_TEST_MODE)) {
    sub RAY_PID_TEST_MODE () {	39;}
}
unless(defined(&RAY_PID_TEST_MIN_CHAN)) {
    sub RAY_PID_TEST_MIN_CHAN () {	40;}
}
unless(defined(&RAY_PID_TEST_MAX_CHAN)) {
    sub RAY_PID_TEST_MAX_CHAN () {	41;}
}
unless(defined(&RAY_PID_ALLOW_PROBE_RESP)) {
    sub RAY_PID_ALLOW_PROBE_RESP () {	42;}
}
unless(defined(&RAY_PID_PRIVACY_MUST_START)) {
    sub RAY_PID_PRIVACY_MUST_START () {	43;}
}
unless(defined(&RAY_PID_PRIVACY_CAN_JOIN)) {
    sub RAY_PID_PRIVACY_CAN_JOIN () {	44;}
}
unless(defined(&RAY_PID_BASIC_RATE_SET)) {
    sub RAY_PID_BASIC_RATE_SET () {	45;}
}
unless(defined(&RAY_PID_MAX)) {
    sub RAY_PID_MAX () {	46;}
}
unless(defined(&RAY_PID_NET_TYPE_ADHOC)) {
    sub RAY_PID_NET_TYPE_ADHOC () {	0x;}
}
unless(defined(&RAY_PID_NET_TYPE_INFRA)) {
    sub RAY_PID_NET_TYPE_INFRA () {	0x1;}
}
unless(defined(&RAY_PID_AP_STATUS_TERMINAL)) {
    sub RAY_PID_AP_STATUS_TERMINAL () {	0x;}
}
unless(defined(&RAY_PID_AP_STATUS_AP)) {
    sub RAY_PID_AP_STATUS_AP () {	0x1;}
}
unless(defined(&RAY_PID_SCAN_MODE_PASSIVE)) {
    sub RAY_PID_SCAN_MODE_PASSIVE () {	0x;}
}
unless(defined(&RAY_PID_SCAN_MODE_ACTIVE)) {
    sub RAY_PID_SCAN_MODE_ACTIVE () {	0x1;}
}
unless(defined(&RAY_PID_APM_MODE_NONE)) {
    sub RAY_PID_APM_MODE_NONE () {	0x;}
}
unless(defined(&RAY_PID_APM_MODE_PS)) {
    sub RAY_PID_APM_MODE_PS () {	0x1;}
}
unless(defined(&RAY_PID_COUNTRY_CODE_USA)) {
    sub RAY_PID_COUNTRY_CODE_USA () {	0x1;}
}
unless(defined(&RAY_PID_COUNTRY_CODE_EUROPE)) {
    sub RAY_PID_COUNTRY_CODE_EUROPE () {	0x2;}
}
unless(defined(&RAY_PID_COUNTRY_CODE_JAPAN)) {
    sub RAY_PID_COUNTRY_CODE_JAPAN () {	0x3;}
}
unless(defined(&RAY_PID_COUNTRY_CODE_KOREA)) {
    sub RAY_PID_COUNTRY_CODE_KOREA () {	0x4;}
}
unless(defined(&RAY_PID_COUNTRY_CODE_SPAIN)) {
    sub RAY_PID_COUNTRY_CODE_SPAIN () {	0x5;}
}
unless(defined(&RAY_PID_COUNTRY_CODE_FRANCE)) {
    sub RAY_PID_COUNTRY_CODE_FRANCE () {	0x6;}
}
unless(defined(&RAY_PID_COUNTRY_CODE_ISRAEL)) {
    sub RAY_PID_COUNTRY_CODE_ISRAEL () {	0x7;}
}
unless(defined(&RAY_PID_COUNTRY_CODE_AUSTRALIA)) {
    sub RAY_PID_COUNTRY_CODE_AUSTRALIA () {	0x8;}
}
unless(defined(&RAY_PID_COUNTRY_CODE_JAPAN_TEST)) {
    sub RAY_PID_COUNTRY_CODE_JAPAN_TEST () {	0x9;}
}
unless(defined(&RAY_PID_COUNTRY_CODE_MAX)) {
    sub RAY_PID_COUNTRY_CODE_MAX () {	0xa;}
}
unless(defined(&RAY_PID_TEST_MODE_NORMAL)) {
    sub RAY_PID_TEST_MODE_NORMAL () {	0x;}
}
unless(defined(&RAY_PID_TEST_MODE_ANT_1)) {
    sub RAY_PID_TEST_MODE_ANT_1 () {	0x1;}
}
unless(defined(&RAY_PID_TEST_MODE_ATN_2)) {
    sub RAY_PID_TEST_MODE_ATN_2 () {	0x2;}
}
unless(defined(&RAY_PID_TEST_MODE_ATN_BOTH)) {
    sub RAY_PID_TEST_MODE_ATN_BOTH () {	0x3;}
}
unless(defined(&RAY_PID_ALLOW_PROBE_RESP_DISALLOW)) {
    sub RAY_PID_ALLOW_PROBE_RESP_DISALLOW () {	0x;}
}
unless(defined(&RAY_PID_ALLOW_PROBE_RESP_ALLOW)) {
    sub RAY_PID_ALLOW_PROBE_RESP_ALLOW () {	0x1;}
}
unless(defined(&RAY_PID_PRIVACY_MUST_START_NOWEP)) {
    sub RAY_PID_PRIVACY_MUST_START_NOWEP () {	0x;}
}
unless(defined(&RAY_PID_PRIVACY_MUST_START_WEP)) {
    sub RAY_PID_PRIVACY_MUST_START_WEP () {	0x1;}
}
unless(defined(&RAY_PID_PRIVACY_CAN_JOIN_NOWEP)) {
    sub RAY_PID_PRIVACY_CAN_JOIN_NOWEP () {	0x;}
}
unless(defined(&RAY_PID_PRIVACY_CAN_JOIN_WEP)) {
    sub RAY_PID_PRIVACY_CAN_JOIN_WEP () {	0x1;}
}
unless(defined(&RAY_PID_PRIVACY_CAN_JOIN_DONT_CARE)) {
    sub RAY_PID_PRIVACY_CAN_JOIN_DONT_CARE () {	0x2;}
}
unless(defined(&RAY_PID_BASIC_RATE_500K)) {
    sub RAY_PID_BASIC_RATE_500K () {	1;}
}
unless(defined(&RAY_PID_BASIC_RATE_1000K)) {
    sub RAY_PID_BASIC_RATE_1000K () {	2;}
}
unless(defined(&RAY_PID_BASIC_RATE_1500K)) {
    sub RAY_PID_BASIC_RATE_1500K () {	3;}
}
unless(defined(&RAY_PID_BASIC_RATE_2000K)) {
    sub RAY_PID_BASIC_RATE_2000K () {	4;}
}
unless(defined(&RAY_SCB_CCSI)) {
    sub RAY_SCB_CCSI () {	0x;}
}
unless(defined(&RAY_SCB_RCCSI)) {
    sub RAY_SCB_RCCSI () {	0x1;}
}
unless(defined(&RAY_CMD_START_PARAMS)) {
    sub RAY_CMD_START_PARAMS () {	0x1;}
}
unless(defined(&RAY_CMD_UPDATE_PARAMS)) {
    sub RAY_CMD_UPDATE_PARAMS () {	0x2;}
}
unless(defined(&RAY_CMD_REPORT_PARAMS)) {
    sub RAY_CMD_REPORT_PARAMS () {	0x3;}
}
unless(defined(&RAY_CMD_UPDATE_MCAST)) {
    sub RAY_CMD_UPDATE_MCAST () {	0x4;}
}
unless(defined(&RAY_CMD_UPDATE_APM)) {
    sub RAY_CMD_UPDATE_APM () {	0x5;}
}
unless(defined(&RAY_CMD_START_NET)) {
    sub RAY_CMD_START_NET () {	0x6;}
}
unless(defined(&RAY_CMD_JOIN_NET)) {
    sub RAY_CMD_JOIN_NET () {	0x7;}
}
unless(defined(&RAY_CMD_START_ASSOC)) {
    sub RAY_CMD_START_ASSOC () {	0x8;}
}
unless(defined(&RAY_CMD_TX_REQ)) {
    sub RAY_CMD_TX_REQ () {	0x9;}
}
unless(defined(&RAY_CMD_TEST_MEM)) {
    sub RAY_CMD_TEST_MEM () {	0xa;}
}
unless(defined(&RAY_CMD_SHUTDOWN)) {
    sub RAY_CMD_SHUTDOWN () {	0xb;}
}
unless(defined(&RAY_CMD_DUMP_MEM)) {
    sub RAY_CMD_DUMP_MEM () {	0xc;}
}
unless(defined(&RAY_CMD_START_TIMER)) {
    sub RAY_CMD_START_TIMER () {	0xd;}
}
unless(defined(&RAY_CMD_MAX)) {
    sub RAY_CMD_MAX () {	0xe;}
}
unless(defined(&RAY_ECMD_RX_DONE)) {
    sub RAY_ECMD_RX_DONE () {	0x80;}
}
unless(defined(&RAY_ECMD_REJOIN_DONE)) {
    sub RAY_ECMD_REJOIN_DONE () {	0x81;}
}
unless(defined(&RAY_ECMD_ROAM_START)) {
    sub RAY_ECMD_ROAM_START () {	0x82;}
}
unless(defined(&RAY_ECMD_JAPAN_CALL_SIGNAL)) {
    sub RAY_ECMD_JAPAN_CALL_SIGNAL () {	0x83;}
}
unless(defined(&RAY_CCS_LINK_NULL)) {
    sub RAY_CCS_LINK_NULL () {	0xff;}
}
unless(defined(&RAY_CCS_SIZE)) {
    sub RAY_CCS_SIZE () {	16;}
}
unless(defined(&RAY_CCS_TX_FIRST)) {
    sub RAY_CCS_TX_FIRST () {	0;}
}
unless(defined(&RAY_CCS_TX_LAST)) {
    sub RAY_CCS_TX_LAST () {	13;}
}
unless(defined(&RAY_CCS_NTX)) {
    sub RAY_CCS_NTX () {	( &RAY_CCS_TX_LAST -  &RAY_CCS_TX_FIRST + 1);}
}
unless(defined(&RAY_TX_BUF_SIZE)) {
    sub RAY_TX_BUF_SIZE () {	2048;}
}
unless(defined(&RAY_CCS_CMD_FIRST)) {
    sub RAY_CCS_CMD_FIRST () {	14;}
}
unless(defined(&RAY_CCS_CMD_LAST)) {
    sub RAY_CCS_CMD_LAST () {	63;}
}
unless(defined(&RAY_CCS_NCMD)) {
    sub RAY_CCS_NCMD () {	( &RAY_CCS_CMD_LAST -  &RAY_CCS_CMD_FIRST + 1);}
}
unless(defined(&RAY_CCS_LAST)) {
    sub RAY_CCS_LAST () {	63;}
}
unless(defined(&RAY_RCCS_FIRST)) {
    sub RAY_RCCS_FIRST () {	64;}
}
unless(defined(&RAY_RCCS_LAST)) {
    sub RAY_RCCS_LAST () {	127;}
}
unless(defined(&RAY_CCS_STATUS_FREE)) {
    sub RAY_CCS_STATUS_FREE () {	0x;}
}
unless(defined(&RAY_CCS_STATUS_BUSY)) {
    sub RAY_CCS_STATUS_BUSY () {	0x1;}
}
unless(defined(&RAY_CCS_STATUS_COMPLETE)) {
    sub RAY_CCS_STATUS_COMPLETE () {	0x2;}
}
unless(defined(&RAY_CCS_STATUS_FAIL)) {
    sub RAY_CCS_STATUS_FAIL () {	0x3;}
}
unless(defined(&RAY_TX_PHY_SIZE)) {
    sub RAY_TX_PHY_SIZE () {	0x4;}
}
unless(defined(&RAY_FAILCAUSE_EIDRANGE)) {
    sub RAY_FAILCAUSE_EIDRANGE () {	1;}
}
unless(defined(&RAY_FAILCAUSE_ELENGTH)) {
    sub RAY_FAILCAUSE_ELENGTH () {	2;}
}
unless(defined(&RAY_FAILCAUSE_EDEVSTOP)) {
    sub RAY_FAILCAUSE_EDEVSTOP () {	256;}
}
if(defined(&_KERNEL)) {
    eval 'sub RAY_FAILCAUSE_WAITING () {257;}' unless defined(&RAY_FAILCAUSE_WAITING);
}
unless(defined(&SIOCGIFGENERIC)) {
    eval 'sub SIOCGIFGENERIC () { &_IOWR(ord(\'i\'), 57, \'struct ifreq\');}' unless defined(&SIOCGIFGENERIC);
}
unless(defined(&SIOCSIFGENERIC)) {
    eval 'sub SIOCSIFGENERIC () { &_IOWR(ord(\'i\'), 58, \'struct ifreq\');}' unless defined(&SIOCSIFGENERIC);
}
unless(defined(&SIOCSRAYPARAM)) {
    sub SIOCSRAYPARAM () {	 &SIOCSIFGENERIC;}
}
unless(defined(&SIOCGRAYPARAM)) {
    sub SIOCGRAYPARAM () {	 &SIOCGIFGENERIC;}
}
unless(defined(&RAY_PID_STRINGS)) {
    sub RAY_PID_STRINGS () {	{ "RAY_PID_NET_TYPE", "RAY_PID_AP_STATUS", "RAY_PID_SSID", "RAY_PID_SCAN_MODE", "RAY_PID_APM_MODE", "RAY_PID_MAC_ADDR", "RAY_PID_FRAG_THRESH", "RAY_PID_DWELL_TIME", "RAY_PID_BEACON_PERIOD", "RAY_PID_DTIM_INT", "RAY_PID_MAX_RETRY", "RAY_PID_ACK_TIMO", "RAY_PID_SIFS", "RAY_PID_DIFS", "RAY_PID_PIFS", "RAY_PID_RTS_THRESH", "RAY_PID_SCAN_DWELL_PERIOD", "RAY_PID_MAX_SCAN_DWELL_PERIOD", "RAY_PID_ASSOC_TIMO", "RAY_PID_ADHOC_SCAN_CYCLE", "RAY_PID_INFRA_SCAN_CYCLE", "RAY_PID_INFRA_SUPER_SCAN_CYCLE", "RAY_PID_PROMISC", "RAY_PID_UNIQ_WORD", "RAY_PID_SLOT_TIME", "RAY_PID_ROAM_LOW_SNR_THRESH", "RAY_PID_LOW_SNR_COUNT", "RAY_PID_INFRA_MISSED_BEACON_COUNT", "RAY_PID_ADHOC_MISSED_BEACON_COUNT", "RAY_PID_COUNTRY_CODE", "RAY_PID_HOP_SEQ", "RAY_PID_HOP_SEQ_LEN", "RAY_PID_CW_MAX", "RAY_PID_CW_MIN", "RAY_PID_NOISE_FILTER_GAIN", "RAY_PID_NOISE_LIMIT_OFFSET", "RAY_PID_RSSI_THRESH_OFFSET", "RAY_PID_BUSY_THRESH_OFFSET", "RAY_PID_SYNC_THRESH", "RAY_PID_TEST_MODE", "RAY_PID_TEST_MIN_CHAN", "RAY_PID_TEST_MAX_CHAN", "RAY_PID_ALLOW_PROBE_RESP", "RAY_PID_PRIVACY_MUST_START", "RAY_PID_PRIVACY_CAN_JOIN", "RAY_PID_BASIC_RATE_SET" };}
}
if(defined(&RAY_DO_SIGLEV)) {
    eval 'sub SIOCGRAYSIGLEV () { &_IOWR(ord(\'i\'), 201, \'struct ifreq\');}' unless defined(&SIOCGRAYSIGLEV);
    eval 'sub RAY_NSIGLEVRECS () {8;}' unless defined(&RAY_NSIGLEVRECS);
    eval 'sub RAY_NSIGLEV () {8;}' unless defined(&RAY_NSIGLEV);
}
1;
