require '_h2ph_pre.ph';

require 'sys/buf.ph';
require 'ufs/ufs/dinode.ph';
require 'ufs/ufs/dir.ph';
require 'ufs/ext2fs/ext2fs_dinode.ph';
unless(defined(&i_fs)) {
    sub i_fs () {	 ($inode_u->{fs});}
}
unless(defined(&i_lfs)) {
    sub i_lfs () {	 ($inode_u->{lfs});}
}
unless(defined(&i_e2fs)) {
    sub i_e2fs () {	 ($inode_u->{e2fs});}
}
unless(defined(&i_e2fs_last_lblk)) {
    sub i_e2fs_last_lblk () {	 ($inode_ext->{e2fs}->{ext2fs_last_lblk});}
}
unless(defined(&i_e2fs_last_blk)) {
    sub i_e2fs_last_blk () {	 ($inode_ext->{e2fs}->{ext2fs_last_blk});}
}
unless(defined(&i_din1)) {
    sub i_din1 () {	 ($dinode_u->{ffs1_din});}
}
unless(defined(&i_e2din)) {
    sub i_e2din () {	 ($dinode_u->{e2fs_din});}
}
unless(defined(&UFS_TRUNCATE)) {
    sub UFS_TRUNCATE {
	local($ip, $off, $flags, $cred) = @_;
	eval q((($ip)-> ($i_vtbl->{iv_truncate}))(($ip), ($off), ($flags), ($cred)));
    }
}
unless(defined(&UFS_UPDATE)) {
    sub UFS_UPDATE {
	local($ip, $sync) = @_;
	eval q((($ip)-> ($i_vtbl->{iv_update}))(($ip),  &NULL,  &NULL, ($sync)));
    }
}
unless(defined(&UFS_UPDATE2)) {
    sub UFS_UPDATE2 {
	local($ip, $atime, $mtime, $sync) = @_;
	eval q((($ip)-> ($i_vtbl->{iv_update}))(($ip), ($atime), ($mtime), ($sync)));
    }
}
unless(defined(&UFS_INODE_ALLOC)) {
    sub UFS_INODE_ALLOC {
	local($pip, $mode, $cred, $vpp) = @_;
	eval q((($pip)-> ($i_vtbl->{iv_inode_alloc}))(($pip), ($mode), ($cred), ($vpp)));
    }
}
unless(defined(&UFS_INODE_FREE)) {
    sub UFS_INODE_FREE {
	local($pip, $ino, $mode) = @_;
	eval q((($pip)-> ($i_vtbl->{iv_inode_free}))(($pip), ($ino), ($mode)));
    }
}
unless(defined(&UFS_BUF_ALLOC)) {
    sub UFS_BUF_ALLOC {
	local($ip, $startoffset, $size, $cred, $flags, $bpp) = @_;
	eval q((($ip)-> ($i_vtbl->{iv_buf_alloc}))(($ip), ($startoffset), ($size), ($cred), ($flags), ($bpp)));
    }
}
unless(defined(&UFS_BUFATOFF)) {
    sub UFS_BUFATOFF {
	local($ip, $offset, $res, $bpp) = @_;
	eval q((($ip)-> ($i_vtbl->{iv_bufatoff}))(($ip), ($offset), ($res), ($bpp)));
    }
}
unless(defined(&i_ffs_atime)) {
    sub i_ffs_atime () {	 ($i_din1->{di_atime});}
}
unless(defined(&i_ffs_atimensec)) {
    sub i_ffs_atimensec () {	 ($i_din1->{di_atimensec});}
}
unless(defined(&i_ffs_blocks)) {
    sub i_ffs_blocks () {	 ($i_din1->{di_blocks});}
}
unless(defined(&i_ffs_ctime)) {
    sub i_ffs_ctime () {	 ($i_din1->{di_ctime});}
}
unless(defined(&i_ffs_ctimensec)) {
    sub i_ffs_ctimensec () {	 ($i_din1->{di_ctimensec});}
}
unless(defined(&i_ffs_db)) {
    sub i_ffs_db () {	 ($i_din1->{di_db});}
}
unless(defined(&i_ffs_flags)) {
    sub i_ffs_flags () {	 ($i_din1->{di_flags});}
}
unless(defined(&i_ffs_gen)) {
    sub i_ffs_gen () {	 ($i_din1->{di_gen});}
}
unless(defined(&i_ffs_gid)) {
    sub i_ffs_gid () {	 ($i_din1->{di_gid});}
}
unless(defined(&i_ffs_ib)) {
    sub i_ffs_ib () {	 ($i_din1->{di_ib});}
}
unless(defined(&i_ffs_mode)) {
    sub i_ffs_mode () {	 ($i_din1->{di_mode});}
}
unless(defined(&i_ffs_mtime)) {
    sub i_ffs_mtime () {	 ($i_din1->{di_mtime});}
}
unless(defined(&i_ffs_mtimensec)) {
    sub i_ffs_mtimensec () {	 ($i_din1->{di_mtimensec});}
}
unless(defined(&i_ffs_nlink)) {
    sub i_ffs_nlink () {	 ($i_din1->{di_nlink});}
}
unless(defined(&i_ffs_rdev)) {
    sub i_ffs_rdev () {	 ($i_din1->{di_rdev});}
}
unless(defined(&i_ffs_shortlink)) {
    sub i_ffs_shortlink () {	 ($i_din1->{di_shortlink});}
}
unless(defined(&i_ffs_size)) {
    sub i_ffs_size () {	 ($i_din1->{di_size});}
}
unless(defined(&i_ffs_uid)) {
    sub i_ffs_uid () {	 ($i_din1->{di_uid});}
}
unless(defined(&_KERNEL)) {
    eval 'sub i_atime () { ($i_din1->{di_atime});}' unless defined(&i_atime);
    eval 'sub i_atimensec () { ($i_din1->{di_atimensec});}' unless defined(&i_atimensec);
    eval 'sub i_blocks () { ($i_din1->{di_blocks});}' unless defined(&i_blocks);
    eval 'sub i_ctime () { ($i_din1->{di_ctime});}' unless defined(&i_ctime);
    eval 'sub i_ctimensec () { ($i_din1->{di_ctimensec});}' unless defined(&i_ctimensec);
    eval 'sub i_db () { ($i_din1->{di_db});}' unless defined(&i_db);
    eval 'sub i_flags () { ($i_din1->{di_flags});}' unless defined(&i_flags);
    eval 'sub i_gen () { ($i_din1->{di_gen});}' unless defined(&i_gen);
    eval 'sub i_gid () { ($i_din1->{di_gid});}' unless defined(&i_gid);
    eval 'sub i_ib () { ($i_din1->{di_ib});}' unless defined(&i_ib);
    eval 'sub i_mode () { ($i_din1->{di_mode});}' unless defined(&i_mode);
    eval 'sub i_mtime () { ($i_din1->{di_mtime});}' unless defined(&i_mtime);
    eval 'sub i_mtimensec () { ($i_din1->{di_mtimensec});}' unless defined(&i_mtimensec);
    eval 'sub i_nlink () { ($i_din1->{di_nlink});}' unless defined(&i_nlink);
    eval 'sub i_rdev () { ($i_din1->{di_rdev});}' unless defined(&i_rdev);
    eval 'sub i_shortlink () { ($i_din1->{di_shortlink});}' unless defined(&i_shortlink);
    eval 'sub i_size () { ($i_din1->{di_size});}' unless defined(&i_size);
    eval 'sub i_uid () { ($i_din1->{di_uid});}' unless defined(&i_uid);
}
unless(defined(&i_e2fs_mode)) {
    sub i_e2fs_mode () {	 ($i_e2din->{e2di_mode});}
}
unless(defined(&i_e2fs_uid)) {
    sub i_e2fs_uid () {	 ($i_e2din->{e2di_uid});}
}
unless(defined(&i_e2fs_size)) {
    sub i_e2fs_size () {	 ($i_e2din->{e2di_size});}
}
unless(defined(&i_e2fs_atime)) {
    sub i_e2fs_atime () {	 ($i_e2din->{e2di_atime});}
}
unless(defined(&i_e2fs_ctime)) {
    sub i_e2fs_ctime () {	 ($i_e2din->{e2di_ctime});}
}
unless(defined(&i_e2fs_mtime)) {
    sub i_e2fs_mtime () {	 ($i_e2din->{e2di_mtime});}
}
unless(defined(&i_e2fs_dtime)) {
    sub i_e2fs_dtime () {	 ($i_e2din->{e2di_dtime});}
}
unless(defined(&i_e2fs_gid)) {
    sub i_e2fs_gid () {	 ($i_e2din->{e2di_gid});}
}
unless(defined(&i_e2fs_nlink)) {
    sub i_e2fs_nlink () {	 ($i_e2din->{e2di_nlink});}
}
unless(defined(&i_e2fs_nblock)) {
    sub i_e2fs_nblock () {	 ($i_e2din->{e2di_nblock});}
}
unless(defined(&i_e2fs_flags)) {
    sub i_e2fs_flags () {	 ($i_e2din->{e2di_flags});}
}
unless(defined(&i_e2fs_blocks)) {
    sub i_e2fs_blocks () {	 ($i_e2din->{e2di_blocks});}
}
unless(defined(&i_e2fs_gen)) {
    sub i_e2fs_gen () {	 ($i_e2din->{e2di_gen});}
}
unless(defined(&i_e2fs_facl)) {
    sub i_e2fs_facl () {	 ($i_e2din->{e2di_facl});}
}
unless(defined(&i_e2fs_dacl)) {
    sub i_e2fs_dacl () {	 ($i_e2din->{e2di_dacl});}
}
unless(defined(&i_e2fs_faddr)) {
    sub i_e2fs_faddr () {	 ($i_e2din->{e2di_faddr});}
}
unless(defined(&i_e2fs_nfrag)) {
    sub i_e2fs_nfrag () {	 ($i_e2din->{e2di_nfrag});}
}
unless(defined(&i_e2fs_fsize)) {
    sub i_e2fs_fsize () {	 ($i_e2din->{e2di_fsize});}
}
unless(defined(&IN_ACCESS)) {
    sub IN_ACCESS () {	0x1;}
}
unless(defined(&IN_CHANGE)) {
    sub IN_CHANGE () {	0x2;}
}
unless(defined(&IN_UPDATE)) {
    sub IN_UPDATE () {	0x4;}
}
unless(defined(&IN_MODIFIED)) {
    sub IN_MODIFIED () {	0x8;}
}
unless(defined(&IN_RENAME)) {
    sub IN_RENAME () {	0x10;}
}
unless(defined(&IN_SHLOCK)) {
    sub IN_SHLOCK () {	0x20;}
}
unless(defined(&IN_EXLOCK)) {
    sub IN_EXLOCK () {	0x40;}
}
if(defined(&_KERNEL)) {
    eval 'sub DIP {
        local($ip, $field) = @_;
	    eval q((($ip)-> ($i_din1->{d})$field));
    }' unless defined(&DIP);
    eval 'sub VTOI {
        local($vp) = @_;
	    eval q((($vp)-> &v_data));
    }' unless defined(&VTOI);
    eval 'sub ITOV {
        local($ip) = @_;
	    eval q((($ip)-> &i_vnode));
    }' unless defined(&ITOV);
    eval 'sub FFS_ITIMES {
        local($ip, $t1, $t2) = @_;
	    eval q({  &if (($ip)-> &i_flag & ( &IN_ACCESS |  &IN_CHANGE |  &IN_UPDATE)) { ($ip)-> &i_flag |=  &IN_MODIFIED;  &if (($ip)-> &i_flag &  &IN_ACCESS) ($ip)-> &i_ffs_atime = ($t1)-> &tv_sec;  &if (($ip)-> &i_flag &  &IN_UPDATE) { ($ip)-> &i_ffs_mtime = ($t2)-> &tv_sec; ($ip)-> &i_modrev++; }  &if (($ip)-> &i_flag &  &IN_CHANGE) ($ip)-> &i_ffs_ctime =  ($time->{tv_sec}); ($ip)-> &i_flag &= ~( &IN_ACCESS |  &IN_CHANGE |  &IN_UPDATE); } });
    }' unless defined(&FFS_ITIMES);
    eval 'sub EXT2FS_ITIMES {
        local($ip, $t1, $t2) = @_;
	    eval q({  &if (($ip)-> &i_flag & ( &IN_ACCESS |  &IN_CHANGE |  &IN_UPDATE)) { ($ip)-> &i_flag |=  &IN_MODIFIED;  &if (($ip)-> &i_flag &  &IN_ACCESS) ($ip)-> &i_e2fs_atime = ($t1)-> &tv_sec;  &if (($ip)-> &i_flag &  &IN_UPDATE) { ($ip)-> &i_e2fs_mtime = ($t2)-> &tv_sec; ($ip)-> &i_modrev++; }  &if (($ip)-> &i_flag &  &IN_CHANGE) ($ip)-> &i_e2fs_ctime =  ($time->{tv_sec}); ($ip)-> &i_flag &= ~( &IN_ACCESS |  &IN_CHANGE |  &IN_UPDATE); } });
    }' unless defined(&EXT2FS_ITIMES);
    eval 'sub ITIMES {
        local($ip, $t1, $t2) = @_;
	    eval q({  &if ( &IS_EXT2_VNODE(($ip)-> &i_vnode)) {  &EXT2FS_ITIMES($ip, $t1, $t2); }  &else {  &FFS_ITIMES($ip, $t1, $t2); } });
    }' unless defined(&ITIMES);
    if(defined(&FFS_SOFTUPDATES)) {
	eval 'sub DOINGSOFTDEP {
	    local($vp) = @_;
    	    eval q((($vp)-> ($v_mount->{mnt_flag}) &  &MNT_SOFTDEP));
	}' unless defined(&DOINGSOFTDEP);
    } else {
	eval 'sub DOINGSOFTDEP {
	    local($vp) = @_;
    	    eval q((0));
	}' unless defined(&DOINGSOFTDEP);
    }
    eval 'sub DOINGASYNC {
        local($vp) = @_;
	    eval q((($vp)-> ($v_mount->{mnt_flag}) &  &MNT_ASYNC));
    }' unless defined(&DOINGASYNC);
}
1;
