require '_h2ph_pre.ph';

unless(defined(&PCI_LEGACY_AUDIO_CTRL)) {
    sub PCI_LEGACY_AUDIO_CTRL () {	0x40;}
}
unless(defined(&DISABLE_LEGACY)) {
    sub DISABLE_LEGACY () {	0x8000;}
}
unless(defined(&ESA_PCI_ALLEGRO_CONFIG)) {
    sub ESA_PCI_ALLEGRO_CONFIG () {	0x50;}
}
unless(defined(&ESA_SB_ADDR_240)) {
    sub ESA_SB_ADDR_240 () {	0x4;}
}
unless(defined(&ESA_MPU_ADDR_MASK)) {
    sub ESA_MPU_ADDR_MASK () {	0x18;}
}
unless(defined(&ESA_MPU_ADDR_330)) {
    sub ESA_MPU_ADDR_330 () {	0x;}
}
unless(defined(&ESA_MPU_ADDR_300)) {
    sub ESA_MPU_ADDR_300 () {	0x8;}
}
unless(defined(&ESA_MPU_ADDR_320)) {
    sub ESA_MPU_ADDR_320 () {	0x10;}
}
unless(defined(&ESA_MPU_ADDR_340)) {
    sub ESA_MPU_ADDR_340 () {	0x18;}
}
unless(defined(&ESA_USE_PCI_TIMING)) {
    sub ESA_USE_PCI_TIMING () {	0x40;}
}
unless(defined(&ESA_POSTED_WRITE_ENABLE)) {
    sub ESA_POSTED_WRITE_ENABLE () {	0x80;}
}
unless(defined(&ESA_DMA_POLICY_MASK)) {
    sub ESA_DMA_POLICY_MASK () {	0x700;}
}
unless(defined(&ESA_DMA_DDMA)) {
    sub ESA_DMA_DDMA () {	0x;}
}
unless(defined(&ESA_DMA_TDMA)) {
    sub ESA_DMA_TDMA () {	0x100;}
}
unless(defined(&ESA_DMA_PCPCI)) {
    sub ESA_DMA_PCPCI () {	0x200;}
}
unless(defined(&ESA_DMA_WBDMA16)) {
    sub ESA_DMA_WBDMA16 () {	0x400;}
}
unless(defined(&ESA_DMA_WBDMA4)) {
    sub ESA_DMA_WBDMA4 () {	0x500;}
}
unless(defined(&ESA_DMA_WBDMA2)) {
    sub ESA_DMA_WBDMA2 () {	0x600;}
}
unless(defined(&ESA_DMA_WBDMA1)) {
    sub ESA_DMA_WBDMA1 () {	0x700;}
}
unless(defined(&ESA_DMA_SAFE_GUARD)) {
    sub ESA_DMA_SAFE_GUARD () {	0x800;}
}
unless(defined(&ESA_HI_PERF_GP_ENABLE)) {
    sub ESA_HI_PERF_GP_ENABLE () {	0x1000;}
}
unless(defined(&ESA_PIC_SNOOP_MODE_0)) {
    sub ESA_PIC_SNOOP_MODE_0 () {	0x2000;}
}
unless(defined(&ESA_PIC_SNOOP_MODE_1)) {
    sub ESA_PIC_SNOOP_MODE_1 () {	0x4000;}
}
unless(defined(&ESA_SOUNDBLASTER_IRQ_MASK)) {
    sub ESA_SOUNDBLASTER_IRQ_MASK () {	0x8000;}
}
unless(defined(&ESA_RING_IN_ENABLE)) {
    sub ESA_RING_IN_ENABLE () {	0x10000;}
}
unless(defined(&ESA_SPDIF_TEST_MODE)) {
    sub ESA_SPDIF_TEST_MODE () {	0x20000;}
}
unless(defined(&ESA_CLK_MULT_MODE_SELECT_2)) {
    sub ESA_CLK_MULT_MODE_SELECT_2 () {	0x40000;}
}
unless(defined(&ESA_EEPROM_WRITE_ENABLE)) {
    sub ESA_EEPROM_WRITE_ENABLE () {	0x80000;}
}
unless(defined(&ESA_CODEC_DIR_IN)) {
    sub ESA_CODEC_DIR_IN () {	0x100000;}
}
unless(defined(&ESA_HV_BUTTON_FROM_GD)) {
    sub ESA_HV_BUTTON_FROM_GD () {	0x200000;}
}
unless(defined(&ESA_REDUCED_DEBOUNCE)) {
    sub ESA_REDUCED_DEBOUNCE () {	0x400000;}
}
unless(defined(&ESA_HV_CTRL_ENABLE)) {
    sub ESA_HV_CTRL_ENABLE () {	0x800000;}
}
unless(defined(&ESA_SPDIF_ENABLE)) {
    sub ESA_SPDIF_ENABLE () {	0x1000000;}
}
unless(defined(&ESA_CLK_DIV_SELECT)) {
    sub ESA_CLK_DIV_SELECT () {	0x6000000;}
}
unless(defined(&ESA_CLK_DIV_BY_48)) {
    sub ESA_CLK_DIV_BY_48 () {	0x;}
}
unless(defined(&ESA_CLK_DIV_BY_49)) {
    sub ESA_CLK_DIV_BY_49 () {	0x2000000;}
}
unless(defined(&ESA_CLK_DIV_BY_50)) {
    sub ESA_CLK_DIV_BY_50 () {	0x4000000;}
}
unless(defined(&ESA_CLK_DIV_RESERVED)) {
    sub ESA_CLK_DIV_RESERVED () {	0x6000000;}
}
unless(defined(&ESA_PM_CTRL_ENABLE)) {
    sub ESA_PM_CTRL_ENABLE () {	0x8000000;}
}
unless(defined(&ESA_CLK_MULT_MODE_SELECT)) {
    sub ESA_CLK_MULT_MODE_SELECT () {	0x30000000;}
}
unless(defined(&ESA_CLK_MULT_MODE_SHIFT)) {
    sub ESA_CLK_MULT_MODE_SHIFT () {	28;}
}
unless(defined(&ESA_CLK_MULT_MODE_0)) {
    sub ESA_CLK_MULT_MODE_0 () {	0x;}
}
unless(defined(&ESA_CLK_MULT_MODE_1)) {
    sub ESA_CLK_MULT_MODE_1 () {	0x10000000;}
}
unless(defined(&ESA_CLK_MULT_MODE_2)) {
    sub ESA_CLK_MULT_MODE_2 () {	0x20000000;}
}
unless(defined(&ESA_CLK_MULT_MODE_3)) {
    sub ESA_CLK_MULT_MODE_3 () {	0x30000000;}
}
unless(defined(&ESA_INT_CLK_SELECT)) {
    sub ESA_INT_CLK_SELECT () {	0x40000000;}
}
unless(defined(&ESA_INT_CLK_MULT_RESET)) {
    sub ESA_INT_CLK_MULT_RESET () {	0x80000000;}
}
unless(defined(&ESA_INT_CLK_SRC_NOT_PCI)) {
    sub ESA_INT_CLK_SRC_NOT_PCI () {	0x100000;}
}
unless(defined(&ESA_INT_CLK_MULT_ENABLE)) {
    sub ESA_INT_CLK_MULT_ENABLE () {	0x80000000;}
}
unless(defined(&ESA_PCI_ACPI_CONTROL)) {
    sub ESA_PCI_ACPI_CONTROL () {	0x54;}
}
unless(defined(&ESA_PCI_ACPI_D0)) {
    sub ESA_PCI_ACPI_D0 () {	0x;}
}
unless(defined(&ESA_PCI_ACPI_D1)) {
    sub ESA_PCI_ACPI_D1 () {	0xb4f70000;}
}
unless(defined(&ESA_PCI_ACPI_D2)) {
    sub ESA_PCI_ACPI_D2 () {	0xb4f7b4f7;}
}
unless(defined(&ESA_PCI_USER_CONFIG)) {
    sub ESA_PCI_USER_CONFIG () {	0x58;}
}
unless(defined(&ESA_EXT_PCI_MASTER_ENABLE)) {
    sub ESA_EXT_PCI_MASTER_ENABLE () {	0x1;}
}
unless(defined(&ESA_SPDIF_OUT_SELECT)) {
    sub ESA_SPDIF_OUT_SELECT () {	0x2;}
}
unless(defined(&ESA_TEST_PIN_DIR_CTRL)) {
    sub ESA_TEST_PIN_DIR_CTRL () {	0x4;}
}
unless(defined(&ESA_AC97_CODEC_TEST)) {
    sub ESA_AC97_CODEC_TEST () {	0x20;}
}
unless(defined(&ESA_TRI_STATE_BUFFER)) {
    sub ESA_TRI_STATE_BUFFER () {	0x80;}
}
unless(defined(&ESA_IN_CLK_12MHZ_SELECT)) {
    sub ESA_IN_CLK_12MHZ_SELECT () {	0x100;}
}
unless(defined(&ESA_MULTI_FUNC_DISABLE)) {
    sub ESA_MULTI_FUNC_DISABLE () {	0x200;}
}
unless(defined(&ESA_EXT_MASTER_PAIR_SEL)) {
    sub ESA_EXT_MASTER_PAIR_SEL () {	0x400;}
}
unless(defined(&ESA_PCI_MASTER_SUPPORT)) {
    sub ESA_PCI_MASTER_SUPPORT () {	0x800;}
}
unless(defined(&ESA_STOP_CLOCK_ENABLE)) {
    sub ESA_STOP_CLOCK_ENABLE () {	0x1000;}
}
unless(defined(&ESA_EAPD_DRIVE_ENABLE)) {
    sub ESA_EAPD_DRIVE_ENABLE () {	0x2000;}
}
unless(defined(&ESA_REQ_TRI_STATE_ENABLE)) {
    sub ESA_REQ_TRI_STATE_ENABLE () {	0x4000;}
}
unless(defined(&ESA_REQ_LOW_ENABLE)) {
    sub ESA_REQ_LOW_ENABLE () {	0x8000;}
}
unless(defined(&ESA_MIDI_1_ENABLE)) {
    sub ESA_MIDI_1_ENABLE () {	0x10000;}
}
unless(defined(&ESA_MIDI_2_ENABLE)) {
    sub ESA_MIDI_2_ENABLE () {	0x20000;}
}
unless(defined(&ESA_SB_AUDIO_SYNC)) {
    sub ESA_SB_AUDIO_SYNC () {	0x40000;}
}
unless(defined(&ESA_HV_CTRL_TEST)) {
    sub ESA_HV_CTRL_TEST () {	0x100000;}
}
unless(defined(&ESA_SOUNDBLASTER_TEST)) {
    sub ESA_SOUNDBLASTER_TEST () {	0x400000;}
}
unless(defined(&ESA_PCI_USER_CONFIG_C)) {
    sub ESA_PCI_USER_CONFIG_C () {	0x5c;}
}
unless(defined(&ESA_PCI_DDMA_CTRL)) {
    sub ESA_PCI_DDMA_CTRL () {	0x60;}
}
unless(defined(&ESA_DDMA_ENABLE)) {
    sub ESA_DDMA_ENABLE () {	0x1;}
}
unless(defined(&ESA_HOST_INT_CTRL)) {
    sub ESA_HOST_INT_CTRL () {	0x18;}
}
unless(defined(&ESA_SB_INT_ENABLE)) {
    sub ESA_SB_INT_ENABLE () {	0x1;}
}
unless(defined(&ESA_MPU401_INT_ENABLE)) {
    sub ESA_MPU401_INT_ENABLE () {	0x2;}
}
unless(defined(&ESA_ASSP_INT_ENABLE)) {
    sub ESA_ASSP_INT_ENABLE () {	0x10;}
}
unless(defined(&ESA_RING_INT_ENABLE)) {
    sub ESA_RING_INT_ENABLE () {	0x20;}
}
unless(defined(&ESA_HV_INT_ENABLE)) {
    sub ESA_HV_INT_ENABLE () {	0x40;}
}
unless(defined(&ESA_CLKRUN_GEN_ENABLE)) {
    sub ESA_CLKRUN_GEN_ENABLE () {	0x100;}
}
unless(defined(&ESA_HV_CTRL_TO_PME)) {
    sub ESA_HV_CTRL_TO_PME () {	0x400;}
}
unless(defined(&ESA_SOFTWARE_RESET_ENABLE)) {
    sub ESA_SOFTWARE_RESET_ENABLE () {	0x8000;}
}
unless(defined(&ESA_REGB_ENABLE_RESET)) {
    sub ESA_REGB_ENABLE_RESET () {	0x1;}
}
unless(defined(&ESA_REGB_STOP_CLOCK)) {
    sub ESA_REGB_STOP_CLOCK () {	0x10;}
}
unless(defined(&ESA_HOST_INT_STATUS)) {
    sub ESA_HOST_INT_STATUS () {	0x1a;}
}
unless(defined(&ESA_SB_INT_PENDING)) {
    sub ESA_SB_INT_PENDING () {	0x1;}
}
unless(defined(&ESA_MPU401_INT_PENDING)) {
    sub ESA_MPU401_INT_PENDING () {	0x2;}
}
unless(defined(&ESA_ASSP_INT_PENDING)) {
    sub ESA_ASSP_INT_PENDING () {	0x10;}
}
unless(defined(&ESA_RING_INT_PENDING)) {
    sub ESA_RING_INT_PENDING () {	0x20;}
}
unless(defined(&ESA_HV_INT_PENDING)) {
    sub ESA_HV_INT_PENDING () {	0x40;}
}
unless(defined(&ESA_HARDWARE_VOL_CTRL)) {
    sub ESA_HARDWARE_VOL_CTRL () {	0x1b;}
}
unless(defined(&ESA_SHADOW_MIX_REG_VOICE)) {
    sub ESA_SHADOW_MIX_REG_VOICE () {	0x1c;}
}
unless(defined(&ESA_HW_VOL_COUNTER_VOICE)) {
    sub ESA_HW_VOL_COUNTER_VOICE () {	0x1d;}
}
unless(defined(&ESA_SHADOW_MIX_REG_MASTER)) {
    sub ESA_SHADOW_MIX_REG_MASTER () {	0x1e;}
}
unless(defined(&ESA_HW_VOL_COUNTER_MASTER)) {
    sub ESA_HW_VOL_COUNTER_MASTER () {	0x1f;}
}
unless(defined(&ESA_CODEC_COMMAND)) {
    sub ESA_CODEC_COMMAND () {	0x30;}
}
unless(defined(&ESA_CODEC_READ_B)) {
    sub ESA_CODEC_READ_B () {	0x80;}
}
unless(defined(&ESA_CODEC_STATUS)) {
    sub ESA_CODEC_STATUS () {	0x30;}
}
unless(defined(&ESA_CODEC_BUSY_B)) {
    sub ESA_CODEC_BUSY_B () {	0x1;}
}
unless(defined(&ESA_CODEC_DATA)) {
    sub ESA_CODEC_DATA () {	0x32;}
}
unless(defined(&ESA_RING_BUS_CTRL_A)) {
    sub ESA_RING_BUS_CTRL_A () {	0x36;}
}
unless(defined(&ESA_RAC_PME_ENABLE)) {
    sub ESA_RAC_PME_ENABLE () {	0x100;}
}
unless(defined(&ESA_RAC_SDFS_ENABLE)) {
    sub ESA_RAC_SDFS_ENABLE () {	0x200;}
}
unless(defined(&ESA_LAC_PME_ENABLE)) {
    sub ESA_LAC_PME_ENABLE () {	0x400;}
}
unless(defined(&ESA_LAC_SDFS_ENABLE)) {
    sub ESA_LAC_SDFS_ENABLE () {	0x800;}
}
unless(defined(&ESA_SERIAL_AC_LINK_ENABLE)) {
    sub ESA_SERIAL_AC_LINK_ENABLE () {	0x1000;}
}
unless(defined(&ESA_IO_SRAM_ENABLE)) {
    sub ESA_IO_SRAM_ENABLE () {	0x2000;}
}
unless(defined(&ESA_IIS_INPUT_ENABLE)) {
    sub ESA_IIS_INPUT_ENABLE () {	0x8000;}
}
unless(defined(&ESA_RING_BUS_CTRL_B)) {
    sub ESA_RING_BUS_CTRL_B () {	0x38;}
}
unless(defined(&ESA_SECOND_CODEC_ID_MASK)) {
    sub ESA_SECOND_CODEC_ID_MASK () {	0x3;}
}
unless(defined(&ESA_SPDIF_FUNC_ENABLE)) {
    sub ESA_SPDIF_FUNC_ENABLE () {	0x10;}
}
unless(defined(&ESA_SECOND_AC_ENABLE)) {
    sub ESA_SECOND_AC_ENABLE () {	0x20;}
}
unless(defined(&ESA_SB_MODULE_INTF_ENABLE)) {
    sub ESA_SB_MODULE_INTF_ENABLE () {	0x40;}
}
unless(defined(&ESA_SSPE_ENABLE)) {
    sub ESA_SSPE_ENABLE () {	0x40;}
}
unless(defined(&ESA_M3I_DOCK_ENABLE)) {
    sub ESA_M3I_DOCK_ENABLE () {	0x80;}
}
unless(defined(&ESA_SDO_OUT_DEST_CTRL)) {
    sub ESA_SDO_OUT_DEST_CTRL () {	0x3a;}
}
unless(defined(&ESA_COMMAND_ADDR_OUT)) {
    sub ESA_COMMAND_ADDR_OUT () {	0x3;}
}
unless(defined(&ESA_PCM_LR_OUT_LOCAL)) {
    sub ESA_PCM_LR_OUT_LOCAL () {	0x;}
}
unless(defined(&ESA_PCM_LR_OUT_REMOTE)) {
    sub ESA_PCM_LR_OUT_REMOTE () {	0x4;}
}
unless(defined(&ESA_PCM_LR_OUT_MUTE)) {
    sub ESA_PCM_LR_OUT_MUTE () {	0x8;}
}
unless(defined(&ESA_PCM_LR_OUT_BOTH)) {
    sub ESA_PCM_LR_OUT_BOTH () {	0xc;}
}
unless(defined(&ESA_LINE1_DAC_OUT_LOCAL)) {
    sub ESA_LINE1_DAC_OUT_LOCAL () {	0x;}
}
unless(defined(&ESA_LINE1_DAC_OUT_REMOTE)) {
    sub ESA_LINE1_DAC_OUT_REMOTE () {	0x10;}
}
unless(defined(&ESA_LINE1_DAC_OUT_MUTE)) {
    sub ESA_LINE1_DAC_OUT_MUTE () {	0x20;}
}
unless(defined(&ESA_LINE1_DAC_OUT_BOTH)) {
    sub ESA_LINE1_DAC_OUT_BOTH () {	0x30;}
}
unless(defined(&ESA_PCM_CLS_OUT_LOCAL)) {
    sub ESA_PCM_CLS_OUT_LOCAL () {	0x;}
}
unless(defined(&ESA_PCM_CLS_OUT_REMOTE)) {
    sub ESA_PCM_CLS_OUT_REMOTE () {	0x40;}
}
unless(defined(&ESA_PCM_CLS_OUT_MUTE)) {
    sub ESA_PCM_CLS_OUT_MUTE () {	0x80;}
}
unless(defined(&ESA_PCM_CLS_OUT_BOTH)) {
    sub ESA_PCM_CLS_OUT_BOTH () {	0xc0;}
}
unless(defined(&ESA_PCM_RLF_OUT_LOCAL)) {
    sub ESA_PCM_RLF_OUT_LOCAL () {	0x;}
}
unless(defined(&ESA_PCM_RLF_OUT_REMOTE)) {
    sub ESA_PCM_RLF_OUT_REMOTE () {	0x100;}
}
unless(defined(&ESA_PCM_RLF_OUT_MUTE)) {
    sub ESA_PCM_RLF_OUT_MUTE () {	0x200;}
}
unless(defined(&ESA_PCM_RLF_OUT_BOTH)) {
    sub ESA_PCM_RLF_OUT_BOTH () {	0x300;}
}
unless(defined(&ESA_LINE2_DAC_OUT_LOCAL)) {
    sub ESA_LINE2_DAC_OUT_LOCAL () {	0x;}
}
unless(defined(&ESA_LINE2_DAC_OUT_REMOTE)) {
    sub ESA_LINE2_DAC_OUT_REMOTE () {	0x400;}
}
unless(defined(&ESA_LINE2_DAC_OUT_MUTE)) {
    sub ESA_LINE2_DAC_OUT_MUTE () {	0x800;}
}
unless(defined(&ESA_LINE2_DAC_OUT_BOTH)) {
    sub ESA_LINE2_DAC_OUT_BOTH () {	0xc00;}
}
unless(defined(&ESA_HANDSET_OUT_LOCAL)) {
    sub ESA_HANDSET_OUT_LOCAL () {	0x;}
}
unless(defined(&ESA_HANDSET_OUT_REMOTE)) {
    sub ESA_HANDSET_OUT_REMOTE () {	0x1000;}
}
unless(defined(&ESA_HANDSET_OUT_MUTE)) {
    sub ESA_HANDSET_OUT_MUTE () {	0x2000;}
}
unless(defined(&ESA_HANDSET_OUT_BOTH)) {
    sub ESA_HANDSET_OUT_BOTH () {	0x3000;}
}
unless(defined(&ESA_IO_CTRL_OUT_LOCAL)) {
    sub ESA_IO_CTRL_OUT_LOCAL () {	0x;}
}
unless(defined(&ESA_IO_CTRL_OUT_REMOTE)) {
    sub ESA_IO_CTRL_OUT_REMOTE () {	0x4000;}
}
unless(defined(&ESA_IO_CTRL_OUT_MUTE)) {
    sub ESA_IO_CTRL_OUT_MUTE () {	0x8000;}
}
unless(defined(&ESA_IO_CTRL_OUT_BOTH)) {
    sub ESA_IO_CTRL_OUT_BOTH () {	0xc000;}
}
unless(defined(&ESA_SDO_IN_DEST_CTRL)) {
    sub ESA_SDO_IN_DEST_CTRL () {	0x3c;}
}
unless(defined(&ESA_STATUS_ADDR_IN)) {
    sub ESA_STATUS_ADDR_IN () {	0x3;}
}
unless(defined(&ESA_PCM_LR_IN_LOCAL)) {
    sub ESA_PCM_LR_IN_LOCAL () {	0x;}
}
unless(defined(&ESA_PCM_LR_IN_REMOTE)) {
    sub ESA_PCM_LR_IN_REMOTE () {	0x4;}
}
unless(defined(&ESA_PCM_LR_RESERVED)) {
    sub ESA_PCM_LR_RESERVED () {	0x8;}
}
unless(defined(&ESA_PCM_LR_IN_BOTH)) {
    sub ESA_PCM_LR_IN_BOTH () {	0xc;}
}
unless(defined(&ESA_LINE1_ADC_IN_LOCAL)) {
    sub ESA_LINE1_ADC_IN_LOCAL () {	0x;}
}
unless(defined(&ESA_LINE1_ADC_IN_REMOTE)) {
    sub ESA_LINE1_ADC_IN_REMOTE () {	0x10;}
}
unless(defined(&ESA_LINE1_ADC_IN_MUTE)) {
    sub ESA_LINE1_ADC_IN_MUTE () {	0x20;}
}
unless(defined(&ESA_MIC_ADC_IN_LOCAL)) {
    sub ESA_MIC_ADC_IN_LOCAL () {	0x;}
}
unless(defined(&ESA_MIC_ADC_IN_REMOTE)) {
    sub ESA_MIC_ADC_IN_REMOTE () {	0x40;}
}
unless(defined(&ESA_MIC_ADC_IN_MUTE)) {
    sub ESA_MIC_ADC_IN_MUTE () {	0x80;}
}
unless(defined(&ESA_LINE2_DAC_IN_LOCAL)) {
    sub ESA_LINE2_DAC_IN_LOCAL () {	0x;}
}
unless(defined(&ESA_LINE2_DAC_IN_REMOTE)) {
    sub ESA_LINE2_DAC_IN_REMOTE () {	0x400;}
}
unless(defined(&ESA_LINE2_DAC_IN_MUTE)) {
    sub ESA_LINE2_DAC_IN_MUTE () {	0x800;}
}
unless(defined(&ESA_HANDSET_IN_LOCAL)) {
    sub ESA_HANDSET_IN_LOCAL () {	0x;}
}
unless(defined(&ESA_HANDSET_IN_REMOTE)) {
    sub ESA_HANDSET_IN_REMOTE () {	0x1000;}
}
unless(defined(&ESA_HANDSET_IN_MUTE)) {
    sub ESA_HANDSET_IN_MUTE () {	0x2000;}
}
unless(defined(&ESA_IO_STATUS_IN_LOCAL)) {
    sub ESA_IO_STATUS_IN_LOCAL () {	0x;}
}
unless(defined(&ESA_IO_STATUS_IN_REMOTE)) {
    sub ESA_IO_STATUS_IN_REMOTE () {	0x4000;}
}
unless(defined(&ESA_SPDIF_IN_CTRL)) {
    sub ESA_SPDIF_IN_CTRL () {	0x3e;}
}
unless(defined(&ESA_SPDIF_IN_ENABLE)) {
    sub ESA_SPDIF_IN_ENABLE () {	0x1;}
}
unless(defined(&ESA_GPIO_DATA)) {
    sub ESA_GPIO_DATA () {	0x60;}
}
unless(defined(&ESA_GPIO_DATA_MASK)) {
    sub ESA_GPIO_DATA_MASK () {	0xfff;}
}
unless(defined(&ESA_GPIO_HV_STATUS)) {
    sub ESA_GPIO_HV_STATUS () {	0x3000;}
}
unless(defined(&ESA_GPIO_PME_STATUS)) {
    sub ESA_GPIO_PME_STATUS () {	0x4000;}
}
unless(defined(&ESA_GPIO_MASK)) {
    sub ESA_GPIO_MASK () {	0x64;}
}
unless(defined(&ESA_GPIO_DIRECTION)) {
    sub ESA_GPIO_DIRECTION () {	0x68;}
}
unless(defined(&ESA_GPO_PRIMARY_AC97)) {
    sub ESA_GPO_PRIMARY_AC97 () {	0x1;}
}
unless(defined(&ESA_GPI_LINEOUT_SENSE)) {
    sub ESA_GPI_LINEOUT_SENSE () {	0x4;}
}
unless(defined(&ESA_GPO_SECONDARY_AC97)) {
    sub ESA_GPO_SECONDARY_AC97 () {	0x8;}
}
unless(defined(&ESA_GPI_VOL_DOWN)) {
    sub ESA_GPI_VOL_DOWN () {	0x10;}
}
unless(defined(&ESA_GPI_VOL_UP)) {
    sub ESA_GPI_VOL_UP () {	0x20;}
}
unless(defined(&ESA_GPI_IIS_CLK)) {
    sub ESA_GPI_IIS_CLK () {	0x40;}
}
unless(defined(&ESA_GPI_IIS_LRCLK)) {
    sub ESA_GPI_IIS_LRCLK () {	0x80;}
}
unless(defined(&ESA_GPI_IIS_DATA)) {
    sub ESA_GPI_IIS_DATA () {	0x100;}
}
unless(defined(&ESA_GPI_DOCKING_STATUS)) {
    sub ESA_GPI_DOCKING_STATUS () {	0x100;}
}
unless(defined(&ESA_GPI_HEADPHONE_SENSE)) {
    sub ESA_GPI_HEADPHONE_SENSE () {	0x200;}
}
unless(defined(&ESA_GPO_EXT_AMP_SHUTDOWN)) {
    sub ESA_GPO_EXT_AMP_SHUTDOWN () {	0x1000;}
}
unless(defined(&ESA_GPO_M3_EXT_AMP_SHUTDN)) {
    sub ESA_GPO_M3_EXT_AMP_SHUTDN () {	0x2;}
}
unless(defined(&ESA_ASSP_INDEX_PORT)) {
    sub ESA_ASSP_INDEX_PORT () {	0x80;}
}
unless(defined(&ESA_ASSP_MEMORY_PORT)) {
    sub ESA_ASSP_MEMORY_PORT () {	0x82;}
}
unless(defined(&ESA_ASSP_DATA_PORT)) {
    sub ESA_ASSP_DATA_PORT () {	0x84;}
}
unless(defined(&ESA_MPU401_DATA_PORT)) {
    sub ESA_MPU401_DATA_PORT () {	0x98;}
}
unless(defined(&ESA_MPU401_STATUS_PORT)) {
    sub ESA_MPU401_STATUS_PORT () {	0x99;}
}
unless(defined(&ESA_CLK_MULT_DATA_PORT)) {
    sub ESA_CLK_MULT_DATA_PORT () {	0x9c;}
}
unless(defined(&ESA_ASSP_CONTROL_A)) {
    sub ESA_ASSP_CONTROL_A () {	0xa2;}
}
unless(defined(&ESA_ASSP_0_WS_ENABLE)) {
    sub ESA_ASSP_0_WS_ENABLE () {	0x1;}
}
unless(defined(&ESA_ASSP_CTRL_A_RESERVED1)) {
    sub ESA_ASSP_CTRL_A_RESERVED1 () {	0x2;}
}
unless(defined(&ESA_ASSP_CTRL_A_RESERVED2)) {
    sub ESA_ASSP_CTRL_A_RESERVED2 () {	0x4;}
}
unless(defined(&ESA_ASSP_CLK_49MHZ_SELECT)) {
    sub ESA_ASSP_CLK_49MHZ_SELECT () {	0x8;}
}
unless(defined(&ESA_FAST_PLU_ENABLE)) {
    sub ESA_FAST_PLU_ENABLE () {	0x10;}
}
unless(defined(&ESA_ASSP_CTRL_A_RESERVED3)) {
    sub ESA_ASSP_CTRL_A_RESERVED3 () {	0x20;}
}
unless(defined(&ESA_DSP_CLK_36MHZ_SELECT)) {
    sub ESA_DSP_CLK_36MHZ_SELECT () {	0x40;}
}
unless(defined(&ESA_ASSP_CONTROL_B)) {
    sub ESA_ASSP_CONTROL_B () {	0xa4;}
}
unless(defined(&ESA_RESET_ASSP)) {
    sub ESA_RESET_ASSP () {	0x;}
}
unless(defined(&ESA_RUN_ASSP)) {
    sub ESA_RUN_ASSP () {	0x1;}
}
unless(defined(&ESA_ENABLE_ASSP_CLOCK)) {
    sub ESA_ENABLE_ASSP_CLOCK () {	0x;}
}
unless(defined(&ESA_STOP_ASSP_CLOCK)) {
    sub ESA_STOP_ASSP_CLOCK () {	0x10;}
}
unless(defined(&ESA_RESET_TOGGLE)) {
    sub ESA_RESET_TOGGLE () {	0x40;}
}
unless(defined(&ESA_ASSP_CONTROL_C)) {
    sub ESA_ASSP_CONTROL_C () {	0xa6;}
}
unless(defined(&ESA_ASSP_HOST_INT_ENABLE)) {
    sub ESA_ASSP_HOST_INT_ENABLE () {	0x1;}
}
unless(defined(&ESA_FM_ADDR_REMAP_DISABLE)) {
    sub ESA_FM_ADDR_REMAP_DISABLE () {	0x2;}
}
unless(defined(&ESA_HOST_WRITE_PORT_ENABLE)) {
    sub ESA_HOST_WRITE_PORT_ENABLE () {	0x8;}
}
unless(defined(&ESA_ASSP_HOST_INT_STATUS)) {
    sub ESA_ASSP_HOST_INT_STATUS () {	0xac;}
}
unless(defined(&ESA_DSP2HOST_REQ_PIORECORD)) {
    sub ESA_DSP2HOST_REQ_PIORECORD () {	0x1;}
}
unless(defined(&ESA_DSP2HOST_REQ_I2SRATE)) {
    sub ESA_DSP2HOST_REQ_I2SRATE () {	0x2;}
}
unless(defined(&ESA_DSP2HOST_REQ_TIMER)) {
    sub ESA_DSP2HOST_REQ_TIMER () {	0x4;}
}
unless(defined(&ESA_DSP_PORT_TIMER_COUNT)) {
    sub ESA_DSP_PORT_TIMER_COUNT () {	0x6;}
}
unless(defined(&ESA_DSP_PORT_MEMORY_INDEX)) {
    sub ESA_DSP_PORT_MEMORY_INDEX () {	0x80;}
}
unless(defined(&ESA_DSP_PORT_MEMORY_TYPE)) {
    sub ESA_DSP_PORT_MEMORY_TYPE () {	0x82;}
}
unless(defined(&ESA_MEMTYPE_INTERNAL_CODE)) {
    sub ESA_MEMTYPE_INTERNAL_CODE () {	0x2;}
}
unless(defined(&ESA_MEMTYPE_INTERNAL_DATA)) {
    sub ESA_MEMTYPE_INTERNAL_DATA () {	0x3;}
}
unless(defined(&ESA_MEMTYPE_MASK)) {
    sub ESA_MEMTYPE_MASK () {	0x3;}
}
unless(defined(&ESA_DSP_PORT_MEMORY_DATA)) {
    sub ESA_DSP_PORT_MEMORY_DATA () {	0x84;}
}
unless(defined(&ESA_DSP_PORT_CONTROL_REG_A)) {
    sub ESA_DSP_PORT_CONTROL_REG_A () {	0xa2;}
}
unless(defined(&ESA_DSP_PORT_CONTROL_REG_B)) {
    sub ESA_DSP_PORT_CONTROL_REG_B () {	0xa4;}
}
unless(defined(&ESA_DSP_PORT_CONTROL_REG_C)) {
    sub ESA_DSP_PORT_CONTROL_REG_C () {	0xa6;}
}
unless(defined(&ESA_REV_A_CODE_MEMORY_BEGIN)) {
    sub ESA_REV_A_CODE_MEMORY_BEGIN () {	0x;}
}
unless(defined(&ESA_REV_A_CODE_MEMORY_END)) {
    sub ESA_REV_A_CODE_MEMORY_END () {	0xfff;}
}
unless(defined(&ESA_REV_A_CODE_MEMORY_UNIT_LENGTH)) {
    sub ESA_REV_A_CODE_MEMORY_UNIT_LENGTH () {	0x40;}
}
unless(defined(&ESA_REV_A_CODE_MEMORY_LENGTH)) {
    sub ESA_REV_A_CODE_MEMORY_LENGTH () {	( &ESA_REV_A_CODE_MEMORY_END -  &ESA_REV_A_CODE_MEMORY_BEGIN + 1);}
}
unless(defined(&ESA_REV_B_CODE_MEMORY_BEGIN)) {
    sub ESA_REV_B_CODE_MEMORY_BEGIN () {	0x;}
}
unless(defined(&ESA_REV_B_CODE_MEMORY_END)) {
    sub ESA_REV_B_CODE_MEMORY_END () {	0xbff;}
}
unless(defined(&ESA_REV_B_CODE_MEMORY_UNIT_LENGTH)) {
    sub ESA_REV_B_CODE_MEMORY_UNIT_LENGTH () {	0x40;}
}
unless(defined(&ESA_REV_B_CODE_MEMORY_LENGTH)) {
    sub ESA_REV_B_CODE_MEMORY_LENGTH () {	( &ESA_REV_B_CODE_MEMORY_END -  &ESA_REV_B_CODE_MEMORY_BEGIN + 1);}
}
unless(defined(&ESA_REV_A_DATA_MEMORY_BEGIN)) {
    sub ESA_REV_A_DATA_MEMORY_BEGIN () {	0x1000;}
}
unless(defined(&ESA_REV_A_DATA_MEMORY_END)) {
    sub ESA_REV_A_DATA_MEMORY_END () {	0x2fff;}
}
unless(defined(&ESA_REV_A_DATA_MEMORY_UNIT_LENGTH)) {
    sub ESA_REV_A_DATA_MEMORY_UNIT_LENGTH () {	0x80;}
}
unless(defined(&ESA_REV_A_DATA_MEMORY_LENGTH)) {
    sub ESA_REV_A_DATA_MEMORY_LENGTH () {	( &ESA_REV_A_DATA_MEMORY_END -  &ESA_REV_A_DATA_MEMORY_BEGIN + 1);}
}
unless(defined(&ESA_REV_B_DATA_MEMORY_BEGIN)) {
    sub ESA_REV_B_DATA_MEMORY_BEGIN () {	0x1000;}
}
unless(defined(&ESA_REV_B_DATA_MEMORY_END)) {
    sub ESA_REV_B_DATA_MEMORY_END () {	0x2bff;}
}
unless(defined(&ESA_REV_B_DATA_MEMORY_UNIT_LENGTH)) {
    sub ESA_REV_B_DATA_MEMORY_UNIT_LENGTH () {	0x80;}
}
unless(defined(&ESA_REV_B_DATA_MEMORY_LENGTH)) {
    sub ESA_REV_B_DATA_MEMORY_LENGTH () {	( &ESA_REV_B_DATA_MEMORY_END -  &ESA_REV_B_DATA_MEMORY_BEGIN + 1);}
}
unless(defined(&ESA_NUM_UNITS_KERNEL_CODE)) {
    sub ESA_NUM_UNITS_KERNEL_CODE () {	16;}
}
unless(defined(&ESA_NUM_UNITS_KERNEL_DATA)) {
    sub ESA_NUM_UNITS_KERNEL_DATA () {	2;}
}
unless(defined(&ESA_NUM_UNITS_KERNEL_CODE_WITH_HSP)) {
    sub ESA_NUM_UNITS_KERNEL_CODE_WITH_HSP () {	16;}
}
unless(defined(&ESA_NUM_UNITS_KERNEL_DATA_WITH_HSP)) {
    sub ESA_NUM_UNITS_KERNEL_DATA_WITH_HSP () {	5;}
}
unless(defined(&ESA_DP_SHIFT_COUNT)) {
    sub ESA_DP_SHIFT_COUNT () {	7;}
}
unless(defined(&ESA_KDATA_BASE_ADDR)) {
    sub ESA_KDATA_BASE_ADDR () {	0x1000;}
}
unless(defined(&ESA_KDATA_BASE_ADDR2)) {
    sub ESA_KDATA_BASE_ADDR2 () {	0x1080;}
}
unless(defined(&ESA_KDATA_TASK0)) {
    sub ESA_KDATA_TASK0 () {	( &ESA_KDATA_BASE_ADDR + 0x);}
}
unless(defined(&ESA_KDATA_TASK1)) {
    sub ESA_KDATA_TASK1 () {	( &ESA_KDATA_BASE_ADDR + 0x1);}
}
unless(defined(&ESA_KDATA_TASK2)) {
    sub ESA_KDATA_TASK2 () {	( &ESA_KDATA_BASE_ADDR + 0x2);}
}
unless(defined(&ESA_KDATA_TASK3)) {
    sub ESA_KDATA_TASK3 () {	( &ESA_KDATA_BASE_ADDR + 0x3);}
}
unless(defined(&ESA_KDATA_TASK4)) {
    sub ESA_KDATA_TASK4 () {	( &ESA_KDATA_BASE_ADDR + 0x4);}
}
unless(defined(&ESA_KDATA_TASK5)) {
    sub ESA_KDATA_TASK5 () {	( &ESA_KDATA_BASE_ADDR + 0x5);}
}
unless(defined(&ESA_KDATA_TASK6)) {
    sub ESA_KDATA_TASK6 () {	( &ESA_KDATA_BASE_ADDR + 0x6);}
}
unless(defined(&ESA_KDATA_TASK7)) {
    sub ESA_KDATA_TASK7 () {	( &ESA_KDATA_BASE_ADDR + 0x7);}
}
unless(defined(&ESA_KDATA_TASK_ENDMARK)) {
    sub ESA_KDATA_TASK_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x8);}
}
unless(defined(&ESA_KDATA_CURRENT_TASK)) {
    sub ESA_KDATA_CURRENT_TASK () {	( &ESA_KDATA_BASE_ADDR + 0x9);}
}
unless(defined(&ESA_KDATA_TASK_SWITCH)) {
    sub ESA_KDATA_TASK_SWITCH () {	( &ESA_KDATA_BASE_ADDR + 0xa);}
}
unless(defined(&ESA_KDATA_INSTANCE0_POS3D)) {
    sub ESA_KDATA_INSTANCE0_POS3D () {	( &ESA_KDATA_BASE_ADDR + 0xb);}
}
unless(defined(&ESA_KDATA_INSTANCE1_POS3D)) {
    sub ESA_KDATA_INSTANCE1_POS3D () {	( &ESA_KDATA_BASE_ADDR + 0xc);}
}
unless(defined(&ESA_KDATA_INSTANCE2_POS3D)) {
    sub ESA_KDATA_INSTANCE2_POS3D () {	( &ESA_KDATA_BASE_ADDR + 0xd);}
}
unless(defined(&ESA_KDATA_INSTANCE3_POS3D)) {
    sub ESA_KDATA_INSTANCE3_POS3D () {	( &ESA_KDATA_BASE_ADDR + 0xe);}
}
unless(defined(&ESA_KDATA_INSTANCE4_POS3D)) {
    sub ESA_KDATA_INSTANCE4_POS3D () {	( &ESA_KDATA_BASE_ADDR + 0xf);}
}
unless(defined(&ESA_KDATA_INSTANCE5_POS3D)) {
    sub ESA_KDATA_INSTANCE5_POS3D () {	( &ESA_KDATA_BASE_ADDR + 0x10);}
}
unless(defined(&ESA_KDATA_INSTANCE6_POS3D)) {
    sub ESA_KDATA_INSTANCE6_POS3D () {	( &ESA_KDATA_BASE_ADDR + 0x11);}
}
unless(defined(&ESA_KDATA_INSTANCE7_POS3D)) {
    sub ESA_KDATA_INSTANCE7_POS3D () {	( &ESA_KDATA_BASE_ADDR + 0x12);}
}
unless(defined(&ESA_KDATA_INSTANCE8_POS3D)) {
    sub ESA_KDATA_INSTANCE8_POS3D () {	( &ESA_KDATA_BASE_ADDR + 0x13);}
}
unless(defined(&ESA_KDATA_INSTANCE_POS3D_ENDMARK)) {
    sub ESA_KDATA_INSTANCE_POS3D_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x14);}
}
unless(defined(&ESA_KDATA_INSTANCE0_SPKVIRT)) {
    sub ESA_KDATA_INSTANCE0_SPKVIRT () {	( &ESA_KDATA_BASE_ADDR + 0x15);}
}
unless(defined(&ESA_KDATA_INSTANCE_SPKVIRT_ENDMARK)) {
    sub ESA_KDATA_INSTANCE_SPKVIRT_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x16);}
}
unless(defined(&ESA_KDATA_INSTANCE0_SPDIF)) {
    sub ESA_KDATA_INSTANCE0_SPDIF () {	( &ESA_KDATA_BASE_ADDR + 0x17);}
}
unless(defined(&ESA_KDATA_INSTANCE_SPDIF_ENDMARK)) {
    sub ESA_KDATA_INSTANCE_SPDIF_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x18);}
}
unless(defined(&ESA_KDATA_INSTANCE0_MODEM)) {
    sub ESA_KDATA_INSTANCE0_MODEM () {	( &ESA_KDATA_BASE_ADDR + 0x19);}
}
unless(defined(&ESA_KDATA_INSTANCE_MODEM_ENDMARK)) {
    sub ESA_KDATA_INSTANCE_MODEM_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x1a);}
}
unless(defined(&ESA_KDATA_INSTANCE0_SRC)) {
    sub ESA_KDATA_INSTANCE0_SRC () {	( &ESA_KDATA_BASE_ADDR + 0x1b);}
}
unless(defined(&ESA_KDATA_INSTANCE1_SRC)) {
    sub ESA_KDATA_INSTANCE1_SRC () {	( &ESA_KDATA_BASE_ADDR + 0x1c);}
}
unless(defined(&ESA_KDATA_INSTANCE_SRC_ENDMARK)) {
    sub ESA_KDATA_INSTANCE_SRC_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x1d);}
}
unless(defined(&ESA_KDATA_INSTANCE0_MINISRC)) {
    sub ESA_KDATA_INSTANCE0_MINISRC () {	( &ESA_KDATA_BASE_ADDR + 0x1e);}
}
unless(defined(&ESA_KDATA_INSTANCE1_MINISRC)) {
    sub ESA_KDATA_INSTANCE1_MINISRC () {	( &ESA_KDATA_BASE_ADDR + 0x1f);}
}
unless(defined(&ESA_KDATA_INSTANCE2_MINISRC)) {
    sub ESA_KDATA_INSTANCE2_MINISRC () {	( &ESA_KDATA_BASE_ADDR + 0x20);}
}
unless(defined(&ESA_KDATA_INSTANCE3_MINISRC)) {
    sub ESA_KDATA_INSTANCE3_MINISRC () {	( &ESA_KDATA_BASE_ADDR + 0x21);}
}
unless(defined(&ESA_KDATA_INSTANCE_MINISRC_ENDMARK)) {
    sub ESA_KDATA_INSTANCE_MINISRC_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x22);}
}
unless(defined(&ESA_KDATA_INSTANCE0_CPYTHRU)) {
    sub ESA_KDATA_INSTANCE0_CPYTHRU () {	( &ESA_KDATA_BASE_ADDR + 0x23);}
}
unless(defined(&ESA_KDATA_INSTANCE1_CPYTHRU)) {
    sub ESA_KDATA_INSTANCE1_CPYTHRU () {	( &ESA_KDATA_BASE_ADDR + 0x24);}
}
unless(defined(&ESA_KDATA_INSTANCE_CPYTHRU_ENDMARK)) {
    sub ESA_KDATA_INSTANCE_CPYTHRU_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x25);}
}
unless(defined(&ESA_KDATA_CURRENT_DMA)) {
    sub ESA_KDATA_CURRENT_DMA () {	( &ESA_KDATA_BASE_ADDR + 0x26);}
}
unless(defined(&ESA_KDATA_DMA_SWITCH)) {
    sub ESA_KDATA_DMA_SWITCH () {	( &ESA_KDATA_BASE_ADDR + 0x27);}
}
unless(defined(&ESA_KDATA_DMA_ACTIVE)) {
    sub ESA_KDATA_DMA_ACTIVE () {	( &ESA_KDATA_BASE_ADDR + 0x28);}
}
unless(defined(&ESA_KDATA_DMA_XFER0)) {
    sub ESA_KDATA_DMA_XFER0 () {	( &ESA_KDATA_BASE_ADDR + 0x29);}
}
unless(defined(&ESA_KDATA_DMA_XFER1)) {
    sub ESA_KDATA_DMA_XFER1 () {	( &ESA_KDATA_BASE_ADDR + 0x2a);}
}
unless(defined(&ESA_KDATA_DMA_XFER2)) {
    sub ESA_KDATA_DMA_XFER2 () {	( &ESA_KDATA_BASE_ADDR + 0x2b);}
}
unless(defined(&ESA_KDATA_DMA_XFER3)) {
    sub ESA_KDATA_DMA_XFER3 () {	( &ESA_KDATA_BASE_ADDR + 0x2c);}
}
unless(defined(&ESA_KDATA_DMA_XFER4)) {
    sub ESA_KDATA_DMA_XFER4 () {	( &ESA_KDATA_BASE_ADDR + 0x2d);}
}
unless(defined(&ESA_KDATA_DMA_XFER5)) {
    sub ESA_KDATA_DMA_XFER5 () {	( &ESA_KDATA_BASE_ADDR + 0x2e);}
}
unless(defined(&ESA_KDATA_DMA_XFER6)) {
    sub ESA_KDATA_DMA_XFER6 () {	( &ESA_KDATA_BASE_ADDR + 0x2f);}
}
unless(defined(&ESA_KDATA_DMA_XFER7)) {
    sub ESA_KDATA_DMA_XFER7 () {	( &ESA_KDATA_BASE_ADDR + 0x30);}
}
unless(defined(&ESA_KDATA_DMA_XFER8)) {
    sub ESA_KDATA_DMA_XFER8 () {	( &ESA_KDATA_BASE_ADDR + 0x31);}
}
unless(defined(&ESA_KDATA_DMA_XFER_ENDMARK)) {
    sub ESA_KDATA_DMA_XFER_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x32);}
}
unless(defined(&ESA_KDATA_I2S_SAMPLE_COUNT)) {
    sub ESA_KDATA_I2S_SAMPLE_COUNT () {	( &ESA_KDATA_BASE_ADDR + 0x33);}
}
unless(defined(&ESA_KDATA_I2S_INT_METER)) {
    sub ESA_KDATA_I2S_INT_METER () {	( &ESA_KDATA_BASE_ADDR + 0x34);}
}
unless(defined(&ESA_KDATA_I2S_ACTIVE)) {
    sub ESA_KDATA_I2S_ACTIVE () {	( &ESA_KDATA_BASE_ADDR + 0x35);}
}
unless(defined(&ESA_KDATA_TIMER_COUNT_RELOAD)) {
    sub ESA_KDATA_TIMER_COUNT_RELOAD () {	( &ESA_KDATA_BASE_ADDR + 0x36);}
}
unless(defined(&ESA_KDATA_TIMER_COUNT_CURRENT)) {
    sub ESA_KDATA_TIMER_COUNT_CURRENT () {	( &ESA_KDATA_BASE_ADDR + 0x37);}
}
unless(defined(&ESA_KDATA_HALT_SYNCH_CLIENT)) {
    sub ESA_KDATA_HALT_SYNCH_CLIENT () {	( &ESA_KDATA_BASE_ADDR + 0x38);}
}
unless(defined(&ESA_KDATA_HALT_SYNCH_DMA)) {
    sub ESA_KDATA_HALT_SYNCH_DMA () {	( &ESA_KDATA_BASE_ADDR + 0x39);}
}
unless(defined(&ESA_KDATA_HALT_ACKNOWLEDGE)) {
    sub ESA_KDATA_HALT_ACKNOWLEDGE () {	( &ESA_KDATA_BASE_ADDR + 0x3a);}
}
unless(defined(&ESA_KDATA_ADC1_XFER0)) {
    sub ESA_KDATA_ADC1_XFER0 () {	( &ESA_KDATA_BASE_ADDR + 0x3b);}
}
unless(defined(&ESA_KDATA_ADC1_XFER_ENDMARK)) {
    sub ESA_KDATA_ADC1_XFER_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x3c);}
}
unless(defined(&ESA_KDATA_ADC1_LEFT_VOLUME)) {
    sub ESA_KDATA_ADC1_LEFT_VOLUME () {	( &ESA_KDATA_BASE_ADDR + 0x3d);}
}
unless(defined(&ESA_KDATA_ADC1_RIGHT_VOLUME)) {
    sub ESA_KDATA_ADC1_RIGHT_VOLUME () {	( &ESA_KDATA_BASE_ADDR + 0x3e);}
}
unless(defined(&ESA_KDATA_ADC1_LEFT_SUR_VOL)) {
    sub ESA_KDATA_ADC1_LEFT_SUR_VOL () {	( &ESA_KDATA_BASE_ADDR + 0x3f);}
}
unless(defined(&ESA_KDATA_ADC1_RIGHT_SUR_VOL)) {
    sub ESA_KDATA_ADC1_RIGHT_SUR_VOL () {	( &ESA_KDATA_BASE_ADDR + 0x40);}
}
unless(defined(&ESA_KDATA_ADC2_XFER0)) {
    sub ESA_KDATA_ADC2_XFER0 () {	( &ESA_KDATA_BASE_ADDR + 0x41);}
}
unless(defined(&ESA_KDATA_ADC2_XFER_ENDMARK)) {
    sub ESA_KDATA_ADC2_XFER_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x42);}
}
unless(defined(&ESA_KDATA_ADC2_LEFT_VOLUME)) {
    sub ESA_KDATA_ADC2_LEFT_VOLUME () {	( &ESA_KDATA_BASE_ADDR + 0x43);}
}
unless(defined(&ESA_KDATA_ADC2_RIGHT_VOLUME)) {
    sub ESA_KDATA_ADC2_RIGHT_VOLUME () {	( &ESA_KDATA_BASE_ADDR + 0x44);}
}
unless(defined(&ESA_KDATA_ADC2_LEFT_SUR_VOL)) {
    sub ESA_KDATA_ADC2_LEFT_SUR_VOL () {	( &ESA_KDATA_BASE_ADDR + 0x45);}
}
unless(defined(&ESA_KDATA_ADC2_RIGHT_SUR_VOL)) {
    sub ESA_KDATA_ADC2_RIGHT_SUR_VOL () {	( &ESA_KDATA_BASE_ADDR + 0x46);}
}
unless(defined(&ESA_KDATA_CD_XFER0)) {
    sub ESA_KDATA_CD_XFER0 () {	( &ESA_KDATA_BASE_ADDR + 0x47);}
}
unless(defined(&ESA_KDATA_CD_XFER_ENDMARK)) {
    sub ESA_KDATA_CD_XFER_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x48);}
}
unless(defined(&ESA_KDATA_CD_LEFT_VOLUME)) {
    sub ESA_KDATA_CD_LEFT_VOLUME () {	( &ESA_KDATA_BASE_ADDR + 0x49);}
}
unless(defined(&ESA_KDATA_CD_RIGHT_VOLUME)) {
    sub ESA_KDATA_CD_RIGHT_VOLUME () {	( &ESA_KDATA_BASE_ADDR + 0x4a);}
}
unless(defined(&ESA_KDATA_CD_LEFT_SUR_VOL)) {
    sub ESA_KDATA_CD_LEFT_SUR_VOL () {	( &ESA_KDATA_BASE_ADDR + 0x4b);}
}
unless(defined(&ESA_KDATA_CD_RIGHT_SUR_VOL)) {
    sub ESA_KDATA_CD_RIGHT_SUR_VOL () {	( &ESA_KDATA_BASE_ADDR + 0x4c);}
}
unless(defined(&ESA_KDATA_MIC_XFER0)) {
    sub ESA_KDATA_MIC_XFER0 () {	( &ESA_KDATA_BASE_ADDR + 0x4d);}
}
unless(defined(&ESA_KDATA_MIC_XFER_ENDMARK)) {
    sub ESA_KDATA_MIC_XFER_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x4e);}
}
unless(defined(&ESA_KDATA_MIC_VOLUME)) {
    sub ESA_KDATA_MIC_VOLUME () {	( &ESA_KDATA_BASE_ADDR + 0x4f);}
}
unless(defined(&ESA_KDATA_MIC_SUR_VOL)) {
    sub ESA_KDATA_MIC_SUR_VOL () {	( &ESA_KDATA_BASE_ADDR + 0x50);}
}
unless(defined(&ESA_KDATA_I2S_XFER0)) {
    sub ESA_KDATA_I2S_XFER0 () {	( &ESA_KDATA_BASE_ADDR + 0x51);}
}
unless(defined(&ESA_KDATA_I2S_XFER_ENDMARK)) {
    sub ESA_KDATA_I2S_XFER_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x52);}
}
unless(defined(&ESA_KDATA_CHI_XFER0)) {
    sub ESA_KDATA_CHI_XFER0 () {	( &ESA_KDATA_BASE_ADDR + 0x53);}
}
unless(defined(&ESA_KDATA_CHI_XFER_ENDMARK)) {
    sub ESA_KDATA_CHI_XFER_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x54);}
}
unless(defined(&ESA_KDATA_SPDIF_XFER)) {
    sub ESA_KDATA_SPDIF_XFER () {	( &ESA_KDATA_BASE_ADDR + 0x55);}
}
unless(defined(&ESA_KDATA_SPDIF_CURRENT_FRAME)) {
    sub ESA_KDATA_SPDIF_CURRENT_FRAME () {	( &ESA_KDATA_BASE_ADDR + 0x56);}
}
unless(defined(&ESA_KDATA_SPDIF_FRAME0)) {
    sub ESA_KDATA_SPDIF_FRAME0 () {	( &ESA_KDATA_BASE_ADDR + 0x57);}
}
unless(defined(&ESA_KDATA_SPDIF_FRAME1)) {
    sub ESA_KDATA_SPDIF_FRAME1 () {	( &ESA_KDATA_BASE_ADDR + 0x58);}
}
unless(defined(&ESA_KDATA_SPDIF_FRAME2)) {
    sub ESA_KDATA_SPDIF_FRAME2 () {	( &ESA_KDATA_BASE_ADDR + 0x59);}
}
unless(defined(&ESA_KDATA_SPDIF_REQUEST)) {
    sub ESA_KDATA_SPDIF_REQUEST () {	( &ESA_KDATA_BASE_ADDR + 0x5a);}
}
unless(defined(&ESA_KDATA_SPDIF_TEMP)) {
    sub ESA_KDATA_SPDIF_TEMP () {	( &ESA_KDATA_BASE_ADDR + 0x5b);}
}
unless(defined(&ESA_KDATA_SPDIFIN_XFER0)) {
    sub ESA_KDATA_SPDIFIN_XFER0 () {	( &ESA_KDATA_BASE_ADDR + 0x5c);}
}
unless(defined(&ESA_KDATA_SPDIFIN_XFER_ENDMARK)) {
    sub ESA_KDATA_SPDIFIN_XFER_ENDMARK () {	( &ESA_KDATA_BASE_ADDR + 0x5d);}
}
unless(defined(&ESA_KDATA_SPDIFIN_INT_METER)) {
    sub ESA_KDATA_SPDIFIN_INT_METER () {	( &ESA_KDATA_BASE_ADDR + 0x5e);}
}
unless(defined(&ESA_KDATA_DSP_RESET_COUNT)) {
    sub ESA_KDATA_DSP_RESET_COUNT () {	( &ESA_KDATA_BASE_ADDR + 0x5f);}
}
unless(defined(&ESA_KDATA_DEBUG_OUTPUT)) {
    sub ESA_KDATA_DEBUG_OUTPUT () {	( &ESA_KDATA_BASE_ADDR + 0x60);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_LIST)) {
    sub ESA_KDATA_KERNEL_ISR_LIST () {	( &ESA_KDATA_BASE_ADDR + 0x61);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_CBSR1)) {
    sub ESA_KDATA_KERNEL_ISR_CBSR1 () {	( &ESA_KDATA_BASE_ADDR + 0x62);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_CBER1)) {
    sub ESA_KDATA_KERNEL_ISR_CBER1 () {	( &ESA_KDATA_BASE_ADDR + 0x63);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_CBCR)) {
    sub ESA_KDATA_KERNEL_ISR_CBCR () {	( &ESA_KDATA_BASE_ADDR + 0x64);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_AR0)) {
    sub ESA_KDATA_KERNEL_ISR_AR0 () {	( &ESA_KDATA_BASE_ADDR + 0x65);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_AR1)) {
    sub ESA_KDATA_KERNEL_ISR_AR1 () {	( &ESA_KDATA_BASE_ADDR + 0x66);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_AR2)) {
    sub ESA_KDATA_KERNEL_ISR_AR2 () {	( &ESA_KDATA_BASE_ADDR + 0x67);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_AR3)) {
    sub ESA_KDATA_KERNEL_ISR_AR3 () {	( &ESA_KDATA_BASE_ADDR + 0x68);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_AR4)) {
    sub ESA_KDATA_KERNEL_ISR_AR4 () {	( &ESA_KDATA_BASE_ADDR + 0x69);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_AR5)) {
    sub ESA_KDATA_KERNEL_ISR_AR5 () {	( &ESA_KDATA_BASE_ADDR + 0x6a);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_BRCR)) {
    sub ESA_KDATA_KERNEL_ISR_BRCR () {	( &ESA_KDATA_BASE_ADDR + 0x6b);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_PASR)) {
    sub ESA_KDATA_KERNEL_ISR_PASR () {	( &ESA_KDATA_BASE_ADDR + 0x6c);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_PAER)) {
    sub ESA_KDATA_KERNEL_ISR_PAER () {	( &ESA_KDATA_BASE_ADDR + 0x6d);}
}
unless(defined(&ESA_KDATA_CLIENT_SCRATCH0)) {
    sub ESA_KDATA_CLIENT_SCRATCH0 () {	( &ESA_KDATA_BASE_ADDR + 0x6e);}
}
unless(defined(&ESA_KDATA_CLIENT_SCRATCH1)) {
    sub ESA_KDATA_CLIENT_SCRATCH1 () {	( &ESA_KDATA_BASE_ADDR + 0x6f);}
}
unless(defined(&ESA_KDATA_KERNEL_SCRATCH)) {
    sub ESA_KDATA_KERNEL_SCRATCH () {	( &ESA_KDATA_BASE_ADDR + 0x70);}
}
unless(defined(&ESA_KDATA_KERNEL_ISR_SCRATCH)) {
    sub ESA_KDATA_KERNEL_ISR_SCRATCH () {	( &ESA_KDATA_BASE_ADDR + 0x71);}
}
unless(defined(&ESA_KDATA_OUEUE_LEFT)) {
    sub ESA_KDATA_OUEUE_LEFT () {	( &ESA_KDATA_BASE_ADDR + 0x72);}
}
unless(defined(&ESA_KDATA_QUEUE_RIGHT)) {
    sub ESA_KDATA_QUEUE_RIGHT () {	( &ESA_KDATA_BASE_ADDR + 0x73);}
}
unless(defined(&ESA_KDATA_ADC1_REQUEST)) {
    sub ESA_KDATA_ADC1_REQUEST () {	( &ESA_KDATA_BASE_ADDR + 0x74);}
}
unless(defined(&ESA_KDATA_ADC2_REQUEST)) {
    sub ESA_KDATA_ADC2_REQUEST () {	( &ESA_KDATA_BASE_ADDR + 0x75);}
}
unless(defined(&ESA_KDATA_CD_REQUEST)) {
    sub ESA_KDATA_CD_REQUEST () {	( &ESA_KDATA_BASE_ADDR + 0x76);}
}
unless(defined(&ESA_KDATA_MIC_REQUEST)) {
    sub ESA_KDATA_MIC_REQUEST () {	( &ESA_KDATA_BASE_ADDR + 0x77);}
}
unless(defined(&ESA_KDATA_ADC1_MIXER_REQUEST)) {
    sub ESA_KDATA_ADC1_MIXER_REQUEST () {	( &ESA_KDATA_BASE_ADDR + 0x78);}
}
unless(defined(&ESA_KDATA_ADC2_MIXER_REQUEST)) {
    sub ESA_KDATA_ADC2_MIXER_REQUEST () {	( &ESA_KDATA_BASE_ADDR + 0x79);}
}
unless(defined(&ESA_KDATA_CD_MIXER_REQUEST)) {
    sub ESA_KDATA_CD_MIXER_REQUEST () {	( &ESA_KDATA_BASE_ADDR + 0x7a);}
}
unless(defined(&ESA_KDATA_MIC_MIXER_REQUEST)) {
    sub ESA_KDATA_MIC_MIXER_REQUEST () {	( &ESA_KDATA_BASE_ADDR + 0x7b);}
}
unless(defined(&ESA_KDATA_MIC_SYNC_COUNTER)) {
    sub ESA_KDATA_MIC_SYNC_COUNTER () {	( &ESA_KDATA_BASE_ADDR + 0x7c);}
}
unless(defined(&ESA_KDATA_MIXER_WORD0)) {
    sub ESA_KDATA_MIXER_WORD0 () {	( &ESA_KDATA_BASE_ADDR2 + 0x);}
}
unless(defined(&ESA_KDATA_MIXER_WORD1)) {
    sub ESA_KDATA_MIXER_WORD1 () {	( &ESA_KDATA_BASE_ADDR2 + 0x1);}
}
unless(defined(&ESA_KDATA_MIXER_WORD2)) {
    sub ESA_KDATA_MIXER_WORD2 () {	( &ESA_KDATA_BASE_ADDR2 + 0x2);}
}
unless(defined(&ESA_KDATA_MIXER_WORD3)) {
    sub ESA_KDATA_MIXER_WORD3 () {	( &ESA_KDATA_BASE_ADDR2 + 0x3);}
}
unless(defined(&ESA_KDATA_MIXER_WORD4)) {
    sub ESA_KDATA_MIXER_WORD4 () {	( &ESA_KDATA_BASE_ADDR2 + 0x4);}
}
unless(defined(&ESA_KDATA_MIXER_WORD5)) {
    sub ESA_KDATA_MIXER_WORD5 () {	( &ESA_KDATA_BASE_ADDR2 + 0x5);}
}
unless(defined(&ESA_KDATA_MIXER_WORD6)) {
    sub ESA_KDATA_MIXER_WORD6 () {	( &ESA_KDATA_BASE_ADDR2 + 0x6);}
}
unless(defined(&ESA_KDATA_MIXER_WORD7)) {
    sub ESA_KDATA_MIXER_WORD7 () {	( &ESA_KDATA_BASE_ADDR2 + 0x7);}
}
unless(defined(&ESA_KDATA_MIXER_WORD8)) {
    sub ESA_KDATA_MIXER_WORD8 () {	( &ESA_KDATA_BASE_ADDR2 + 0x8);}
}
unless(defined(&ESA_KDATA_MIXER_WORD9)) {
    sub ESA_KDATA_MIXER_WORD9 () {	( &ESA_KDATA_BASE_ADDR2 + 0x9);}
}
unless(defined(&ESA_KDATA_MIXER_WORDA)) {
    sub ESA_KDATA_MIXER_WORDA () {	( &ESA_KDATA_BASE_ADDR2 + 0xa);}
}
unless(defined(&ESA_KDATA_MIXER_WORDB)) {
    sub ESA_KDATA_MIXER_WORDB () {	( &ESA_KDATA_BASE_ADDR2 + 0xb);}
}
unless(defined(&ESA_KDATA_MIXER_WORDC)) {
    sub ESA_KDATA_MIXER_WORDC () {	( &ESA_KDATA_BASE_ADDR2 + 0xc);}
}
unless(defined(&ESA_KDATA_MIXER_WORDD)) {
    sub ESA_KDATA_MIXER_WORDD () {	( &ESA_KDATA_BASE_ADDR2 + 0xd);}
}
unless(defined(&ESA_KDATA_MIXER_WORDE)) {
    sub ESA_KDATA_MIXER_WORDE () {	( &ESA_KDATA_BASE_ADDR2 + 0xe);}
}
unless(defined(&ESA_KDATA_MIXER_WORDF)) {
    sub ESA_KDATA_MIXER_WORDF () {	( &ESA_KDATA_BASE_ADDR2 + 0xf);}
}
unless(defined(&ESA_KDATA_MIXER_XFER0)) {
    sub ESA_KDATA_MIXER_XFER0 () {	( &ESA_KDATA_BASE_ADDR2 + 0x10);}
}
unless(defined(&ESA_KDATA_MIXER_XFER1)) {
    sub ESA_KDATA_MIXER_XFER1 () {	( &ESA_KDATA_BASE_ADDR2 + 0x11);}
}
unless(defined(&ESA_KDATA_MIXER_XFER2)) {
    sub ESA_KDATA_MIXER_XFER2 () {	( &ESA_KDATA_BASE_ADDR2 + 0x12);}
}
unless(defined(&ESA_KDATA_MIXER_XFER3)) {
    sub ESA_KDATA_MIXER_XFER3 () {	( &ESA_KDATA_BASE_ADDR2 + 0x13);}
}
unless(defined(&ESA_KDATA_MIXER_XFER4)) {
    sub ESA_KDATA_MIXER_XFER4 () {	( &ESA_KDATA_BASE_ADDR2 + 0x14);}
}
unless(defined(&ESA_KDATA_MIXER_XFER5)) {
    sub ESA_KDATA_MIXER_XFER5 () {	( &ESA_KDATA_BASE_ADDR2 + 0x15);}
}
unless(defined(&ESA_KDATA_MIXER_XFER6)) {
    sub ESA_KDATA_MIXER_XFER6 () {	( &ESA_KDATA_BASE_ADDR2 + 0x16);}
}
unless(defined(&ESA_KDATA_MIXER_XFER7)) {
    sub ESA_KDATA_MIXER_XFER7 () {	( &ESA_KDATA_BASE_ADDR2 + 0x17);}
}
unless(defined(&ESA_KDATA_MIXER_XFER8)) {
    sub ESA_KDATA_MIXER_XFER8 () {	( &ESA_KDATA_BASE_ADDR2 + 0x18);}
}
unless(defined(&ESA_KDATA_MIXER_XFER9)) {
    sub ESA_KDATA_MIXER_XFER9 () {	( &ESA_KDATA_BASE_ADDR2 + 0x19);}
}
unless(defined(&ESA_KDATA_MIXER_XFER_ENDMARK)) {
    sub ESA_KDATA_MIXER_XFER_ENDMARK () {	( &ESA_KDATA_BASE_ADDR2 + 0x1a);}
}
unless(defined(&ESA_KDATA_MIXER_TASK_NUMBER)) {
    sub ESA_KDATA_MIXER_TASK_NUMBER () {	( &ESA_KDATA_BASE_ADDR2 + 0x1b);}
}
unless(defined(&ESA_KDATA_CURRENT_MIXER)) {
    sub ESA_KDATA_CURRENT_MIXER () {	( &ESA_KDATA_BASE_ADDR2 + 0x1c);}
}
unless(defined(&ESA_KDATA_MIXER_ACTIVE)) {
    sub ESA_KDATA_MIXER_ACTIVE () {	( &ESA_KDATA_BASE_ADDR2 + 0x1d);}
}
unless(defined(&ESA_KDATA_MIXER_BANK_STATUS)) {
    sub ESA_KDATA_MIXER_BANK_STATUS () {	( &ESA_KDATA_BASE_ADDR2 + 0x1e);}
}
unless(defined(&ESA_KDATA_DAC_LEFT_VOLUME)) {
    sub ESA_KDATA_DAC_LEFT_VOLUME () {	( &ESA_KDATA_BASE_ADDR2 + 0x1f);}
}
unless(defined(&ESA_KDATA_DAC_RIGHT_VOLUME)) {
    sub ESA_KDATA_DAC_RIGHT_VOLUME () {	( &ESA_KDATA_BASE_ADDR2 + 0x20);}
}
unless(defined(&ESA_MAX_INSTANCE_MINISRC)) {
    sub ESA_MAX_INSTANCE_MINISRC () {	( &ESA_KDATA_INSTANCE_MINISRC_ENDMARK -  &ESA_KDATA_INSTANCE0_MINISRC);}
}
unless(defined(&ESA_MAX_VIRTUAL_DMA_CHANNELS)) {
    sub ESA_MAX_VIRTUAL_DMA_CHANNELS () {	( &ESA_KDATA_DMA_XFER_ENDMARK -  &ESA_KDATA_DMA_XFER0);}
}
unless(defined(&ESA_MAX_VIRTUAL_MIXER_CHANNELS)) {
    sub ESA_MAX_VIRTUAL_MIXER_CHANNELS () {	( &ESA_KDATA_MIXER_XFER_ENDMARK -  &ESA_KDATA_MIXER_XFER0);}
}
unless(defined(&ESA_MAX_VIRTUAL_ADC1_CHANNELS)) {
    sub ESA_MAX_VIRTUAL_ADC1_CHANNELS () {	( &ESA_KDATA_ADC1_XFER_ENDMARK -  &ESA_KDATA_ADC1_XFER0);}
}
unless(defined(&ESA_CDATA_INSTANCE_READY)) {
    sub ESA_CDATA_INSTANCE_READY () {	0x;}
}
unless(defined(&ESA_CDATA_HOST_SRC_ADDRL)) {
    sub ESA_CDATA_HOST_SRC_ADDRL () {	0x1;}
}
unless(defined(&ESA_CDATA_HOST_SRC_ADDRH)) {
    sub ESA_CDATA_HOST_SRC_ADDRH () {	0x2;}
}
unless(defined(&ESA_CDATA_HOST_SRC_END_PLUS_1L)) {
    sub ESA_CDATA_HOST_SRC_END_PLUS_1L () {	0x3;}
}
unless(defined(&ESA_CDATA_HOST_SRC_END_PLUS_1H)) {
    sub ESA_CDATA_HOST_SRC_END_PLUS_1H () {	0x4;}
}
unless(defined(&ESA_CDATA_HOST_SRC_CURRENTL)) {
    sub ESA_CDATA_HOST_SRC_CURRENTL () {	0x5;}
}
unless(defined(&ESA_CDATA_HOST_SRC_CURRENTH)) {
    sub ESA_CDATA_HOST_SRC_CURRENTH () {	0x6;}
}
unless(defined(&ESA_CDATA_IN_BUF_CONNECT)) {
    sub ESA_CDATA_IN_BUF_CONNECT () {	0x7;}
}
unless(defined(&ESA_CDATA_OUT_BUF_CONNECT)) {
    sub ESA_CDATA_OUT_BUF_CONNECT () {	0x8;}
}
unless(defined(&ESA_CDATA_IN_BUF_BEGIN)) {
    sub ESA_CDATA_IN_BUF_BEGIN () {	0x9;}
}
unless(defined(&ESA_CDATA_IN_BUF_END_PLUS_1)) {
    sub ESA_CDATA_IN_BUF_END_PLUS_1 () {	0xa;}
}
unless(defined(&ESA_CDATA_IN_BUF_HEAD)) {
    sub ESA_CDATA_IN_BUF_HEAD () {	0xb;}
}
unless(defined(&ESA_CDATA_IN_BUF_TAIL)) {
    sub ESA_CDATA_IN_BUF_TAIL () {	0xc;}
}
unless(defined(&ESA_CDATA_OUT_BUF_BEGIN)) {
    sub ESA_CDATA_OUT_BUF_BEGIN () {	0xd;}
}
unless(defined(&ESA_CDATA_OUT_BUF_END_PLUS_1)) {
    sub ESA_CDATA_OUT_BUF_END_PLUS_1 () {	0xe;}
}
unless(defined(&ESA_CDATA_OUT_BUF_HEAD)) {
    sub ESA_CDATA_OUT_BUF_HEAD () {	0xf;}
}
unless(defined(&ESA_CDATA_OUT_BUF_TAIL)) {
    sub ESA_CDATA_OUT_BUF_TAIL () {	0x10;}
}
unless(defined(&ESA_CDATA_DMA_CONTROL)) {
    sub ESA_CDATA_DMA_CONTROL () {	0x11;}
}
unless(defined(&ESA_CDATA_RESERVED)) {
    sub ESA_CDATA_RESERVED () {	0x12;}
}
unless(defined(&ESA_CDATA_FREQUENCY)) {
    sub ESA_CDATA_FREQUENCY () {	0x13;}
}
unless(defined(&ESA_CDATA_LEFT_VOLUME)) {
    sub ESA_CDATA_LEFT_VOLUME () {	0x14;}
}
unless(defined(&ESA_CDATA_RIGHT_VOLUME)) {
    sub ESA_CDATA_RIGHT_VOLUME () {	0x15;}
}
unless(defined(&ESA_CDATA_LEFT_SUR_VOL)) {
    sub ESA_CDATA_LEFT_SUR_VOL () {	0x16;}
}
unless(defined(&ESA_CDATA_RIGHT_SUR_VOL)) {
    sub ESA_CDATA_RIGHT_SUR_VOL () {	0x17;}
}
unless(defined(&ESA_CDATA_HEADER_LEN)) {
    sub ESA_CDATA_HEADER_LEN () {	0x18;}
}
unless(defined(&ESA_SRC3_DIRECTION_OFFSET)) {
    sub ESA_SRC3_DIRECTION_OFFSET () {	 &ESA_CDATA_HEADER_LEN;}
}
unless(defined(&ESA_SRC3_MODE_OFFSET)) {
    sub ESA_SRC3_MODE_OFFSET () {	( &ESA_CDATA_HEADER_LEN + 1);}
}
unless(defined(&ESA_SRC3_WORD_LENGTH_OFFSET)) {
    sub ESA_SRC3_WORD_LENGTH_OFFSET () {	( &ESA_CDATA_HEADER_LEN + 2);}
}
unless(defined(&ESA_SRC3_PARAMETER_OFFSET)) {
    sub ESA_SRC3_PARAMETER_OFFSET () {	( &ESA_CDATA_HEADER_LEN + 3);}
}
unless(defined(&ESA_SRC3_COEFF_ADDR_OFFSET)) {
    sub ESA_SRC3_COEFF_ADDR_OFFSET () {	( &ESA_CDATA_HEADER_LEN + 8);}
}
unless(defined(&ESA_SRC3_FILTAP_ADDR_OFFSET)) {
    sub ESA_SRC3_FILTAP_ADDR_OFFSET () {	( &ESA_CDATA_HEADER_LEN + 10);}
}
unless(defined(&ESA_SRC3_TEMP_INBUF_ADDR_OFFSET)) {
    sub ESA_SRC3_TEMP_INBUF_ADDR_OFFSET () {	( &ESA_CDATA_HEADER_LEN + 16);}
}
unless(defined(&ESA_SRC3_TEMP_OUTBUF_ADDR_OFFSET)) {
    sub ESA_SRC3_TEMP_OUTBUF_ADDR_OFFSET () {	( &ESA_CDATA_HEADER_LEN + 17);}
}
unless(defined(&ESA_MINISRC_IN_BUFFER_SIZE)) {
    sub ESA_MINISRC_IN_BUFFER_SIZE () {	(0x50 * 2);}
}
unless(defined(&ESA_MINISRC_OUT_BUFFER_SIZE)) {
    sub ESA_MINISRC_OUT_BUFFER_SIZE () {	(0x50 * 2* 2);}
}
unless(defined(&ESA_MINISRC_OUT_BUFFER_SIZE)) {
    sub ESA_MINISRC_OUT_BUFFER_SIZE () {	(0x50 * 2* 2);}
}
unless(defined(&ESA_MINISRC_TMP_BUFFER_SIZE)) {
    sub ESA_MINISRC_TMP_BUFFER_SIZE () {	(112+ ( &ESA_MINISRC_BIQUAD_STAGE * 3+ 4) * 2* 2);}
}
unless(defined(&ESA_MINISRC_BIQUAD_STAGE)) {
    sub ESA_MINISRC_BIQUAD_STAGE () {	2;}
}
unless(defined(&ESA_MINISRC_COEF_LOC)) {
    sub ESA_MINISRC_COEF_LOC () {	0x175;}
}
unless(defined(&ESA_DMACONTROL_BLOCK_MASK)) {
    sub ESA_DMACONTROL_BLOCK_MASK () {	0xf;}
}
unless(defined(&ESA_DMAC_BLOCK0_SELECTOR)) {
    sub ESA_DMAC_BLOCK0_SELECTOR () {	0x;}
}
unless(defined(&ESA_DMAC_BLOCK1_SELECTOR)) {
    sub ESA_DMAC_BLOCK1_SELECTOR () {	0x1;}
}
unless(defined(&ESA_DMAC_BLOCK2_SELECTOR)) {
    sub ESA_DMAC_BLOCK2_SELECTOR () {	0x2;}
}
unless(defined(&ESA_DMAC_BLOCK3_SELECTOR)) {
    sub ESA_DMAC_BLOCK3_SELECTOR () {	0x3;}
}
unless(defined(&ESA_DMAC_BLOCK4_SELECTOR)) {
    sub ESA_DMAC_BLOCK4_SELECTOR () {	0x4;}
}
unless(defined(&ESA_DMAC_BLOCK5_SELECTOR)) {
    sub ESA_DMAC_BLOCK5_SELECTOR () {	0x5;}
}
unless(defined(&ESA_DMAC_BLOCK6_SELECTOR)) {
    sub ESA_DMAC_BLOCK6_SELECTOR () {	0x6;}
}
unless(defined(&ESA_DMAC_BLOCK7_SELECTOR)) {
    sub ESA_DMAC_BLOCK7_SELECTOR () {	0x7;}
}
unless(defined(&ESA_DMAC_BLOCK8_SELECTOR)) {
    sub ESA_DMAC_BLOCK8_SELECTOR () {	0x8;}
}
unless(defined(&ESA_DMAC_BLOCK9_SELECTOR)) {
    sub ESA_DMAC_BLOCK9_SELECTOR () {	0x9;}
}
unless(defined(&ESA_DMAC_BLOCKA_SELECTOR)) {
    sub ESA_DMAC_BLOCKA_SELECTOR () {	0xa;}
}
unless(defined(&ESA_DMAC_BLOCKB_SELECTOR)) {
    sub ESA_DMAC_BLOCKB_SELECTOR () {	0xb;}
}
unless(defined(&ESA_DMAC_BLOCKC_SELECTOR)) {
    sub ESA_DMAC_BLOCKC_SELECTOR () {	0xc;}
}
unless(defined(&ESA_DMAC_BLOCKD_SELECTOR)) {
    sub ESA_DMAC_BLOCKD_SELECTOR () {	0xd;}
}
unless(defined(&ESA_DMAC_BLOCKE_SELECTOR)) {
    sub ESA_DMAC_BLOCKE_SELECTOR () {	0xe;}
}
unless(defined(&ESA_DMAC_BLOCKF_SELECTOR)) {
    sub ESA_DMAC_BLOCKF_SELECTOR () {	0xf;}
}
unless(defined(&ESA_DMACONTROL_PAGE_MASK)) {
    sub ESA_DMACONTROL_PAGE_MASK () {	0xf0;}
}
unless(defined(&ESA_DMAC_PAGE0_SELECTOR)) {
    sub ESA_DMAC_PAGE0_SELECTOR () {	0x30;}
}
unless(defined(&ESA_DMAC_PAGE1_SELECTOR)) {
    sub ESA_DMAC_PAGE1_SELECTOR () {	0x20;}
}
unless(defined(&ESA_DMAC_PAGE2_SELECTOR)) {
    sub ESA_DMAC_PAGE2_SELECTOR () {	0x10;}
}
unless(defined(&ESA_DMAC_PAGE3_SELECTOR)) {
    sub ESA_DMAC_PAGE3_SELECTOR () {	0x;}
}
unless(defined(&ESA_DMACONTROL_AUTOREPEAT)) {
    sub ESA_DMACONTROL_AUTOREPEAT () {	0x1000;}
}
unless(defined(&ESA_DMACONTROL_STOPPED)) {
    sub ESA_DMACONTROL_STOPPED () {	0x2000;}
}
unless(defined(&ESA_DMACONTROL_DIRECTION)) {
    sub ESA_DMACONTROL_DIRECTION () {	0x100;}
}
1;
