<!--

  $Id: article-roff.ts,v 1.7 1997/05/06 02:55:47 jfieber Exp jfieber $

  Copyright (C) 1996
       John R. Fieber.  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY JOHN R. FIEBER AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL JOHN R. FIEBER OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

-->

<!--

  This is an instant(1) translation specification to turn an
  SGML document marked up according to the ISO 12083 Article DTD into
  groff.

-->

<!DOCTYPE transpec PUBLIC "-//FreeBSD//DTD transpec//EN" [

<!ENTITY gt CDATA ">">
<!ENTITY lt CDATA "<">
<!ENTITY amp CDATA "&">

<!ENTITY r.pass CDATA "1">
<!ENTITY r.auth CDATA "2">
<!ENTITY r.auth1 CDATA "3">
<!ENTITY r.auth2 CDATA "4">
<!ENTITY r.tblfh CDATA "5">
<!ENTITY r.tblfr CDATA "6">
<!ENTITY r.tblfc CDATA "7">
<!ENTITY r.tblfs CDATA "8">

<!ENTITY cmap SYSTEM "roff.cmap">
<!ENTITY sdata SYSTEM "roff.sdata">

<!ENTITY family CDATA "P">

]>

<transpec>

<!-- Character and SDATA entity mapping -->
<cmap>&cmap;</cmap>
<smap>&sdata;</smap>

<!-- Transform rules -->

<var>tlevel 0</var>
<var>nauth 0</var>

<rule> <!-- Abstract -->
<match>
<gi>ABSTRACT
<action>
<start>^.DS I F
.if t .S -1^</start>
<end>^.if t .S P
.DE^</end>
</rule>

<rule> <!-- Accepted date of article -->
<match>
<gi>ACCEPTED
</rule>

<rule> <!-- Acid-free paper indicator -->
<match>
<gi>ACIDFREE
</rule>

<rule> <!-- Acklowledgments -->
<match>
<gi>ACK
</rule>

<rule> <!-- Acquisition number -->
<match>
<gi>ACQNO
</rule>

<rule> <!-- Advertisement -->
<match>
<gi>ADVERT
</rule>

<rule> <!-- Author's affiliation -->
<match>
<gi>AFF
</rule>

<rule> <!-- Afterword -->
<match>
<gi>AFTERWRD
</rule>

<rule> <!-- Alternate Title -->
<match>
<gi>ALTTITLE
</rule>

<rule> <!-- Appendix -->
<match>
<gi>APPENDIX
<action>
<start>${_set tlevel 1}</start>
</rule>

<rule> <!-- Appendix matter -->
<match>
<gi>APPMAT
<action>
<start>^.HU "Appendicies"
.HM A
.nr H1 0^</start>
</rule>

<rule> <!-- Appendix, reference to -->
<match>
<gi>APPREF
</rule>

<rule> <!-- Article -->
<match>
<gi>ARTICLE
<action>
<start>^.\" Generated ${date} using ${transpec}
.\" by ${user}@${host}
.if t \{\
.nr L 10.25i
.nr W 5.0i
.nr O 1.75i
.nr S 11
.\}
.if n .nr W 70n
.so /usr/share/tmac/tmac.m
.nr Pt 2
.nr Ps 0
.ie t \{\
.  fam &family;
.  ds HP 14 12 10 10 10 10 10
.  ds HF &family;B &family;B &family;B &family;BI &family;I &family;I &family;I 
.  nr Hy 1
.  nr Pi 3
.  nr Si 3
.\}
.el \{\
.  SA 0
.  ftr C R
.  nr Hy 0
.\}
.de continue
.if \\n(.$ \\$*
..
.PH "'${_followrel descendant TITLE &r.pass;}''%'"
.PF "'${_followrel descendant DATE &r.pass;}''${_followrel descendant AUTHOR &r.pass;}'"
.nr Hs 3
.nr Hu 1
.nr N 1     <!-- header at the bottom of the first page -->
.nr Pgps 0  <!-- header/footer size immune from .S -->^</start>
<end>^</end>
</rule>

<rule> <!-- Article unique ID -->
<match>
<gi>ARTID
</rule>

<rule> <!-- Reference to artwork -->
<match>
<gi>ARTREF
</rule>

<rule> <!-- Artwork -->
<match>
<gi>ARTWORK
<action>
<start>^.PSPIC ${_filename}^</start>
</rule>

<rule> <!-- Asequential serial item -->
<match>
<gi>ASEQNTL
</rule>

<rule> <!-- Author group -->
<match>
<gi>AUTHGRP
<action>
<start>^.DS C^</start>
<end>^.DE^</end>

<rule> <!-- Author -->
<match>
<gi>AUTHOR
<action>
<start>^</start>
<end>^</end>
</rule>

<rule> <!-- Distributor/available from -->
<match>
<gi>AVAIL
</rule>

<rule> <!-- Back matter -->
<match>
<gi>BACK
</rule>

<rule> <!-- Bibliographic list -->
<match>
<gi>BIBLIST
<action>
<start>^.HU "References"
.VL \n(Li^</start>
<end>^.LE^</end>
</rule>

<rule> <!-- Body -->
<match>
<gi>BODY
<!--
<action>
<start>^.S C 20^</start>
<end>^.br
.S C^</end>
-->
</rule>

<rule> <!-- Book document type-->
<match>
<gi>BOOK
</rule>

<rule> <!-- Quotation, block style -->
<match>
<gi>BQ
<action>
<start>
^.if t .S -1
.DS I F^</start>
<end>
^.DE
.if t .S P
.continue </end>
</rule>

<rule> <!-- Catalog -->
<match>
<gi>CATALOG
</rule>

<rule> <!-- Category of article -->
<match>
<gi>CATEGORY
</rule>

<rule> <!-- Table cell entry -->
<match>
<gi>CELL
<action>
<end>@</end>
</rule>

<rule> <!-- Chapter -->
<match>
<gi>CHAPTER
<action>
<start>${_set tlevel 1}</start>
</rule>

<rule> <!-- Citation -->
<match>
<gi>CITATION
<relation>descendant SERTITLE
<action>
<ignore>all
<start>^.LI
${_set nauth 0}${_find gi AUTHOR &r.auth;}
(${_find gi DATE &r.pass;}).
${_find gi TITLE &r.pass;}.
\fI${_find gi SERTITLE &r.pass;}\fP
${_find gi OTHINFO &r.pass;}:${_find gi PAGES &r.pass;}.^</start>
</rule>


<rule> <!-- Citation without a SERTITLE is a book (with location) -->
<match>
<gi>CITATION
<relation>descendant LOCATION
<action>
<ignore>all
<start>^.LI
${_set nauth 0}${_find gi AUTHOR &r.auth;}
(${_find gi DATE &r.pass;}).
${_find gi TITLE &r.pass;}.
${_find gi LOCATION &r.pass;}:
${_find gi OTHINFO &r.pass;}.^</start>
</rule>


<rule> <!-- Citation without a SERTITLE is a book (without location) -->
<match>
<gi>CITATION
<action>
<ignore>all
<start>^.LI
${_set nauth 0}${_find gi AUTHOR &r.auth;}
(${_find gi DATE &r.pass;}).
${_find gi TITLE &r.pass;}.
${_find gi OTHINFO &r.pass;}.^</start>
</rule>

<rule id="&r.auth"> <!-- Format the authors name -->
<match>
<gi>_r.auth
<action>
<ignore>all
<start>${_isset nauth 0 &r.auth1;}${_isset nauth 1 &r.auth2}</start>
<end>${_set nauth 1}</end>
</rule>

<rule id="&r.auth1"> <!-- First author listed last name first. -->
<match>
<gi>_first_author
<action>
<ignore>all
<start>${_find gi SURNAME &r.pass}, ${_find gi FNAME &r.pass}</start>
</rule>

<rule id="&r.auth2"> <!-- Subsequent authors listed first name first.-->
<match>
<gi>_second_author
<action>
<ignore>all
<start>, ${_find gi FNAME &r.pass} ${_find gi SURNAME &r.pass}</start>
</rule>

<rule> <!-- Reference to a citation -->
<match>
<gi>CITEREF
</rule>

<rule> <!-- City -->
<match>
<gi>CITY
</rule>

<rule> <!-- Poem continued line -->
<match>
<gi>CLINE
</rule>

<rule> <!-- Coden -->
<match>
<gi>CODEN
</rule>

<rule> <!-- Conference group -->
<match>
<gi>CONFGRP
</rule>

<rule> <!-- Conference name -->
<match>
<gi>CONFNAME
</rule>

<rule> <!-- Contract number -->
<match>
<gi>CONTRACT
</rule>

<rule> <!-- Corporate author -->
<match>
<gi>CORPAUTH
</rule>

<rule> <!-- Country -->
<match>
<gi>COUNTRY
</rule>

<rule> <!-- Copyright -->
<match>
<gi>CPYRT
</rule>

<rule> <!-- Copyright clearance center -->
<match>
<gi>CPYRTCLR
</rule>

<rule> <!-- Copyright notice-name -->
<match>
<gi>CPYRTNME
</rule>

<rule> <!-- Date -->
<match>
<gi>DATE
<context>FRONT
<action>
<start>^.DS C^</start>
<end>^.DE^</end>
</rule>

<rule> <!-- Definition description -->
<match>
<gi>DD
</rule>

<rule> <!-- Definition description head -->
<match>
<gi>DDHD
</rule>

<rule> <!-- Dedication -->
<match>
<gi>DED
</rule>

<rule> <!-- Definition list -->
<match>
<gi>DEFLIST
<action>
<start>^.BVL \n(Li \n(Li*1/2^</start>
<end>^.LE^</end>
</rule>

<rule> <!-- Degree granted -->
<match>
<gi>DEGREE
</rule>

<rule> <!-- Display formula group -->
<match>
<gi>DFORMGRP
</rule>

<rule> <!-- Display formula -->
<match>
<gi>DFORMULA
</rule>

<rule> <!-- Edition statement -->
<match>
<gi>EDITION
</rule>

<rule> <!-- Electronic mail address -->
<match>
<gi>EMAIL
</rule>

<rule> <!-- Emphasized text -->
<match>
<gi>EMPH
<attval>TYPE 1
<action>
<start>\fB</start>
<end>\fP</end>
</rule>

<rule> <!-- Emphasized text -->
<match>
<gi>EMPH
<attval>TYPE 2
<action>
<start>\fI</start>
<end>\fP</end>
</rule>

<rule> <!-- Emphasized text -->
<match>
<gi>EMPH
<action>
<start>\fI</start>
<end>\fP</end>
</rule>

<rule> <!-- Extent of work (number of pages) -->
<match>
<gi>EXTENT
</rule>

<rule> <!-- FAX number -->
<match>
<gi>FAX
</rule>

<rule> <!-- Figure -->
<match>
<gi>FIG
<action>
<start>^.PSPIC ${_filename}^</start>
</rule>

<rule> <!-- Figure group -->
<match>
<gi>FIGGRP
<action>
<start>^.DS^</start>
<end>^.DE^</end>
</rule>

<rule> <!-- Reference to a figure -->
<match>
<gi>FIGREF
</rule>

<rule> <!-- First (given) name -->
<match>
<gi>FNAME
<action>
<end>\& \&</end>
</rule>

<rule> <!-- Reference to a footnote -->
<match>
<gi>FNOTEREF
</rule>

<rule> <!-- Footnote -->
<match>
<gi>FOOTNOTE
<action>
<start>\*F
'FS^</start>
<end>^.FE
.continue </end>
</rule>

<rule> <!-- Foreward -->
<match>
<gi>FOREWARD
</rule>

<rule> <!-- Reference to a formula -->
<match>
<gi>FORMREF
</rule>

<rule> <!-- Mathematical formula -->
<match>
<gi>FORMULA
</rule>

<rule> <!-- First page -->
<match>
<gi>FPAGE
</rule>

<rule> <!-- Front matter -->
<match>
<gi>FRONT
</rule>

<rule> <!-- Reference to glossary -->
<match>
<gi>GLOSREF
</rule>

<rule> <!-- Glossary -->
<match>
<gi>GLOSSARY
</rule>

<rule> <!-- Heading -->
<match>
<gi>HEAD
<context>TBODY
<action>
<end>@</end>
</rule>

<rule> <!-- History -->
<match>
<gi>HISTORY
</rule>

<rule> <!-- Individual's address -->
<match>
<gi>INDADDR
</rule>

<rule> <!-- Index -->
<match>
<gi>INDEX
</rule>

<rule> <!-- Reference to an index item -->
<match>
<gi>INDXREF
</rule>

<rule> <!-- Index flag -->
<match>
<gi>INDXFLAG
</rule>

<rule> <!-- Index term by name -->
<match>
<gi>INDXNAME
</rule>

<rule> <!-- Index term by subject -->
<match>
<gi>INDXSUBJ
</rule>

<rule> <!-- Introduction -->
<match>
<gi>INTRO
</rule>

<rule> <!-- International Standard Book Number -->
<match>
<gi>ISBN
</rule>

<rule> <!-- International Standard Serial Number -->
<match>
<gi>ISSN
</rule>

<rule> <!-- Issue identification -->
<match>
<gi>ISSUEID
</rule>

<rule> <!-- Issue number -->
<match>
<gi>ISSUENO
</rule>

<rule> <!-- Issue part -->
<match>
<gi>ISSUEPT
</rule>

<rule> <!-- Item -->
<match>
<gi>ITEM
<action>
<start>^.LI^</start>
</rule>

<rule> <!-- Key phrase -->
<match>
<gi>KEYPHRAS
</rule>

<rule> <!-- Key word -->
<match>
<gi>KEYWORD
</rule>

<rule> <!-- Library of Congress card number -->
<match>
<gi>LCCARDNO
</rule>

<rule> <!-- List: Arabic numerals -->
<match>
<gi>LIST
<attval>TYPE 1
<action>
<start>^.AL 1^</start>
<end>^.LE
.SP .5v
.continue </end>
</action>

<rule> <!-- List: Alphabetic -->
<match>
<gi>LIST
<attval>TYPE 2
<action>
<start>^.AL A^</start>
<end>^.LE
.SP .5v
.continue </end>
</action>

<rule> <!-- List: Roman numerals -->
<match>
<gi>LIST
<attval>TYPE 3
<action>
<start>^.AL I^</start>
<end>^.LE
.SP .5v
.continue </end>
</action>

<rule> <!-- List: Bullets -->
<match>
<gi>LIST
<attval>TYPE 4
<action>
<start>^.BL^</start>
<end>^.LE
.SP .5v
.continue </end>
</action>

<rule> <!-- List: Dashes -->
<match>
<gi>LIST
<attval>TYPE 5
<action>
<start>^.DL^</start>
<end>^.LE
.SP .5v
.continue </end>
</action>

<rule> <!-- List -->
<match>
<gi>LIST
<action>
<start>^.BL^</start>
<end>^.LE
.SP .5v
.continue </end>
</action>

<rule> <!-- Literal Text -->
<match>
<gi>LIT
<action>
<start>	^.if t .br
.if t .S -1
.DS I
.fam C^</start>
<end>
^.fam &family;
.DE
.if t .S P
.continue </end>
</rule>

<rule> <!-- Location -->
<match>
<gi>LOCATION
</rule>

<rule> <!-- Last page -->
<match>
<gi>LPAGE
</rule>

<rule> <!-- Miscellaneous date -->
<match>
<gi>MISC
</rule>

<rule> <!-- Monographic series number -->
<match>
<gi>MSN
</rule>

<rule> <!-- Named location (of a link) -->
<match>
<gi>NAMELOC
</rule>

<rule> <!-- List of named objects -->
<match>
<gi>NMLIST
</rule>

<rule> <!-- Number -->
<match>
<gi>NO
</rule>

<rule> <!-- Note -->
<match>
<gi>NOTE
</rule>

<rule> <!-- Reference to a note -->
<match>
<gi>NOTEREF
</rule>

<rule> <!-- Notes (Section of a doc.) -->
<match>
<gi>NOTES
</rule>

<rule> <!-- Organization address -->
<match>
<gi>ORGADDR
</rule>

<rule> <!-- Division within organization -->
<match>
<gi>ORGDIV
</rule>

<rule> <!-- Name of organization -->
<match>
<gi>ORGNAME
</rule>

<rule> <!-- Other bibliographic info -->
<match>
<gi>OTHINFO
</rule>

<rule> <!-- Paragraph -->
<match>
<gi>P
<context>(CELL|TSTUB)
</rule>

<rule> <!-- Paragraph -->
<match>
<gi>P
<context>FOOTNOTE
</rule>

<rule> <!-- Paragraph -->
<match>
<gi>P
<context>ITEM|DD
<nthchild>1
</rule>

<rule> <!-- Paragraph -->
<match>
<gi>P
<context>ITEM|DD
<action>
<start>^.P 1^</start>
</rule>

<rule> <!-- Paragraph -->
<match>
<gi>P
<context>BQ|SUPMAT
<action>
<start>^.P 0^</start>
</rule>

<rule> <!-- Paragraph -->
<match>
<gi>P
<relation>sibling-1 TITLE
<action>
<start>^.P 0^</start>
</rule>

<rule> <!-- Paragraph -->
<match>
<gi>P
<action>
<start>^.P 1^</start>
</rule>

<rule> <!-- Packaging method -->
<match>
<gi>PACKAGE
</rule>

<rule> <!-- Page number(s) of reference -->
<match>
<gi>PAGES
</rule>

<rule> <!-- Part (Section in a document) -->
<match>
<gi>PART
</rule>

<rule> <!-- Telephone number -->
<match>
<gi>PHONE
</rule>

<rule> <!-- Poem -->
<match>
<gi>POEM
</rule>

<rule> <!-- Line in a poem -->
<match>
<gi>POEMLINE
</rule>

<rule> <!-- Post office box -->
<match>
<gi>POSTBOX
</rule>

<rule> <!-- Postal code -->
<match>
<gi>POSTCODE
</rule>

<rule> <!-- Preface -->
<match>
<gi>PREFACE
</rule>

<rule> <!-- Price -->
<match>
<gi>PRICE
</rule>

<rule> <!-- Pbulisher's front matter -->
<match>
<gi>PUBFRONT
</rule>

<rule> <!-- Publisher's unique id number -->
<match>
<gi>PUBID
</rule>

<rule> <!-- Publisher name -->
<match>
<gi>PUBNAME
</rule>

<rule> <!-- Quotation, inline -->
<match>
<gi>Q
<context>Q
<action>
<start>`</start>
<end>'</end>
</rule>

<rule> <!-- Quotation, inline -->
<match>
<gi>Q
<action>
<start>``</start>
<end>''</end>
</rule>

<rule> <!-- Received date -->
<match>
<gi>RECEIVED
</rule>

<rule> <!-- Report identifier -->
<match>
<gi>REPORTID
</rule>

<rule> <!-- Reprint source -->
<match>
<gi>REPRINT
</rule>

<rule> <!-- Revised date -->
<match>
<gi>REVISED
</rule>

<rule> <!-- Role indicator -->
<match>
<gi>ROLE
</rule>

<rule> <!-- If this isthe first row following a HEAD, add a line -->
<match>
<gi>ROW
<relation>sibling-1 HEAD
<action>
<start>^_^</start>
</rule>

<rule> <!-- Table row -->
<match>
<gi>ROW
<action>
<start>^</start>
</rule>

<rule> <!-- Standard address number -->
<match>
<gi>SAN
</rule>

<rule> <!-- Degree granting institution -->
<match>
<gi>SCHOOL
</rule>

<rule> <!-- Reference to a section -->
<match>
<gi>SECREF
</rule>

<rule> <!-- Section -->
<match>
<gi>SECTION
<action>
<start>${_set tlevel 2}</start>
</rule>

<rule> <!-- Serial back matter -->
<match>
<gi>SERBACK
</rule>

<rule> <!-- Serial body matter -->
<match>
<gi>SERBODY
</rule>

<rule> <!-- Serial front matter -->
<match>
<gi>SERFRONT
</rule>

<rule> <!-- Serial document type -->
<match>
<gi>SERIAL
</rule>

<rule> <!-- Part in a serial -->
<match>
<gi>SERPART
</rule>

<rule> <!-- Publisher's front matter in a serial -->
<match>
<gi>SERPUBFR
</rule>

<rule> <!-- Section in a serial -->
<match>
<gi>SERSEC
</rule>

<rule> <!-- Title, (monographic) series -->
<match>
<gi>SERTITLE
</rule>

<rule> <!-- Conference sponsor -->
<match>
<gi>SPONSOR
</rule>

<rule> <!-- Stanza in a Poem -->
<match>
<gi>STANZA
</rule>

<rule> <!-- State -->
<match>
<gi>STATE
</rule>

<rule> <!-- Street -->
<match>
<gi>STREET
</rule>

<rule> <!-- Subject -->
<match>
<gi>SUBJECT
</rule>

<rule> <!-- Subsection level 1 -->
<match>
<gi>SUBSECT1
<action>
<start>${_set tlevel 3}</start>
</rule>

<rule> <!-- Subsection level 2 -->
<match>
<gi>SUBSECT2
<action>
<start>${_set tlevel 4}</start>
</rule>

<rule> <!-- Subsection level 3 -->
<match>
<gi>SUBSECT3
<action>
<start>${_set tlevel 5}</start>
</rule>

<rule> <!-- Subsection level 4 -->
<match>
<gi>SUBSECT4
<action>
<start>${_set tlevel 6}</start>
</rule>

<rule> <!-- Subsection level 5 -->
<match>
<gi>SUBSECT5
<action>
<start>${_set tlevel 7}</start>
</rule>

<rule> <!-- Subsection level 6 -->
<match>
<gi>SUBSECT6
<action>
<start>${_set tlevel 8}</start>
</rule>

<rule> <!-- Serial Subtitle -->
<match>
<gi>SUBTITLE
<action>
<start>^.DS C^</start>
<end>^.DE^</end>
</rule>

<rule> <!-- Available supporting material -->
<match>
<gi>SUPMATL
<action>
<start>^.DS C^</start>
<end>^.DE^</end>
</rule>

<rule> <!-- Supplemental to issue ID -->
<match>
<gi>SUPPLID
</rule>

<rule> <!-- Surname -->
<match>
<gi>SURNAME
</rule>

<rule> <!-- Table -->
<match>
<gi>TABLE
<action>
<start>^.DS
.if t .S -1^</start>
<end>^.if t .S P
.DE^</end>
</rule>

<rule> <!-- Reference to a table -->
<match>
<gi>TABLEREF
</rule>

<rule> <!-- Table Body -->
<match>
<gi>TBODY
<action>
<start>^.TS
center,tab(@);
${_find gi HEAD &r.tblfh}
${_find gi ROW &r.tblfr}.
_^</start>
<end>^_
.TE^</end>
</rule>

<rule id ="&r.tblfh">
<match>
<gi>_header_format
<action>
<ignore>all
<start>cI </start>
</rule>

<rule id ="&r.tblfr">
<match>
<gi>_row_format
<action>
<ignore>all
<start>^${_find gi TSTUB &r.tblfs}${_find gi CELL &r.tblfc}</start>
</rule>

<rule id ="&r.tblfc"> <!-- Format code for a CELL -->
<match>
<gi>_cell_format
<action>
<ignore>all
<start>c </start>
</rule>

<rule id ="&r.tblfs"> <!-- Format code for a TSTUB -->
<match>
<gi>_tstub_format
<action>
<ignore>all
<start>cI </start>
</rule>

<rule> <!-- Defined Term -->
<match>
<gi>TERM
<context>DEFLIST
<action>
<start>^.LI "\fB</start>
<end>\fP"^</end>
</rule>

<rule> <!-- Title -->
<match>
<gi>TITLE
<context>FIGGRP
<action>
<start>^.FG "</start>
<end>"^</end>
</rule>

<rule> <!-- Title -->
<match>
<gi>TITLE
<context>TABLE
<action>
<start>^.TB "</start>
<end>"^</end>
</rule>

<rule> <!-- Title -->
<match>
<gi>TITLE
<context>TITLEGRP
<action>
<start>^.S 16^</start>
<end>^.S P
.SP^</end>
</rule>

<rule> <!-- Title -->
<match>
<gi>TITLE
<action>
<start>^.H ${tlevel} "</start>
<end>"^</end>
</rule>


<rule> <!-- Title group -->
<match>
<gi>TITLEGRP
<action>
<start>^.DS C^</start>
<end>^.DE^</end>

<rule> <!-- Table of contents -->
<match>
<gi>TOC
</rule>

<rule> <!-- Table stub -->
<match>
<gi>TSTUB
<action>
<end>@</end>
</rule>

<rule> <!-- Table column subordinate head -->
<match>
<gi>TSUBHEAD
</rule>

<rule> <!-- Curriculum vita -->
<match>
<gi>VITA
</rule>

<rule> <!-- Volume identifier -->
<match>
<gi>VOLID
</rule>

<!-- ************************************************************** -->

<rule> <!-- Catch all -->
<match>
<gi>*
</rule>


<rule id="&r.pass"> <!-- Pass the content through -->
<match>
<gi>_pass-text
</rule>

</transpec>
