#
# This script was written by Felix Huber <huberfelix@webtopia.de>
#
# v. 1.06 (last update 07.11.01)

if(description)
{
 script_id(10797);
 script_version ("$Revision: 1.4.2.2 $");
 name["english"] = "ColdFusion Debug Mode";
 script_name(english:name["english"]);

 desc["english"] = "
It is possible to see the ColdFusion Debug Information
by appending ?Mode=debug at the end of the request
(like GET /index.cfm?Mode=debug).

4.5 and 5.0 are definitely concerned (probably in
addition older versions).

The Debug Information usually contain sensitive data such
as Template Path or Server Version.

Solution:  Enter a IP (e.g. 127.0.0.1) in the Debug Settings
			within the ColdFusion Admin.


Risk factor : Medium";


 script_description(english:desc["english"]);

 summary["english"] = "Get ColdFusion Debug Information";

 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);


 script_copyright(english:"This script is Copyright (C) 2001 Felix Huber");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes");
 script_dependencie("httpver.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#
include("http_func.inc");
 
port = get_kb_item("Services/www");
if(!port)port = 80;

dir[0] = "/";
dir[1] = "/index.cfm";
dir[2] = "/index.cfml";
dir[3] = "/home.cfm";
dir[4] = "/home.cfml";
dir[5] = "/default.cfml";
dir[6] = "/default.cfm";
dir[7] = "";

if(get_port_state(port))
{
 for (i = 0; dir[i] ; i = i + 1)
 {
     soc = http_open_socket(port);
     if(!soc)exit(0);
     
     if(soc)
     {
        url = string(dir[i], "?Mode=debug");
 
 
        req = http_get(item:url, port:port);
        send(socket:soc, data:req);
        r = http_recv(socket:soc);
        close(soc);
       
	if("CF_TEMPLATE_PATH" >< r)
        	{
        		security_hole(port);
        		exit(0);
        	}
     }
  }
 
 dirz = string(cgibin(), "/");
 soc = http_open_socket(port);
 if(!soc)exit(0);
     
 if(soc)
 {
    url = string(dirz, "?Mode=debug");


    req = http_get(item:url, port:port);
    send(socket:soc, data:req);
    r = http_recv(socket:soc);
    http_close_socket(soc);
   
    if("CF_TEMPLATE_PATH" >< r)
	    {
		    security_hole(port);
		    exit(0);
	    }
 }
}
