#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10886);
 script_version ("$Revision: 1.1 $");
 
 
 name["english"] = "BIND vulnerable to DNS storm";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote BIND server, according to its
version number, is vulnerable to a DNS storm
attack

Solution : upgrade to bind 8.3.1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks the remote BIND version";
 summary["francais"] = "Vrifie le numro de version du BIND distant";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2002 Renaud Deraison");
 family["english"] = "General";
 family["francais"] = "General";
 script_family(english:family["english"], francais:family["francais"]);

 script_dependencie("bind_version.nasl");
 script_require_keys("bind/version");
 exit(0);
}

vers = get_kb_item("bind/version");
if(!vers)exit(0);

if(ereg(string:vers,
	 pattern:"8\.(([0-1].*)|(2\.[0-2])|(3\.0)).*"))security_hole(53);

