'\" Color=Green
'\" 
'\"
'\" Copyright (c) 1994 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) focusNext.n 1.8 95/08/12 17:35:28
'\" 
.so STk-man.macros
.TH Tk:focus-next n 3.1 STk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tk:focus-next, Tk:focus-prev, Tk:focus-follows-mouse, Tk:focus-on, Tk:focus-off \- Utility procedures for managing the input focus.
.SH SYNOPSIS
(\fBTk:focus-next \fIwindow\fR)
.sp
(\fBTk:focus-prev \fIwindow\fR)
.sp
(\fBTk:focus-follows-mouse\fR)
.BE

.SH DESCRIPTION
.PP
\fBTk:focus-next\fR is a utility procedure used for keyboard traversal.
It returns the ``next'' window after \fIwindow\fR in focus order.
The focus order is determined by
the stacking order of windows and the structure of the window hierarchy.
Among siblings, the focus order is the same as the stacking order, with the
lowest window being first.
If a window has children, the window is visited first, followed by
its children (recursively), followed by its next sibling.
Top-level windows other than \fIwindow\fR are skipped, so that
\fBTk:focus-next\fR never returns a window in a different top-level
from \fIwindow\fR.
.PP
After computing the next window, \fBTk:focus-next\fR examines the
window's \fB:takefocus\fR option to see whether it should be skipped.
If so, \fBTk:focus-next\fR continues on to the next window in the focus
order, until it eventually finds a window that will accept the focus
or returns back to \fIwindow\fR.
.PP
\fBTk:focus-prev\fR is similar to \fBTk:focus-next\fR except that it
returns the window just before \fIwindow\fR in the focus order.
.PP
\fBTk:focus-follows-mouse\fR changes the focus model for the application
to an implicit one where the window under the mouse gets the focus.
After this procedure is called, whenever the mouse enters a window
Tk will automatically give it the input focus.
The \fBfocus\fR command may be used to move the focus to a window
other than the one under the mouse, but as soon as the mouse moves
into a new window the focus will jump to that window.
Note: at present there is no built-in support for returning the
application to an explicit focus model;  to do this you'll have
to write a script that deletes the bindings created by
\fBTk:focus-follows-mouse\fR.

.PP
\fBTk:focus-on\fR and \fBTk:focus-off\fR are simpy defined as
.CS
(define Tk:focus-on  (lambda (w) #t))
(define Tk:focus-off (lambda (w) #f))
.CE
This procedures can be used by the focus traversal algorithm presented in the 
\fBoptions\fR manual page.
.SH SEE ALSO
focus, toplevel
