<?php
// $Id: class_mem.inc,v 1.4 2002/11/29 10:45:46 dijkstra Exp $
require_once("class_graph.inc");

class MEM_Graph extends Graph {
    function MEM_Graph() {
	// get all the sensible defaults from our parent class
	$this->init();
    }

    function execute($url) {
	$this->url2options($url);
	// and add a few private things
	$this->graphsettings["rawcmdline"] .=" -v 'mem' -b 1024 ";
	
	$this->shortcut = array_merge($this->shortcut, array(
	    "mem" => array(
		"brief" => array(
		    "dsdefinition" => array(
			"DEF:A=".$this->get("rrdfile").":real_active:AVERAGE",
			"DEF:B=".$this->get("rrdfile").":real_total:AVERAGE",
			"DEF:C=".$this->get("rrdfile").":free:AVERAGE",
			"DEF:D=".$this->get("rrdfile").":swap_used:AVERAGE",
			"DEF:E=".$this->get("rrdfile").":swap_total:AVERAGE"),
		    "graphdefinition" => array(
			"AREA:B#008B8B:real",
			"GPRINT:B:AVERAGE:'%.0lf%s\g'",
			"STACK:C#3CB371:free",
			"GPRINT:C:AVERAGE:'%.0lf%s\g'",
			"LINE1:A#00FFFF:active",
			"GPRINT:A:AVERAGE:'%.0lf%s\g'",
			"LINE1:D#888C00:swap_used",
			"GPRINT:D:AVERAGE:'%.0lf%s\g'",
			"LINE2:E#FF8C00:swap_total",
			"GPRINT:E:AVERAGE:'%.0lf%s\g'")),
		"detailed" => array(
		    "dsdefinition" => array(
			"DEF:A=".$this->get("rrdfile").":real_active:AVERAGE",
			"DEF:B=".$this->get("rrdfile").":real_total:AVERAGE",
			"DEF:C=".$this->get("rrdfile").":free:AVERAGE",
			"DEF:D=".$this->get("rrdfile").":swap_used:AVERAGE",
			"DEF:E=".$this->get("rrdfile").":swap_total:AVERAGE"),
		    "graphdefinition" => array(
			'COMMENT:"                  min        avg        max        last\n"',
			'AREA:B#008B8B:"real      "',
			'GPRINT:B:MIN:" %6.2lf %sb"',
			'GPRINT:B:AVERAGE:"%6.2lf %sb"',
			'GPRINT:B:MAX:"%6.2lf %sb"',
			'GPRINT:B:LAST:"%6.2lf %sb\n"',
			'STACK:C#3CB371:"free      "',
			'GPRINT:C:MIN:" %6.2lf %sb"',
			'GPRINT:C:AVERAGE:"%6.2lf %sb"',
			'GPRINT:C:MAX:"%6.2lf %sb"',
			'GPRINT:C:LAST:"%6.2lf %sb\n"',
			'LINE1:A#00FFFF:"active    "',
			'GPRINT:A:MIN:" %6.2lf %sb"',
			'GPRINT:A:AVERAGE:"%6.2lf %sb"',
			'GPRINT:A:MAX:"%6.2lf %sb"',
			'GPRINT:A:LAST:"%6.2lf %sb\n"',
			'LINE1:D#888C00:"swap used "',
			'GPRINT:D:MIN:" %6.2lf %sb"',
			'GPRINT:D:AVERAGE:"%6.2lf %sb"',
			'GPRINT:D:MAX:"%6.2lf %sb"',
			'GPRINT:D:LAST:"%6.2lf %sb\n"',
			'LINE2:E#FF8C00:"swap total"',
			'GPRINT:E:MIN:" %6.2lf %sb"',
			'GPRINT:E:AVERAGE:"%6.2lf %sb"',
			'GPRINT:E:MAX:"%6.2lf %sb"',
			'GPRINT:E:LAST:"%6.2lf %sb\n"')))));

	$this->graphdefaults = array_merge($this->graphdefaults, 
					   $this->shortcut["mem"]["brief"]);
	$this->url2options($url);
    }
}
?>
