<?php
// $Id: class_io.inc,v 1.4 2002/11/29 10:45:46 dijkstra Exp $
require_once("class_graph.inc");

class IO_Graph extends Graph {
    function IO_Graph() {
	// get all the sensible defaults from our parent class
	$this->init(); 
    }
    function execute($url) {
	$this->url2options($url);

	// and add a few private things
	$this->graphsettings["rawcmdline"] .=" -v 'io(".$this->get("name").")'";
	$this->shortcut = array_merge($this->shortcut, array(
	    "io" => array(
		"brief" => array(
		    "dsdefinition" => array(
			"DEF:A=".$this->get("rrdfile").":bytes:AVERAGE "),
		    "graphdefinition" => array(
			'COMMENT:"            min          avg          max          last\n"',
			"AREA:A#00FF00:'bytes'",
			"GPRINT:A:MIN:'%6.2lf %sBps'",
			"GPRINT:A:AVERAGE:'%6.2lf %sBps'",
			"GPRINT:A:MAX:'%6.2lf %sBps'",
			"GPRINT:A:LAST:'%6.2lf %sBps'")),
		"all" => array(
		    "dsdefinition" => array(
			"DEF:A=".$this->get("rrdfile").":transfers:AVERAGE ",
			"DEF:B=".$this->get("rrdfile").":seeks:AVERAGE ",
			"DEF:C=".$this->get("rrdfile").":bytes:AVERAGE "),
		    "graphdefinition" => array(
			'COMMENT:"               min          avg          max          last\n"',
			"AREA:C#00FF00:'bytes    '",
			"GPRINT:C:MIN:'%4.2lf %sBps'",
			"GPRINT:C:AVERAGE:'%4.2lf %sBps'",
			"GPRINT:C:MAX:'%4.2lf %sBps'",
			'GPRINT:C:LAST:"%4.2lf %sBps\n"',
			"LINE1:B#0000FF:'seeks    '",
			"GPRINT:B:MIN:'%4.2lf      '",
			"GPRINT:B:AVERAGE:'%4.2lf      '",
			"GPRINT:B:MAX:'%4.2lf      '",
			'GPRINT:B:LAST:"%4.2lf\n"',
			"LINE1:A#FF0000:'transfers'",
			"GPRINT:A:MIN:'%4.2lf      '",
			"GPRINT:A:AVERAGE:'%4.2lf      '",
			"GPRINT:A:MAX:'%4.2lf      '",
			"GPRINT:A:LAST:'%4.2lf'")))));

	$this->graphdefaults = array_merge($this->graphdefaults,
					   $this->shortcut["io"]["brief"]);

	$this->url2options($url);
    }
}
?>
