#
# This script was written by Michel Arboi <arboi@algoriel.fr> 
#
# GPL, blah blah blah
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10919);
 script_version ("$Revision: 1.11.2.1 $");

 name["english"] = "Check open ports";
 name["francais"] = "Vrifie les ports ouverts";
 
 script_name(english:name["english"],
            francais:name["francais"]);
 
 desc["english"] = "
This plugin checks if the port scanners did not kill a service.

Risk factor : None";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check if ports are still open";
 summary["francais"] = "Vrifie si les ports sont toujours ouverts";
 script_summary(english:summary["english"],
               francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 script_timeout(400);	# This plugin is slow

 script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
 family["english"] = "Misc.";
 family["francais"] = "Divers";
 script_family(english:family["english"], francais:family["francais"]);

 script_dependencie("find_service.nes");
 exit(0);
}

#

i = 0;
port = scanner_get_port(i);

while(port)
{
 if(!(port == 139))
 {
 state = get_kb_item(string("Ports/tcp/", port));
 if (state)
  {
   s = open_sock_tcp(port);
   if (! s)
    {
    report = string("This port was detected as being open by a port scanner but is now closed.\n",
	"This service might have been crashed by a port scanner or by some information gathering plugin\n");
		
    security_note(port:port, data:report);
    }
   else
    close(s);
  }
 }
 i = i + 1;
 port = scanner_get_port(i);
}
