/* $Id: system.h.in,v 1.4 2002/10/27 09:21:33 cegger Exp $
******************************************************************************

   GGI - Architecture specific things (autogenerated by configure)

******************************************************************************
*/

#ifndef _GGI_SYSTEM_H
#define _GGI_SYSTEM_H

#include <stdlib.h>

#include <sys/time.h>
#include <unistd.h>


#ifndef __BEGIN_DECLS
# ifdef __cplusplus
#  define __BEGIN_DECLS extern "C" {
#  define __END_DECLS }
# else
#  define __BEGIN_DECLS /* empty */
#  define __END_DECLS /* empty */
# endif
#endif

#ifdef __CYGWIN32__
# ifndef __CYGWIN__
#  define __CYGWIN__	1
# endif
#endif

#ifndef __WIN32__
# if defined(__CYGWIN__)  || \
    defined(__MINGW32__) || \
    defined(__MINGW__)   || \
    defined(_WIN32)
# define __WIN32__
# endif
#endif /* ! __WIN32__ */

#ifdef __WIN32__
# define EXPORTVAR	__declspec(dllexport)
# define IMPORTVAR	extern __declspec(dllimport)
#else
# define EXPORTVAR	/* empty */
# define IMPORTVAR	extern
#endif


typedef signed char		sint8;
typedef unsigned char		uint8;

typedef signed short		sint16;
typedef unsigned short		uint16;

typedef signed int		sint32;
typedef unsigned int		uint32;

typedef	signed int		ggi_sint;
typedef unsigned int		ggi_uint;

#define GG_HAVE_INT64

#ifdef GG_HAVE_INT64
typedef signed long long		sint64;
typedef unsigned long long		uint64;
#endif

#define GGI_BIG_ENDIAN		1

__BEGIN_DECLS
#define ggUSleep(val)	usleep((unsigned int)(val))
__END_DECLS

__BEGIN_DECLS
#define ggCurTime(tv)	gettimeofday((tv), NULL)
__END_DECLS



#endif /* _GGI_SYSTEM_H */
