/***************************************************************************
                          viewmanager.h -  description
                             -------------------
    begin                : Mon Jan 15 2001
    copyright            : (C) 2001 by Christoph Cullmann
    email                : cullmann@kde.org
 ***************************************************************************/

/***************************************************************************
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 ***************************************************************************/

#ifndef _KATE_VIEWMANAGER_INCLUDE_
#define _KATE_VIEWMANAGER_INCLUDE_

#include <qobject.h>
#include <kurl.h>

namespace Kate
{

/** An interface to the kate viewmanager.

 */
class ViewManager : public QObject
{
  friend class PrivateViewManager;

  Q_OBJECT

  public:
    ViewManager ( void *viewManager );
    virtual ~ViewManager ();
      
  public:
    /** Returns a pointer to the currently active Kate::View */
    class View *activeView();

    /** Opens the file pointed to by URL */
    void openURL (const KURL &url);     
 
  //invention of public signals, like in kparts/browserextension.h
  #undef signals
  #define signals public
  signals:
  #undef signals
  #define signals protected   

    void viewChanged ();
    
  private:
    class PrivateViewManager *d;
};

}

#endif
