<?php
/*
 * $Horde: imp/lib/Maintenance/Task/rename_sentmail_monthly.php,v 1.2.2.11 2003/01/16 22:29:10 jan Exp $
 *
 * Copyright 2001-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Maintenance module that renames the sent-mail folder.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.2.2.11 $
 * @since   IMP 2.3.7
 * @package horde.maintenance
 */
class Maintenance_Task_rename_sentmail_monthly extends Maintenance_Task {

    /**
     * Rename the old sent-mail folders.
     *
     * @access public
     *
     * @return boolean  Whether all sent-mail folders were renamed.
     */
    function doMaintenance()
    {
        global $imp, $prefs;

        $success = true;

        include_once IMP_BASE . '/lib/Folder.php';
        include_once IMP_BASE . '/lib/Identity/IMP.php';

        $identity = new Identity_IMP();
        $folder_list = $identity->getAllSentmailfolders();

        /* Get rid of duplicates */
        $folder_list = array_unique($folder_list);

        foreach ($folder_list as $sent_folder) {
            /* Display a message to the user and rename the folder.
               Only do this if sent-mail folder currently exists. */
            if (IMP_Folder::exists($imp['stream'], $sent_folder)) {
                $old_folder = Maintenance_Task_rename_sentmail_monthly::_renameSentmailMonthlyName($sent_folder);
                Horde::raiseMessage(sprintf(_("%s folder being renamed at the start of the month."), IMP::displayFolder($sent_folder)), HORDE_MESSAGE);
                if (IMP_Folder::exists($imp['stream'], $old_folder)) {
                    Horde::raiseMessage(sprintf(_("%s already exists. Your %s folder was not renamed."), IMP::displayFolder($old_folder), IMP::displayFolder($sent_folder)), HORDE_WARNING);
                    $success = false;
                } else {
                    if (IMP_Folder::rename($imp['stream'], $sent_folder, $old_folder, $prefs->getValue('subscribe'))) {
                        // Rebuild folder hash
                        IMP_Folder::exists($imp['stream'], $sent_folder, true);
                        if (!IMP_Folder::create($imp['stream'], $sent_folder, $prefs->getValue('subscribe'))) {
                            $success = false;
                        }
                    } else {
                        $success = false;
                    }
                }
            }

        }

        return $success;
    }

    /**
     * Return information for the maintenance function.
     *
     * @access public
     *
     * @return string  Description of what the operation is going to do during
     *                 this login.
     */
    function describeMaintenance()
    {
        global $imp;

        include_once IMP_BASE . '/lib/Identity/IMP.php';
        $identity = new Identity_IMP();
        $folder_list = $identity->getAllSentmailfolders();

        /* Get rid of duplicates */
        $folder_list = array_unique($folder_list);

        $new_folders = $old_folders = array();
        foreach ($folder_list as $folder) {
            if (!empty($folder)) {
                $old_folders[] = IMP::displayFolder($folder);
                $new_folders[] = IMP::displayFolder(Maintenance_Task_rename_sentmail_monthly::_renameSentmailMonthlyName($folder));
            }
        }

        return sprintf(_("The current folder(s) \"%s\" will be renamed to \"%s\"."), implode(', ', $old_folders), implode(', ', $new_folders));
    }

    /**
     * Determines the name the sent-mail folder will be renamed to.
     * <pre>
     * Folder name: sent-mail-month-year
     *   month = English:         3 letter abbreviation
     *           Other Languages: Month value (1-12)
     * The folder name needs to be in this specific format (as opposed to a
     *   user-defined one) to ensure that 'delete_sentmail_monthly' processing
     *   can accurately find all the old sent-mail folders.
     * </pre>
     *
     * @access private
     *
     * @param string $folder  The name of the sent-mail folder to rename.
     *
     * @return string  New sent-mail folder name.
     */
    function _renameSentmailMonthlyName($folder)
    {
        global $language, $prefs;

        $last_login = $prefs->getValue('last_login');
        if (!isset($last_login) || empty($last_login)) {
            $last_login = mktime(0, 0, 0, date('m') - 1, date('d'));
        }
        if (($language == 'en_US') || ($language == 'en_GB')) {
            return $folder . IMP::utf7Encode(strtolower(strftime("-%b-%Y", $last_login)));
        } else {
            return $folder . IMP::utf7Encode(strtolower(strftime("-%m-%Y", $last_login)));
        }
    }

}
?>
