'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ./modules/log/log.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "log" n 1.0.1 log "Logging facility"
.BS
.SH NAME
log \- Procedures to log messages of libraries and applications.
.SH "SYNOPSIS"
package require \fBTcl 8\fR
.sp
package require \fBlog ?1.0.1?\fR
.sp
\fB::log::levels\fR \fR
.sp
\fB::log::lv2longform\fR \fIlevel\fR\fR
.sp
\fB::log::lv2color\fR \fIlevel\fR\fR
.sp
\fB::log::lv2priority\fR \fIlevel\fR\fR
.sp
\fB::log::lv2cmd\fR \fIlevel\fR\fR
.sp
\fB::log::lv2channel\fR \fIlevel\fR\fR
.sp
\fB::log::lvCompare\fR \fIlevel1\fR \fIlevel2\fR\fR
.sp
\fB::log::lvSuppress\fR \fIlevel\fR {\fIsuppress\fR 1}\fR
.sp
\fB::log::lvSuppressLE\fR \fIlevel\fR {\fIsuppress\fR 1}\fR
.sp
\fB::log::lvIsSuppressed\fR \fIlevel\fR\fR
.sp
\fB::log::lvCmd\fR \fIlevel\fR \fIcmd\fR\fR
.sp
\fB::log::lvCmdForall\fR \fIcmd\fR\fR
.sp
\fB::log::lvChannel\fR \fIlevel\fR \fIchan\fR\fR
.sp
\fB::log::lvChannelForall\fR \fIchan\fR\fR
.sp
\fB::log::lvColor\fR \fIlevel\fR \fIcolor\fR\fR
.sp
\fB::log::lvColorForall\fR \fIcolor\fR\fR
.sp
\fB::log::log\fR \fIlevel\fR \fItext\fR\fR
.sp
\fB::log::logMsg\fR \fItext\fR\fR
.sp
\fB::log::logError\fR \fItext\fR\fR
.sp
\fB::log::Puts\fR \fIlevel\fR \fItext\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBlog\fR package provides commands that allow libraries and
applications to selectively log information about their internal
operation and state.
.PP
To use the package just execute
.PP
.nf
    package require log
    log::log notice "Some message"
.fi
.PP
As can be seen above, each message given to the log facility is
associated with a \fIlevel\fR determining the importance of the
message. The user can then select which levels to log, what commands
to use for the logging of each level and the channel to write the
message to. In the following example the logging of all message with
level \fBdebug\fR is deactivated.
.PP
.nf
    package require log
    log::lvSupress debug
    log::log debug "Unseen message" ; # No output
.fi
.PP
By default all messages associated with an error-level
(\fBemergency\fR, \fBalert\fR, \fBcritical\fR, and
\fBerror\fR) are written to \fBstderr\fR. Messages with any
other level are written to \fBstdout\fR. In the following example
the log module is reconfigured to write \fBdebug\fR messages to
\fBstderr\fR too.
.PP
.nf
    package require log
    log::lvChannel debug stderr
    log::log debug "Written to stderr"
.fi
.PP
Each message level is also associated with a command to use when
logging a message with that level. The behaviour above for example
relies on the fact that all message levels use by default the standard
command \fB::log::Puts\fR to log any message. In the following example
all messages of level \fBnotice\fR are given to the non-standard
command \fBtoText\fR for logging. This disables the channel setting
for such messages, assuming that \fBtoText\fR does not use it by
itself.
.PP
.nf
    package require log
    log::lvCmd notice toText
    log::log notice "Handled by \"toText\""
.fi
.PP
Another database maintained by this facility is a map from message
levels to colors. The information in this database has \fBno\fR
influence on the behaviour of the module. It is merely provided as a
convenience and in anticipation of the usage of this facility in
\fBtk\fR-based application which may want to colorize message
logs.
.SH "API"
.PP
The following commands are available:
.TP
\fB::log::levels\fR \fR
Returns the names of all known levels, in alphabetical order.
.TP
\fB::log::lv2longform\fR \fIlevel\fR\fR
Converts any unique abbreviation of a level name to the full level
name.
.TP
\fB::log::lv2color\fR \fIlevel\fR\fR
Converts any level name including unique abbreviations to the
corresponding color.
.TP
\fB::log::lv2priority\fR \fIlevel\fR\fR
Converts any level name including unique abbreviations to the
corresponding priority.
.TP
\fB::log::lv2cmd\fR \fIlevel\fR\fR
Converts any level name including unique abbreviations to the command
prefix used to write messages with that level.
.TP
\fB::log::lv2channel\fR \fIlevel\fR\fR
Converts any level name including unique abbreviations to the channel
used by \fB::log::Puts\fR to write messages with that level.
.TP
\fB::log::lvCompare\fR \fIlevel1\fR \fIlevel2\fR\fR
Compares two levels (including unique abbreviations) with respect to
their priority. This command can be used by the -command option of
lsort. The result is one of -1, 0 or 1 or an error. A result of -1
signals that level1 is of less priority than level2. 0 signals that
both levels have the same priority. 1 signals that level1 has higher
priority than level2.
.TP
\fB::log::lvSuppress\fR \fIlevel\fR {\fIsuppress\fR 1}\fR]
(Un)suppresses the output of messages having the specified
level. Unique abbreviations for the level are allowed here too.
.TP
\fB::log::lvSuppressLE\fR \fIlevel\fR {\fIsuppress\fR 1}\fR]
(Un)suppresses the output of messages having the specified level or
one of lesser priority. Unique abbreviations for the level are allowed
here too.
.TP
\fB::log::lvIsSuppressed\fR \fIlevel\fR\fR
Asks the package whether the specified level is currently
suppressed. Unique abbreviations of level names are allowed.
.TP
\fB::log::lvCmd\fR \fIlevel\fR \fIcmd\fR\fR
Defines for the specified level with which command to write the
messages having this level. Unique abbreviations of level names are
allowed. The command is actually a command prefix and this facility
will append 2 arguments before calling it, the level of the message
and the message itself, in this order.
.TP
\fB::log::lvCmdForall\fR \fIcmd\fR\fR
Defines for all known levels with which command to write the messages
having this level. The command is actually a command prefix and this
facility will append 2 arguments before calling it, the level of the
message and the message itself, in this order.
.TP
\fB::log::lvChannel\fR \fIlevel\fR \fIchan\fR\fR
Defines for the specified level into which channel \fB::log::Puts\fR
(the standard command) shall write the messages having this
level. Unique abbreviations of level names are allowed. The command is
actually a command prefix and this facility will append 2 arguments
before calling it, the level of the message and the message itself, in
this order.
.TP
\fB::log::lvChannelForall\fR \fIchan\fR\fR
Defines for all known levels with which which channel
\fB::log::Puts\fR (the standard command) shall write the messages
having this level. The command is actually a command prefix and this
facility will append 2 arguments before calling it, the level of the
message and the message itself, in this order.
.TP
\fB::log::lvColor\fR \fIlevel\fR \fIcolor\fR\fR
Defines for the specified level the color to return for it in a call
to \fB::log::lv2color\fR. Unique abbreviations of level names are
allowed.
.TP
\fB::log::lvColorForall\fR \fIcolor\fR\fR
Defines for all known levels the color to return for it in a call to
\fB::log::lv2color\fR. Unique abbreviations of level names are
allowed.
.TP
\fB::log::log\fR \fIlevel\fR \fItext\fR\fR
Log a message according to the specifications for commands, channels
and suppression. In other words: The command will do nothing if the
specified level is suppressed. If it is not suppressed the actual
logging is delegated to the specified command. If there is no command
specified for the level the message won't be logged. The standard
command \fB::log::Puts\fR will write the message to the channel
specified for the given level. If no channel is specified for the
level the message won't be logged. Unique abbreviations of level names
are allowed. Errors in the actual logging command are \fBnot\fR
caught, but propagated to the caller, as they may indicate
misconfigurations of the log facility or errors in the callers code
itself.
.TP
\fB::log::logMsg\fR \fItext\fR\fR
Convenience wrapper around \fB::log::log\fR.
Equivalent to \fB::log::log info text\fR.
.TP
\fB::log::logError\fR \fItext\fR\fR
Convenience wrapper around \fB::log::log\fR.
Equivalent to \fB::log::log error text\fR.
.TP
\fB::log::Puts\fR \fIlevel\fR \fItext\fR\fR
The standard log command, it writes messages and their levels to
user-specified channels. Assumes that the suppression checks were done
by the caller. Expects full level names, abbreviations are
\fBnot allowed\fR.
.SH "LEVELS"
The package currently defines the following log levels, the level of
highest importance listed first.
.IP \(bu
emergency
.IP \(bu
alert
.IP \(bu
critical
.IP \(bu
error
.IP \(bu
warning
.IP \(bu
notice
.IP \(bu
info
.IP \(bu
debug
.SH "KEYWORDS"
log, log level, message level, message
