'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ./modules/irc/irc.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "irc" n 0.2 irc "Low Level Tcl IRC Interface"
.BS
.SH NAME
irc \- Create IRC connection and interface.
.SH "SYNOPSIS"
package require \fBTcl\fR
.sp
package require \fBirc ?0.2?\fR
.sp
\fB::irc::connection\fR \fIhostname\fR\fR
.sp
\fB::irc::config\fR \fIkey\fR \fIvalue\fR\fR
.sp
\fInet\fR \fBregisterevent\fR \fIevent\fR \fIscript\fR\fR
.sp
\fInet\fR \fBconnect\fR\fR
.sp
\fInet\fR \fBuser\fR \fIusername\fR \fIlocalhostname\fR \fIuserinfo\fR\fR
.sp
\fInet\fR \fBnick\fR \fInick\fR\fR
.sp
\fInet\fR \fBping\fR\fR
.sp
\fInet\fR \fBjoin\fR \fIchannel\fR\fR
.sp
\fInet\fR \fBpart\fR \fIchannel\fR\fR
.sp
\fInet\fR \fBprivmsg\fR \fItarget\fR \fImessage\fR\fR
.sp
\fInet\fR \fBsend\fR \fItext\fR\fR
.sp
\fBwho\fR ?\fBaddress\fR?\fR
.sp
\fBaction\fR \fR
.sp
\fBtarget\fR ?\fIindex\fR?\fR
.sp
\fBmsg\fR \fR
.sp
.BE
.SH "DESCRIPTION"
This package provides low-level commands to deal with the IRC protocol
(Internet Relay Chat) for immediate and interactive multi-cast
communication.
.PP
.TP
\fB::irc::connection\fR \fIhostname\fR\fR
The command creates a new object to deal with an IRC connection.
Creating this IRC object does not automatically create the network
connection.  It returns a new irc namespace command which can be used
to interact with the new IRC connection.
.TP
\fB::irc::config\fR \fIkey\fR \fIvalue\fR\fR
Sets configuration \fIkey\fR to \fIvalue\fR.  Currently, the only
config key defined is the boolean flag \fBdebug\fR which, when
turned on, makes \fBirc\fR print more information about what is
going on.
.SH "Per-connection Commands"
.PP
In the following list of available connection methods \fInet\fR
represents a connection command as returned by
\fB::irc::connection\fR.
.TP
\fInet\fR \fBregisterevent\fR \fIevent\fR \fIscript\fR\fR
Registers a callback handler for the specific event.  Events available
are those described in the IRC RFC: 1459.  In addition, there are
several other events defined. \fBdefaultcommand\fR adds a command
that is called if no other callback is present.  \fBEOF\fR is
called if the connection signals an End of File condition.
\fIscript\fR is executed in the connection namespace, which can take
advantage of several commands (see \fBCallback Commands\fR
below) to aid in the parsing of data.
.TP
\fInet\fR \fBconnect\fR\fR
This causes the socket to be established.  \fB::irc::connection\fR
created the namespace and the commands to be used, but did not
actually open the socket. This is done here.
.TP
\fInet\fR \fBuser\fR \fIusername\fR \fIlocalhostname\fR \fIuserinfo\fR\fR
Sends USER command to server.  \fIusername\fR is the username you want
to appear.  \fIlocalhostname\fR is the name of your server, and
\fIuserinfo\fR is a short description of who you are.
.TP
\fInet\fR \fBnick\fR \fInick\fR\fR
NICK command.  \fInick\fR is the nickname you wish to use for the
particular connection.
.TP
\fInet\fR \fBping\fR\fR
PING the IRC server.
.TP
\fInet\fR \fBjoin\fR \fIchannel\fR\fR
\fIchannel\fR is the IRC channel to join.  IRC channels typically
begin with a hashmark ("#").
.TP
\fInet\fR \fBpart\fR \fIchannel\fR\fR
Makes the client leave \fIchannel\fR.
.TP
\fInet\fR \fBprivmsg\fR \fItarget\fR \fImessage\fR\fR
Sends \fImessage\fR to \fItarget\fR, which can be either a channel, or
another user, in which case their nick is used.
.TP
\fInet\fR \fBsend\fR \fItext\fR\fR
Sends \fItext\fR to the IRC server.
.SH "Callback Commands"
.PP
These commands can be used within callbacks
.TP
\fBwho\fR ?\fBaddress\fR?\fR
Returns the nick of the user who performed a command.  The optional
\fBaddress\fR keyword causes the command to return the user in the
format "username@address".
.TP
\fBaction\fR \fR
Returns the action perfomed, such as KICK, PRIVMSG, MODE, etc...
Normally not useful, as callbacks are bound to a particular event.
.TP
\fBtarget\fR ?\fIindex\fR?\fR
Returns the target of a particular command, such as the channel or
user to whom a PRIVMSG is sent.  In the case of multiple targets, the
optional \fIindex\fR argument may be used to specify which one to
return.  The default is 0.
.TP
\fBmsg\fR \fR
Returns the message portion of the command (the part after the :).
.SH "SEE ALSO"
rfc 1459
.SH "KEYWORDS"
irc, chat
