'\"
'\" Generated from ./modules/crc/crc32.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "crc32" n 1.0 crc "Cyclic Redundancy Check (crc32)"
.BS
.SH NAME
crc32 \- Perform a 32bit Cyclic Redundancy Check
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBcrc32 ?1.0?\fR
.sp
\fB::crc::crc32\fR ?-format \fIformat\fR? ?-seed \fIvalue\fR? ?-implementation \fIprocname\fR? \fImessage\fR\fR
.sp
\fB::crc::crc32\fR ?-format \fIformat\fR? ?-seed \fIvalue\fR? ?-implementation \fIprocname\fR? -filename \fIfile\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This package provides a Tcl-only implementation of the CRC-32
algorithm based upon information provided at
http://www.naaccr.org/standard/crc32/document.html
If the \fBTrf\fR package is available then the \fBcrc-zlib\fR
command is used to perform the calculation.
.SH "COMMANDS"
.TP
\fB::crc::crc32\fR ?-format \fIformat\fR? ?-seed \fIvalue\fR? ?-implementation \fIprocname\fR? \fImessage\fR\fR
.TP
\fB::crc::crc32\fR ?-format \fIformat\fR? ?-seed \fIvalue\fR? ?-implementation \fIprocname\fR? -filename \fIfile\fR\fR
The command takes string data or a file name and returns a checksum
value calculated using the CRC-32 algorithm. The result is formatted
using the \fIformat\fR(n) specifier provided or as an unsigned integer
(%u) by default.
.SH "OPTIONS"
.TP
-filename \fIname\fR
Return a checksum for the file contents instead of for parameter data.
.TP
-format \fIstring\fR
Return the checksum using an alternative format template.
.TP
-seed \fIvalue\fR
Select an alternative seed value for the CRC calculation. The default
is 0xffffffff. This can be useful for calculating the CRC for data
structures without first converting the whole structure into a
string. The CRC of the previous member can be used as the seed for
calculating the CRC of the next member.
.sp
Note that as the \fBTrf\fR command \fBcrc-zlib\fR cannot accept a
seed value, use of this option will force the use of the Tcl only
implementation.
.TP
-implementation \fIprocname\fR
This hook is provided to allow users to provide their own
implementation (perhaps a C compiled extension) or to explicitly
request use of the Tcl only implementation when \fBTrf\fR is
installed (by setting \fI-implementation crc::Crc32_tcl\fR. The
procedure specfied is called with two parameters. The first is the
data to be checksummed and the second is the seed value. A 32bit
integer is expected as the result.
.SH "EXAMPLES"
.PP
.nf
% crc::crc32 "Hello, World!"
3964322768
.fi
.PP
.nf
% crc::crc32 -format 0x%X "Hello, World!"
0xEC4AC3D0
.fi
.PP
.nf
% crc::crc32 -file crc32.tcl
483919716
.fi
.SH "SEE ALSO"
sum(n), cksum(n)
.SH "AUTHORS"
Pat Thoyts
.SH "KEYWORDS"
cksum, checksum, crc, crc32, cyclic redundancy check, data integrity, security

