'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ./modules/counter/counter.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "counter" n 2.0 counter "Counters and Histograms"
.BS
.SH NAME
counter \- Procedures for counters and histograms
.SH "SYNOPSIS"
package require \fBTcl 8\fR
.sp
package require \fBcounter ?2.0?\fR
.sp
\fB::counter::init\fR \fItag args\fR\fR
.sp
\fB::counter::count\fR \fItag\fR ?\fIdelta\fR? ?\fIinstance\fR?\fR
.sp
\fB::counter::start\fR \fItag instance\fR\fR
.sp
\fB::counter::stop\fR \fItag instance\fR\fR
.sp
\fB::counter::get\fR \fItag args\fR\fR
.sp
\fB::counter::exists\fR \fItag\fR\fR
.sp
\fB::counter::names\fR \fR
.sp
\fB::counter::histHtmlDisplay\fR \fItag args\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBcounter\fR package provides a counter facility and can
compute statistics and histograms over the collected data.
.TP
\fB::counter::init\fR \fItag args\fR\fR
This defines a counter with the name \fItag\fR.  The \fIargs\fR
determines the characteristics of the counter.  The \fIargs\fR are
.RS
.TP
\fB-group\fR \fIname\fR
Keep a grouped counter where the name of the histogram bucket is
passed into \fB::counter::count\fR.
.TP
\fB-hist\fR \fIbucketsize\fR
Accumulate the counter into histogram buckets of size
\fIbucketsize\fR.  For example, if the samples are millisecond time
values and \fIbucketsize\fR is 10, then each histogram bucket
represents time values of 0 to 10 msec, 10 to 20 msec, 20 to 30 msec,
and so on.
.TP
\fB-hist2x\fR \fIbucketsize\fR
Accumulate the statistic into histogram buckets.  The size of the
first bucket is \fIbucketsize\fR, each other bucket holds values 2
times the size of the previous bucket.  For example, if
\fIbucketsize\fR is 10, then each histogram bucket represents time
values of 0 to 10 msec, 10 to 20 msec, 20 to 40 msec, 40 to 80 msec,
and so on.
.TP
\fB-hist10x\fR \fIbucketsize\fR
Accumulate the statistic into histogram buckets.  The size of the
first bucket is \fIbucketsize\fR, each other bucket holds values 10
times the size of the previous bucket.  For example, if
\fIbucketsize\fR is 10, then each histogram bucket represents time
values of 0 to 10 msec, 10 to 100 msec, 100 to 1000 msec, and so on.
.TP
\fB-lastn\fR \fIN\fR
Save the last \fIN\fR values of the counter to maintain a "running
average" over the last \fIN\fR values.
.TP
\fB-timehist\fR \fIsecsPerMinute\fR
Keep a time-based histogram.  The counter is summed into a histogram
bucket based on the current time.  There are 60 per-minute buckets
that have a size determined by \fIsecsPerMinute\fR, which is normally
60, but for testing purposes can be less.  Every "hour" (i.e., 60
"minutes") the contents of the per-minute buckets are summed into the
next hourly bucket.  Every 24 "hours" the contents of the per-hour
buckets are summed into the next daily bucket.  The counter package
keeps all time-based histograms in sync, so the first
\fIsecsPerMinute\fR value seen by the package is used for all
subsequent time-based histograms.
.RE
.TP
\fB::counter::count\fR \fItag\fR ?\fIdelta\fR? ?\fIinstance\fR?\fR
Increment the counter identified by \fItag\fR.  The default increment
is 1, although you can increment by any value, integer or real, by
specifying \fIdelta\fR.  You must declare each counter with
\fB::counter::init\fR to define the characteristics of counter before
you start to use it.  If the counter type is \fB-group\fR, then the
counter identified by \fIinstance\fR is incremented.
.TP
\fB::counter::start\fR \fItag instance\fR\fR
Record the starting time of an interval.  The \fItag\fR is the name of
the counter defined as a \fB-hist\fR value-based histogram.  The
\fIinstance\fR is used to distinguish this interval from any other
intervals that might be overlapping this one.
.TP
\fB::counter::stop\fR \fItag instance\fR\fR
Record the ending time of an interval.  The delta time since the
corresponding \fB::counter::start\fR call for \fIinstance\fR is
recorded in the histogram identified by \fItag\fR.
.TP
\fB::counter::get\fR \fItag args\fR\fR
Return statistics about a counter identified by \fItag\fR.  The
\fIargs\fR determine what value to return:
.RS
.TP
\fB-total\fR
Return the total value of the counter.  This is the default if
\fIargs\fR is not specified.
.TP
\fB-totalVar\fR
Return the name of the total variable.  Useful for specifying with
-textvariable in a Tk widget.
.TP
\fB-N\fR
Return the number of samples accumulated into the counter.
.TP
\fB-avg\fR
Return the average of samples accumulated into the counter.
.TP
\fB-avgn\fR
Return the average over the last \fIN\fR samples taken.  The \fIN\fR
value is set in the \fB::counter::init\fR call.
.TP
\fB-hist\fR \fIbucket\fR
If \fIbucket\fR is specified, then the value in that bucket of the
histogram is returned.  Otherwise the complete histogram is returned
in array get format sorted by bucket.
.TP
\fB-histVar\fR
Return the name of the histogram array variable.
.TP
\fB-histHour\fR
Return the complete hourly histogram in array get format sorted by
bucket.
.TP
\fB-histHourVar\fR
Return the name of the hourly histogram array variable.
.TP
\fB-histDay\fR
Return the complete daily histogram in array get format sorted by
bucket.
.TP
\fB-histDayVar\fR
Return the name of the daily histogram array variable.
.TP
\fB-resetDate\fR
Return the clock seconds value recorded when the
counter was last reset.
.TP
\fB-all\fR
Return an array get of the array used to store the counter.  This
includes the total, the number of samples (N), and any type-specific
information.  This does not include the histogram array.
.RE
.TP
\fB::counter::exists\fR \fItag\fR\fR
Returns 1 if the counter is defined.
.TP
\fB::counter::names\fR \fR
Returns a list of all counters defined.
.TP
\fB::counter::histHtmlDisplay\fR \fItag args\fR\fR
Generate HTML to display a histogram for a counter.  The \fIargs\fR
control the format of the display.  They are:
.RS
.TP
\fB-title\fR \fIstring\fR
Label to display above bar chart
.TP
\fB-unit\fR \fIunit\fR
Specify \fBminutes\fR, \fBhours\fR, or \fBdays\fR for the
time-base histograms.  For value-based histograms, the \fIunit\fR is
used in the title.
.TP
\fB-images\fR \fIurl\fR
URL of /images directory.
.TP
\fB-gif\fR \fIfilename\fR
Image for normal histogram bars.  The \fIfilename\fR is relative to
the \fB-images\fR directory.
.TP
\fB-ongif\fR \fIfilename\fR
Image for the active histogram bar.  The \fIfilename\fR is relative to
the \fB-images\fR directory.
.TP
\fB-max\fR \fIN\fR
Maximum number of value-based buckets to display.
.TP
\fB-height\fR \fIN\fR
Pixel height of the highest bar.
.TP
\fB-width\fR \fIN\fR
Pixel width of each bar.
.TP
\fB-skip\fR \fIN\fR
Buckets to skip when labeling value-based histograms.
.TP
\fB-format\fR \fIstring\fR
Format used to display labels of buckets.
.TP
\fB-text\fR \fIboolean\fR
If 1, a text version of the histogram is dumped, otherwise a graphical
one is generated.
.RE
