#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
#
# This is a generic test which checks for FTP traversal vulns.
#

 desc = string("
The remote FTP server allows any anonymous user to browse the 
entire remote disk by issuing commands like :

	LIST ../../../../../
	LIST ..\\..\\..\\..\\..

Solution : Contact your vendor for a patch
Risk factor : High");



if(description)
{
 script_id(11112);
 script_cve_id("CVE-2001-0680");
 script_bugtraq_id(2618);
 script_version ("$Revision: 1.3.2.5 $");
 
 name["english"] = "Generic FTP traversal";
 
 script_name(english:name["english"]);
 script_description(english:desc);
 
 summary["english"] = "Attempts to get the listing of the remote root dir";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2002 Renaud Deraison");
 family["english"] = "FTP";
 family["francais"] = "FTP";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "ftp_anonymous.nasl");
 script_require_keys("ftp/login");
 script_exclude_keys("ftp/ncftpd", "ftp/msftpd");
 script_require_ports("Services/ftp", 21);
 exit(0);
}



function dir(loc)
{
 p = ftp_get_pasv_port(socket:soc);
 #display("p = ", p, "\n");
 if(!p)exit(0);
 soc2 = open_sock_tcp(p, transport:get_port_transport(port));
 if(!soc2)return(0);
 
 #display("Ok\n");
 ls = string("LIST ", loc,"\r\n");
 send(socket:soc, data:ls);
 r = recv_line(socket:soc, length:4096);
 #display(r, "\n");
 if(ereg(pattern:"^150 ", string:r))
 {
  result = recv(socket:soc2, length:4096, min:1);
  close(soc2);
  r = recv(socket:soc, length:4096, min:1);
  return(result);
 }
 return(0);
}


#
# The script code starts here
#

port = get_kb_item("Services/ftp");
if(!port)port = 21;
if(!get_port_state(port))exit(0);
soc = open_sock_tcp(port);
if(soc)
{
 if(ftp_log_in(socket:soc, user:"anonymous", pass:string("nessus@", get_host_name())))
 {
 listing1 = dir(loc:"/");
 listing2 = dir(loc:"../../../../../../../");
 listing3 = dir(loc:"..\\..\\..\\..\\..\\..\\..\\");
 
 # ncftpd workaround
 if(egrep(pattern:"permission denied", string:listing2, icase:TRUE))exit(0);
 if(egrep(pattern:"no such file or directory", string:listing3, icase:TRUE))exit(0);
 
 if(listing2 && !(listing1 == listing2))
	 {
	  report = string(desc, "\n\n", "The root dir of the remote server contains :\n", listing2);
	  security_hole(port:port, data:report);
	  exit(0);
	 } 
	  
  if(listing3 && !(listing1 == listing3))
  {
   report = string(desc, "\n\n", "The root dir of the remote server contains :\n", listing3);
	  security_hole(port:port, data:report);
	  exit(0);
  }	 
 }
  close(soc);
}

