#
# Copyright 2000 by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
#

if(description)
{
 script_id(10718); 
 script_cve_id("CAN-2001-0821");
 script_bugtraq_id(2889);
 script_version ("$Revision: 1.11.2.1 $");

 name["english"] = "DCShop exposes sensitive files";
 script_name(english:name["english"]);

 desc["english"] = "We detected a vulnerable version of the DCShop CGI. 
This version does not properly protect user and credit card information.
It is possible to access files that contain administrative passwords, 
current and pending transactions and credit card information (along with name, 
address, etc).

Solution: 
1. Rename following directories to something hard to guess:
 - Data
 - User_carts
 - Orders
 - Auth_data

2. Make these changes to dcshop.setup and dcshop_admin.setup. 

- In dcshop.setup, modify:

$datadir = '$cgidir/Data';
$cart_dir = '$cgidir/User_carts';
$order_dir = '$cgidir/Orders';

- In dcshop_admin.setup, modify:

$password_file_dir = '$path/Auth_data';

3. Rename dcshop.setup and dcshop_admin.setup to something difficult to guess.
For example, dcshop_4314312.setup and dcshop_admin_3124214.setup

4. Edit dcshop.cgi, dcshop_admin.cgi, and dcshop_checkout.cgi and modify the 
require statement for dcshop.setup and dcshop_admin.setup. That is:

- In dcshop.cgi, modify

require '$path/dcshop.setup';

so that it uses new setup file. For example,

require '$path/dcshop_4314312.setup';

- In dcshop_admin.cgi, modify

require '$path/dcshop.setup';
require '$path/dcshop_admin.setup';

so that it uses new setup file. For example,

require '$path/dcshop_4314312.setup';
require '$path/dcshop_admin_3124214.setup';

- In dcshop_checkout.cgi, modify

require '$path/dcshop.setup';

so that it uses new setup file. For example,

require '$path/dcshop_4314312.setup';

5. Save following file as index.html and upload it to your 
/cgi-bin/dcshop directory, thereby hiding directory listing. On 
NT servers, you may have to rename this file to default.htm.

http://www.dcscripts.com/FAQ/

This page show 'Internal Server Error' so it is not an error page...
it's just an index.html file to HIDE directories.

6. Replace your current files with above files

Risk factor : High

Additional information:
http://www.securiteam.com/unixfocus/5RP0N2K4KE.html
";

 script_description(english:desc["english"]);

 summary["english"] = "DCShop exposes sensitive files";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

dir[1] = "/cgi_bin/DCShop";
dir[2] = "/cgi-bin/dcshop";
dir[3] = "/cgi_bin/dcshop";
dir[4] = "/cgibin/DCShop";
dir[5] = "/cgibin/dcshop";
port = get_kb_item("Services/www");
if(!port) port = 80;

if(get_port_state(port))exit(0);

dir[6] = "/cgi-bin/shop";
dir[7] = "/cgi_bin/shop";
dir[8] = "/cgibin/shop";
dir[9] = "/shop/DCShop";
dir[10] = "/shop/dcshop";
dir[11] = "/shopping";
dir[12] = "/cgi-bin";
dir[13] = "/cgi_bin";
dir[14] = "/cgibin";
dir[15] = "/DCShop";
dir[16] = "/dcshop";
dir[17] = "/mall";
dir[18] = "/shop";
dir[19] = "/DC";
dir[20] = "/dc";
dir[21] = "/cgi-bin/Shop";
dir[22] = "/cgi-antonellistore/shop";
dir[23] = "/cgi-tecnovideosar";
dir[24] = "/sistemas/cgi-bin";
dir[25] = "/cgi/shop";
dir[26] = "/cgi-lordsofthefly/dccat";

program[0] = "/dcshop.pl";
program[1] = "/dcshop.cgi";

orders[0] = "Orders/orders.txt";
orders[1] = "orders/orders.txt";

Auth[0] = "Auth_data/auth_user_file.txt";
Auth[1] = "auth_data/auth_user_file.txt";

for (i = 1; dir[i] ; i = i + 1)
{
 for (j = 0; program[j] ; j = j + 1)
 {
  url = string(dir[i], program[j]);
  if (is_cgi_installed(item:url, port:port))
  {
  # display("Found dcshop at: ", url, "\n");
   for (k = 0; orders[k] ; k = k + 1)
   {
    orders_url = string(dir[i], orders[k]);
    port = is_cgi_installed(item:orders_url, port:port);
    if (port)
    {
     data = string("DCShop orders files located at: ", orders_url);
     security_hole(port:port, data:data);
    }
   }

   flag = 0;
   for (k = 0; Auth[k]; k = k + 1)
   {
    auth_url = string(dir[i], Auth[k]);
    port = is_cgi_installed(item:auth_url, port:port);
    if (port)
    {
     flag = 1;
     data = string("DCShop authentication file located at: ", auth_url);
     security_hole(port:port, data:data);
    }
   }
   if(flag)security_hole(port);
  }
 }
}

