/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
// written by Karsten Laux, June 1999  

#ifndef _SCREENSURFACE_H_
#define _SCREENSURFACE_H_

#include "surface.h"


namespace uta {

///
class ScreenSurface : public Surface
{
 public:
  ///
  ScreenSurface(int w, int h, int bitsPerPixel, bool fullscreen);
  ///
  ~ScreenSurface() {};

  ///
  void update();
  ///
  void update(const Rect& dest);
  ///
  void flip();
  ///
  bool doublebuffered() const { return doublebuf_; };
  ///
  bool fullscreen() const { return fullscreen_; };

#if SDL_VERSIONNUM(SDL_MAJOR_VERSION, SDL_MINOR_VERSION, SDL_PATCHLEVEL) >= \
    SDL_VERSIONNUM(1, 1, 6)
  ///
  static bool setGamma(float red, float green, float blue);
#endif

#if SDL_VERSIONNUM(SDL_MAJOR_VERSION, SDL_MINOR_VERSION, SDL_PATCHLEVEL) >= \
    SDL_VERSIONNUM(1, 1, 7)
  ///
  static bool setGammaRamp(Uint16 *red, Uint16 *green, Uint16 *blue);   
#endif

 protected:
  ///
  bool fullscreen_;
  ///
  bool doublebuf_;
};

}

#endif



