/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _COLOR_H
#define _COLOR_H

#include <iostream>
#include <SDL/SDL_version.h>

namespace uta {
///
class Color
{
 public:
#if SDL_VERSIONNUM(SDL_MAJOR_VERSION, SDL_MINOR_VERSION, SDL_PATCHLEVEL) >= \
    SDL_VERSIONNUM(1, 1, 5)
  ///
  Color() : r(0), g(0), b(0), a(255) {;};
  /** Construct from a triple/quadruple.
      note the inverted alpha since SDL-1.1.5
  */
  Color(unsigned char red, 
	unsigned char green,
	unsigned char blue,
	unsigned char alpha = 255) : r(red), g(green), b(blue),a(alpha) {;};
#else
  ///
  Color() : r(0), g(0), b(0), a(0) {;};
  /** Construct from a triple/quadruple.
      note the inverted alpha since SDL-1.1.5
  */
  Color(unsigned char red, 
	unsigned char green,
	unsigned char blue,
	unsigned char alpha = 0) : r(red), g(green), b(blue),a(alpha) {;};
#endif

  ///order high to low: ARGB
  Color(const long unsigned int& col_);
  
  ///
  ~Color() {;}

  ///this only compares colors (without alpha channel !)
  friend bool operator==(const Color &c1, const Color &c2)
  {
    return c1.r==c2.r && c1.g==c2.g && c1.b==c2.b;
  }
  ///
  friend ostream& operator<<(ostream& s, const Color& c);   

  ///
  unsigned char r;
  ///
  unsigned char g;
  ///
  unsigned char b;
  ///
  unsigned char a;

};

extern Color transparent; 
extern Color darkgrey;
extern Color darkgreen;
extern Color darkslateblue;
extern Color lightblue;
extern Color grey;
extern Color lightgrey;
extern Color seagreen;
extern Color snow ;
extern Color GhostWhite ;
extern Color WhiteSmoke ;
extern Color gainsboro ;
extern Color FloralWhite ;
extern Color OldLace ;
extern Color linen ;
extern Color AntiqueWhite ;
extern Color PapayaWhip ;
extern Color BlanchedAlmond ;
extern Color bisque ;
extern Color PeachPuff ;
extern Color NavajoWhite ;
extern Color moccasin ;
extern Color cornsilk ;
extern Color ivory ;
extern Color LemonChiffon ;
extern Color seashell ;
extern Color honeydew ;
extern Color MintCream ;
extern Color azure ;
extern Color AliceBlue ;
extern Color lavender ;
extern Color LavenderBlush ;
extern Color MistyRose ;
extern Color white ;
extern Color black ;
extern Color DarkSlateGray ;
extern Color DarkSlateGrey ;
extern Color DimGray ;
extern Color DimGrey ;
extern Color SlateGray ;
extern Color SlateGrey ;
extern Color LightSlateGray ;
extern Color LightSlateGrey ;
extern Color gray ;
extern Color grey ;
extern Color LightGrey ;
extern Color LightGray ;
extern Color MidnightBlue ;
extern Color navy ;
extern Color NavyBlue ;
extern Color CornflowerBlue ;
extern Color DarkSlateBlue ;
extern Color SlateBlue ;
extern Color MediumSlateBlue ;
extern Color LightSlateBlue ;
extern Color MediumBlue ;
extern Color RoyalBlue ;
extern Color blue ;
extern Color DodgerBlue ;
extern Color DeepSkyBlue ;
extern Color SkyBlue ;
extern Color LightSkyBlue ;
extern Color SteelBlue ;
extern Color LightSteelBlue ;
extern Color LightBlue ;
extern Color PowderBlue ;
extern Color PaleTurquoise ;
extern Color DarkTurquoise ;
extern Color MediumTurquoise ;
extern Color turquoise ;
extern Color cyan ;
extern Color LightCyan ;
extern Color CadetBlue ;
extern Color MediumAquamarine ;
extern Color aquamarine ;
extern Color DarkGreen ;
extern Color DarkOliveGreen ;
extern Color DarkSeaGreen ;
extern Color SeaGreen ;
extern Color MediumSeaGreen ;
extern Color LightSeaGreen ;
extern Color PaleGreen ;
extern Color SpringGreen ;
extern Color LawnGreen ;
extern Color green ;
extern Color chartreuse ;
extern Color MediumSpringGreen ;
extern Color GreenYellow ;
extern Color LimeGreen ;
extern Color YellowGreen ;
extern Color ForestGreen ;
extern Color OliveDrab ;
extern Color DarkKhaki ;
extern Color khaki ;
extern Color PaleGoldenrod ;
extern Color LightGoldenrodYellow ;
extern Color LightYellow ;
extern Color yellow ;
extern Color 	gold ;
extern Color LightGoldenrod ;
extern Color goldenrod ;
extern Color DarkGoldenrod ;
extern Color RosyBrown ;
extern Color IndianRed ;
extern Color SaddleBrown ;
extern Color sienna ;
extern Color peru ;
extern Color burlywood ;
extern Color beige ;
extern Color wheat ;
extern Color SandyBrown ;
extern Color tan ;
extern Color chocolate ;
extern Color firebrick ;
extern Color brown ;
extern Color DarkSalmon ;
extern Color salmon ;
extern Color LightSalmon ;
extern Color orange ;
extern Color DarkOrange ;
extern Color coral ;
extern Color LightCoral ;
extern Color tomato ;
extern Color OrangeRed ;
extern Color red ;
extern Color HotPink ;
extern Color DeepPink ;
extern Color pink ;
extern Color LightPink ;
extern Color PaleVioletRed ;
extern Color maroon ;
extern Color MediumVioletRed ;
extern Color VioletRed ;
extern Color magenta ;
extern Color violet ;
extern Color plum ;
extern Color orchid ;
extern Color MediumOrchid ;
extern Color DarkOrchid ;
extern Color DarkViolet ;
extern Color BlueViolet ;
extern Color purple ;
extern Color MediumPurple ;
extern Color thistle ;
extern Color snow1 ;
extern Color snow2 ;
extern Color snow3 ;
extern Color snow4 ;
extern Color seashell1 ;
extern Color seashell2 ;
extern Color seashell3 ;
extern Color seashell4 ;
extern Color AntiqueWhite1 ;
extern Color AntiqueWhite2 ;
extern Color AntiqueWhite3 ;
extern Color AntiqueWhite4 ;
extern Color bisque1 ;
extern Color bisque2 ;
extern Color bisque3 ;
extern Color bisque4 ;
extern Color PeachPuff1 ;
extern Color PeachPuff2 ;
extern Color PeachPuff3 ;
extern Color PeachPuff4 ;
extern Color NavajoWhite1 ;
extern Color NavajoWhite2 ;
extern Color NavajoWhite3 ;
extern Color NavajoWhite4 ;
extern Color LemonChiffon1 ;
extern Color LemonChiffon2 ;
extern Color LemonChiffon3 ;
extern Color LemonChiffon4 ;
extern Color cornsilk1 ;
extern Color cornsilk2 ;
extern Color cornsilk3 ;
extern Color cornsilk4 ;
extern Color ivory1 ;
extern Color ivory2 ;
extern Color ivory3 ;
extern Color ivory4 ;
extern Color honeydew1 ;
extern Color honeydew2 ;
extern Color honeydew3 ;
extern Color honeydew4 ;
extern Color LavenderBlush1 ;
extern Color LavenderBlush2 ;
extern Color LavenderBlush3 ;
extern Color LavenderBlush4 ;
extern Color MistyRose1 ;
extern Color MistyRose2 ;
extern Color MistyRose3 ;
extern Color MistyRose4 ;
extern Color azure1 ;
extern Color azure2 ;
extern Color azure3 ;
extern Color azure4 ;
extern Color SlateBlue1 ;
extern Color SlateBlue2 ;
extern Color SlateBlue3 ;
extern Color SlateBlue4 ;
extern Color RoyalBlue1 ;
extern Color RoyalBlue2 ;
extern Color RoyalBlue3 ;
extern Color RoyalBlue4 ;
extern Color blue1 ;
extern Color blue2 ;
extern Color blue3 ;
extern Color blue4 ;
extern Color DodgerBlue1 ;
extern Color DodgerBlue2 ;
extern Color DodgerBlue3 ;
extern Color DodgerBlue4 ;
extern Color SteelBlue1 ;
extern Color SteelBlue2 ;
extern Color SteelBlue3 ;
extern Color SteelBlue4 ;
extern Color DeepSkyBlue1 ;
extern Color DeepSkyBlue2 ;
extern Color DeepSkyBlue3 ;
extern Color DeepSkyBlue4 ;
extern Color SkyBlue1 ;
extern Color SkyBlue2 ;
extern Color SkyBlue3 ;
extern Color SkyBlue4 ;
extern Color LightSkyBlue1 ;
extern Color LightSkyBlue2 ;
extern Color LightSkyBlue3 ;
extern Color LightSkyBlue4 ;
extern Color SlateGray1 ;
extern Color SlateGray2 ;
extern Color SlateGray3 ;
extern Color SlateGray4 ;
extern Color LightSteelBlue1 ;
extern Color LightSteelBlue2 ;
extern Color LightSteelBlue3 ;
extern Color LightSteelBlue4 ;
extern Color LightBlue1 ;
extern Color LightBlue2 ;
extern Color LightBlue3 ;
extern Color LightBlue4 ;
extern Color LightCyan1 ;
extern Color LightCyan2 ;
extern Color LightCyan3 ;
extern Color LightCyan4 ;
extern Color PaleTurquoise1 ;
extern Color PaleTurquoise2 ;
extern Color PaleTurquoise3 ;
extern Color PaleTurquoise4 ;
extern Color CadetBlue1 ;
extern Color CadetBlue2 ;
extern Color CadetBlue3 ;
extern Color CadetBlue4 ;
extern Color turquoise1 ;
extern Color turquoise2 ;
extern Color turquoise3 ;
extern Color turquoise4 ;
extern Color cyan1 ;
extern Color cyan2 ;
extern Color cyan3 ;
extern Color cyan4 ;
extern Color DarkSlateGray1 ;
extern Color DarkSlateGray2 ;
extern Color DarkSlateGray3 ;
extern Color DarkSlateGray4 ;
extern Color aquamarine1 ;
extern Color aquamarine2 ;
extern Color aquamarine3 ;
extern Color aquamarine4 ;
extern Color DarkSeaGreen1 ;
extern Color DarkSeaGreen2 ;
extern Color DarkSeaGreen3 ;
extern Color DarkSeaGreen4 ;
extern Color SeaGreen1 ;
extern Color SeaGreen2 ;
extern Color SeaGreen3 ;
extern Color SeaGreen4 ;
extern Color PaleGreen1 ;
extern Color PaleGreen2 ;
extern Color PaleGreen3 ;
extern Color PaleGreen4 ;
extern Color SpringGreen1 ;
extern Color SpringGreen2 ;
extern Color SpringGreen3 ;
extern Color SpringGreen4 ;
extern Color green1 ;
extern Color green2 ;
extern Color green3 ;
extern Color green4 ;
extern Color chartreuse1 ;
extern Color chartreuse2 ;
extern Color chartreuse3 ;
extern Color chartreuse4 ;
extern Color OliveDrab1 ;
extern Color OliveDrab2 ;
extern Color OliveDrab3 ;
extern Color OliveDrab4 ;
extern Color DarkOliveGreen1 ;
extern Color DarkOliveGreen2 ;
extern Color DarkOliveGreen3 ;
extern Color DarkOliveGreen4 ;
extern Color khaki1 ;
extern Color khaki2 ;
extern Color khaki3 ;
extern Color khaki4 ;
extern Color LightGoldenrod1 ;
extern Color LightGoldenrod2 ;
extern Color LightGoldenrod3 ;
extern Color LightGoldenrod4 ;
extern Color LightYellow1 ;
extern Color LightYellow2 ;
extern Color LightYellow3 ;
extern Color LightYellow4 ;
extern Color yellow1 ;
extern Color yellow2 ;
extern Color yellow3 ;
extern Color yellow4 ;
extern Color gold1 ;
extern Color gold2 ;
extern Color gold3 ;
extern Color gold4 ;
extern Color goldenrod1 ;
extern Color goldenrod2 ;
extern Color goldenrod3 ;
extern Color goldenrod4 ;
extern Color DarkGoldenrod1 ;
extern Color DarkGoldenrod2 ;
extern Color DarkGoldenrod3 ;
extern Color DarkGoldenrod4 ;
extern Color RosyBrown1 ;
extern Color RosyBrown2 ;
extern Color RosyBrown3 ;
extern Color RosyBrown4 ;
extern Color IndianRed1 ;
extern Color IndianRed2 ;
extern Color IndianRed3 ;
extern Color IndianRed4 ;
extern Color sienna1 ;
extern Color sienna2 ;
extern Color sienna3 ;
extern Color sienna4 ;
extern Color burlywood1 ;
extern Color burlywood2 ;
extern Color burlywood3 ;
extern Color burlywood4 ;
extern Color wheat1 ;
extern Color wheat2 ;
extern Color wheat3 ;
extern Color wheat4 ;
extern Color tan1 ;
extern Color tan2 ;
extern Color tan3 ;
extern Color tan4 ;
extern Color chocolate1 ;
extern Color chocolate2 ;
extern Color chocolate3 ;
extern Color chocolate4 ;
extern Color firebrick1 ;
extern Color firebrick2 ;
extern Color firebrick3 ;
extern Color firebrick4 ;
extern Color brown1 ;
extern Color brown2 ;
extern Color brown3 ;
extern Color brown4 ;
extern Color salmon1 ;
extern Color salmon2 ;
extern Color salmon3 ;
extern Color salmon4 ;
extern Color LightSalmon1 ;
extern Color LightSalmon2 ;
extern Color LightSalmon3 ;
extern Color LightSalmon4 ;
extern Color orange1 ;
extern Color orange2 ;
extern Color orange3 ;
extern Color orange4 ;
extern Color DarkOrange1 ;
extern Color DarkOrange2 ;
extern Color DarkOrange3 ;
extern Color DarkOrange4 ;
extern Color coral1 ;
extern Color coral2 ;
extern Color coral3 ;
extern Color coral4 ;
extern Color tomato1 ;
extern Color tomato2 ;
extern Color tomato3 ;
extern Color tomato4 ;
extern Color OrangeRed1 ;
extern Color OrangeRed2 ;
extern Color OrangeRed3 ;
extern Color OrangeRed4 ;
extern Color red1 ;
extern Color red2 ;
extern Color red3 ;
extern Color red4 ;
extern Color DeepPink1 ;
extern Color DeepPink2 ;
extern Color DeepPink3 ;
extern Color DeepPink4 ;
extern Color HotPink1 ;
extern Color HotPink2 ;
extern Color HotPink3 ;
extern Color HotPink4 ;
extern Color pink1 ;
extern Color pink2 ;
extern Color pink3 ;
extern Color pink4 ;
extern Color LightPink1 ;
extern Color LightPink2 ;
extern Color LightPink3 ;
extern Color LightPink4 ;
extern Color PaleVioletRed1 ;
extern Color PaleVioletRed2 ;
extern Color PaleVioletRed3 ;
extern Color PaleVioletRed4 ;
extern Color maroon1 ;
extern Color maroon2 ;
extern Color maroon3 ;
extern Color maroon4 ;
extern Color VioletRed1 ;
extern Color VioletRed2 ;
extern Color VioletRed3 ;
extern Color VioletRed4 ;
extern Color magenta1 ;
extern Color magenta2 ;
extern Color magenta3 ;
extern Color magenta4 ;
extern Color orchid1 ;
extern Color orchid2 ;
extern Color orchid3 ;
extern Color orchid4 ;
extern Color plum1 ;
extern Color plum2 ;
extern Color plum3 ;
extern Color plum4 ;
extern Color MediumOrchid1 ;
extern Color MediumOrchid2 ;
extern Color MediumOrchid3 ;
extern Color MediumOrchid4 ;
extern Color DarkOrchid1 ;
extern Color DarkOrchid2 ;
extern Color DarkOrchid3 ;
extern Color DarkOrchid4 ;
extern Color purple1 ;
extern Color purple2 ;
extern Color purple3 ;
extern Color purple4 ;
extern Color MediumPurple1 ;
extern Color MediumPurple2 ;
extern Color MediumPurple3 ;
extern Color MediumPurple4 ;
extern Color thistle1 ;
extern Color thistle2 ;
extern Color thistle3 ;
extern Color thistle4 ;
extern Color gray0 ;
extern Color grey0 ;
extern Color gray1 ;
extern Color grey1 ;
extern Color gray2 ;
extern Color grey2 ;
extern Color gray3 ;
extern Color grey3 ;
extern Color 	gray4 ;
extern Color 	grey4 ;
extern Color 	gray5 ;
extern Color 	grey5 ;
extern Color 	gray6 ;
extern Color 	grey6 ;
extern Color 	gray7 ;
extern Color 	grey7 ;
extern Color 	gray8 ;
extern Color 	grey8 ;
extern Color 	gray9 ;
extern Color 	grey9 ;
extern Color 	gray10 ;
extern Color 	grey10 ;
extern Color 	gray11 ;
extern Color 	grey11 ;
extern Color 	gray12 ;
extern Color 	grey12 ;
extern Color 	gray13 ;
extern Color 	grey13 ;
extern Color 	gray14 ;
extern Color 	grey14 ;
extern Color 	gray15 ;
extern Color 	grey15 ;
extern Color 	gray16 ;
extern Color 	grey16 ;
extern Color 	gray17 ;
extern Color 	grey17 ;
extern Color 	gray18 ;
extern Color 	grey18 ;
extern Color 	gray19 ;
extern Color 	grey19 ;
extern Color 	gray20 ;
extern Color 	grey20 ;
extern Color 	gray21 ;
extern Color 	grey21 ;
extern Color 	gray22 ;
extern Color 	grey22 ;
extern Color 	gray23 ;
extern Color 	grey23 ;
extern Color 	gray24 ;
extern Color 	grey24 ;
extern Color 	gray25 ;
extern Color 	grey25 ;
extern Color 	gray26 ;
extern Color 	grey26 ;
extern Color 	gray27 ;
extern Color 	grey27 ;
extern Color 	gray28 ;
extern Color 	grey28 ;
extern Color 	gray29 ;
extern Color 	grey29 ;
extern Color 	gray30 ;
extern Color 	grey30 ;
extern Color 	gray31 ;
extern Color 	grey31 ;
extern Color 	gray32 ;
extern Color 	grey32 ;
extern Color 	gray33 ;
extern Color 	grey33 ;
extern Color 	gray34 ;
extern Color 	grey34 ;
extern Color 	gray35 ;
extern Color 	grey35 ;
extern Color 	gray36 ;
extern Color 	grey36 ;
extern Color 	gray37 ;
extern Color 	grey37 ;
extern Color 	gray38 ;
extern Color 	grey38 ;
extern Color 	gray39 ;
extern Color 	grey39 ;
extern Color 	gray40 ;
extern Color 	grey40 ;
extern Color 	gray41 ;
extern Color 	grey41 ;
extern Color 	gray42 ;
extern Color 	grey42 ;
extern Color 	gray43 ;
extern Color 	grey43 ;
extern Color 	gray44 ;
extern Color 	grey44 ;
extern Color 	gray45 ;
extern Color 	grey45 ;
extern Color 	gray46 ;
extern Color 	grey46 ;
extern Color 	gray47 ;
extern Color 	grey47 ;
extern Color 	gray48 ;
extern Color 	grey48 ;
extern Color 	gray49 ;
extern Color 	grey49 ;
extern Color 	gray50 ;
extern Color 	grey50 ;
extern Color 	gray51 ;
extern Color 	grey51 ;
extern Color 	gray52 ;
extern Color 	grey52 ;
extern Color 	gray53 ;
extern Color 	grey53 ;
extern Color 	gray54 ;
extern Color 	grey54 ;
extern Color 	gray55 ;
extern Color 	grey55 ;
extern Color 	gray56 ;
extern Color 	grey56 ;
extern Color 	gray57 ;
extern Color 	grey57 ;
extern Color 	gray58 ;
extern Color 	grey58 ;
extern Color 	gray59 ;
extern Color 	grey59 ;
extern Color 	gray60 ;
extern Color 	grey60 ;
extern Color 	gray61 ;
extern Color 	grey61 ;
extern Color 	gray62 ;
extern Color 	grey62 ;
extern Color 	gray63 ;
extern Color 	grey63 ;
extern Color 	gray64 ;
extern Color 	grey64 ;
extern Color 	gray65 ;
extern Color 	grey65 ;
extern Color 	gray66 ;
extern Color 	grey66 ;
extern Color 	gray67 ;
extern Color 	grey67 ;
extern Color 	gray68 ;
extern Color 	grey68 ;
extern Color 	gray69 ;
extern Color 	grey69 ;
extern Color 	gray70 ;
extern Color 	grey70 ;
extern Color 	gray71 ;
extern Color 	grey71 ;
extern Color 	gray72 ;
extern Color 	grey72 ;
extern Color 	gray73 ;
extern Color 	grey73 ;
extern Color 	gray74 ;
extern Color 	grey74 ;
extern Color 	gray75 ;
extern Color 	grey75 ;
extern Color 	gray76 ;
extern Color 	grey76 ;
extern Color 	gray77 ;
extern Color 	grey77 ;
extern Color 	gray78 ;
extern Color 	grey78 ;
extern Color 	gray79 ;
extern Color 	grey79 ;
extern Color 	gray80 ;
extern Color 	grey80 ;
extern Color 	gray81 ;
extern Color 	grey81 ;
extern Color 	gray82 ;
extern Color 	grey82 ;
extern Color 	gray83 ;
extern Color 	grey83 ;
extern Color 	gray84 ;
extern Color 	grey84 ;
extern Color 	gray85 ;
extern Color 	grey85 ;
extern Color 	gray86 ;
extern Color 	grey86 ;
extern Color 	gray87 ;
extern Color 	grey87 ;
extern Color 	gray88 ;
extern Color 	grey88 ;
extern Color 	gray89 ;
extern Color 	grey89 ;
extern Color 	gray90 ;
extern Color 	grey90 ;
extern Color 	gray91 ;
extern Color 	grey91 ;
extern Color 	gray92 ;
extern Color 	grey92 ;
extern Color 	gray93 ;
extern Color 	grey93 ;
extern Color 	gray94 ;
extern Color 	grey94 ;
extern Color 	gray95 ;
extern Color 	grey95 ;
extern Color 	gray96 ;
extern Color 	grey96 ;
extern Color 	gray97 ;
extern Color 	grey97 ;
extern Color 	gray98 ;
extern Color 	grey98 ;
extern Color 	gray99 ;
extern Color 	grey99 ;
extern Color 	gray100 ;
extern Color 	grey100 ;
extern Color DarkGrey ;
extern Color DarkGray ;
extern Color DarkBlue ;
extern Color DarkCyan ;
extern Color DarkMagenta ;
extern Color DarkRed ;
extern Color LightGreen ;
extern Color LightGreen ;

}

#endif // !_COLOR_H
