<?php
// $Horde: kronolith/lib/MonthView.php,v 1.14 2001/09/18 16:03:52 jan Exp $

require_once './lib/Month.php';

/**
 * The Kronolith_Month:: class provides an API for viewing months.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.14 $
 * @since   Kronolith 0.1
 * @package kronolith
 */
class Kronolith_MonthView {
	
	var $month;
	
	// }}}
	
	
	function Kronolith_MonthView ($month='', $day='', $year='') {
		$this->month = new Kronolith_Month($month, $day, $year);
	}
	// }}}
	
	function html ($template_path = './templates') {
		$cal = $this->month->cal;
		
		include $template_path . '/month_head.inc';
		for ($i = 0; $i < count($cal); $i++) {
			include $template_path . '/month_begin_week.inc';
			for ($j = 0; $j < 7; $j++) {
				if (empty($cal[$i][$j]))
					$bg = 'cccccc';
				else if (mktime(0,0,0,$this->month->month, $cal[$i][$j], $this->month->year) == mktime(0,0,0))
					$bg = 'ffffcc';
				else 
					$bg = 'eeeeee';
				include $template_path . '/month_day.inc';
			}
			include $template_path . '/month_end_week.inc';
		}
		include $template_path . '/month_foot.inc';
	}
	// }}}
  
	function link ($offset=0) {
		return Horde::applicationUrl('mini_month.php?month=' . $this->month->getTime('n', $offset) . '&mday=' . $this->month->getTime('j', $offset) . '&year=' . $this->month->getTime('Y', $offset));
	}
	// }}}
	
}

?>
