# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 2106 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/_add_hash_methods.al)"
# -------------------------------------

# added by Dominique Dumont (22.i.02)
sub _add_hash_methods {
  my ($class,$methods, $field) = @_ ;

  $methods->{$field . "_keys"} =
    sub {
      my ($self) = @_;
      keys %{$self->{$field}};
    };

  $methods->{$field . "_values"} =
    sub {
      my ($self) = @_;
      values %{$self->{$field}};
    };

  $methods->{$field . "_exists"} =
    sub {
      my ($self) = shift;
      my ($key) = @_;
      return
        exists $self->{$field} && exists $self->{$field}->{$key};
    };

  $methods->{$field . "_tally"} =
    sub {
      my ($self, @list) = @_;
      defined $self->{$field} or $self->{$field} = {};
      map { ++$self->{$field}->{$_} } @list;
    };

  $methods->{$field . "_delete"} =
    sub {
      my ($self, @keys) = @_;
      delete @{$self->{$field}}{@keys};
    };
}

# end of Class::MethodMaker::_add_hash_methods
1;
