#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10287);
 script_version ("$Revision: 1.20.2.1 $");
 name["english"] = "Traceroute";
 name["francais"] = "Traceroute";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "Makes a traceroute to the remote host.

Risk factor : Low";

 desc["francais"] = "Fait un traceroute sur l'hote distant";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "traceroute";
 summary["francais"] = "traceroute";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Misc.";
 family["francais"] = "Divers";
 script_family(english:family["english"], francais:family["francais"]);
 exit(0);
}

#
# The script code starts here
#

finished = 0;
ttl = 1;
src = this_host();
dst = get_host_ip();
error = 0;

str_ip = string(dst);
z = strstr(str_ip, ".");

#
# pcap filtter
#

if(islocalhost())
{
# don't show route when no request was attempted
#dub report = string("For your information, here is the traceroute to ", dst, " : \n", dst);
#dub security_note(port:0, protocol:"udp", data:report);
 exit(0);
}
report = string("For your information, here is the traceroute to ", dst, " : \n");
filter = string("dst host ", src, " and icmp and ((icmp[0]==3) or (icmp[0]==11)) ",
		"and (icmp[24]==", str_ip-z,") ");
		
z[0]=" ";
t = strstr(z, ".");
filter = filter + string("and (icmp[25]==",z-t,") ");
t[0]=" ";
z = strstr(t, ".");
filter = filter + string("and (icmp[26]==", t-z, ") ");
z[0]=" ";
filter = filter + string("and (icmp[27]==", z, ")");


d = get_host_ip();
prev = string("");

#
# the traceroute itself
#
function make_pkt(ttl, proto)
{
  #proto = proto % 5;
  #display("make_pkt(", ttl, ", ", proto, ")\n");
  ip_id = rand();
  src = this_host();
  # Prefer UDP
  if (proto == 0)
  {
    ip = forge_ip_packet(ip_v : 4, ip_hl:5, ip_tos:0, ip_id:ip_id,
			ip_len:28, ip_off:0, ip_p:IPPROTO_UDP, 
			ip_src:src, ip_ttl:ttl);
    p = forge_udp_packet(ip:ip, uh_sport:1025, uh_dport:32768, uh_len:8);
    return (p);
  }
  # Then ICMP
  if (proto == 1)
  {
    ip = forge_ip_packet(ip_v : 4, ip_hl:5, ip_tos:0, ip_id:ip_id,
			ip_len:20, ip_off:0, ip_p:IPPROTO_ICMP, 
			ip_src:src, ip_ttl:ttl);
    p = forge_icmp_packet(ip:ip, icmp_type:8, icmp_code:0,
			icmp_seq: ttl, icmp_id:ttl);
    return (p);
  }
  # Then TCP
    ip = forge_ip_packet(ip_v : 4, ip_hl:5, ip_tos:0, ip_id:ip_id,
			ip_len:20, ip_off:0, ip_p:IPPROTO_TCP, 
			ip_src:src, ip_ttl:ttl);
  if (proto == 2)
  {
    p = forge_tcp_packet(ip:ip, :8, th_sport:1025, th_dport: 23, 
			th_flags: TH_SYN, th_seq: ttl,
			th_ack: 0, th_x2    : 0,th_off   : 5,
			th_win   : 2048, th_urp   : 0);
    return (p);
  }
  if (proto == 3)
  {
    p = forge_tcp_packet(ip:ip, :8, th_sport:1025, th_dport: 23, 
			th_flags: TH_ACK, th_seq: ttl,
			th_ack: rand(), th_x2    : 0,th_off   : 5,
			th_win   : 2048, th_urp   : 0);
    return(p);
  }
    p = forge_tcp_packet(ip:ip, :8, th_sport:1025, th_dport: 23, 
			th_flags: TH_FIN, th_seq: ttl,
			th_ack: rand(), th_x2    : 0,th_off   : 5,
			th_win   : 2048, th_urp   : 0);
    return (p);
}

proto=0;	# Prefer UDP
while(!finished)
{
 # "2" makes the test quicker. "5" is the slower & safer version
 for (i=0; i < 2; i=i+1)
 {
  err=1;
  p = make_pkt(ttl: ttl, proto: proto);
  rep = send_packet(p, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
  if(rep)
  {
   psrc = get_ip_element(ip:rep, element:"ip_src");
   report = report + string(psrc, "\n");	
   d = psrc - d;
   if(!d)finished = 1;
   d = get_host_ip();
   error = 0; err=0;
   i=666;
  }
  else
  {
   proto=proto+1; proto=proto%4;
  }
 }
 if(err)
 {
  if (!error) report = report + string("?\n");
  error = error+1;
 }
 ttl = ttl+1;

 #
 # If we get more than 3 errors one after another, we stop
 #
 if(error > 3)finished = 1;
 
 #
 # Should not get here
 #
 if(ttl > 50)finished = 1;
}
 		   
#
# show if at least one route was obtained.
#
# MA 2002-08-15: I split the expression "ttl=ttl-(1+error)" because of 
# what looked like a NASL bug
y = 1 + error;
ttl = ttl - y;
if (ttl > 0)
security_note(port:0, protocol:"udp", data:report);
