
# This script is (C) Noam Rathaus

if (description)
{
 script_id(10779);
 script_version ("$Revision: 1.7.2.1 $");
 script_name(english:"CGIEmail's CGICso (Send CSO via CGI) Command Execution Vulnerability");
 desc["english"] = "
The remote host seems to be vulnerable to a security problem in 
CGIEmail (cgicso).  The vulnerability is caused by inadequate processing 
of queries by CGIEmail's cgicso and results in a command execution 
vulnerability.

Impact:
The server can be compromised by executing commands as the web server's 
running user (usually 'nobody').

Solution:
Modify cgicso.h to contain a strict setting of your finger host.

Example:
Define the following in cgicso.h:
#define CGI_CSO_HARDCODE
#define CGI_CSO_FINGERHOST 'localhost'

Risk factor : High

Additional information:
http://www.securiteam.com/exploits/5TP0W005FE.html";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if a remote host is vulnerable to the cgicso vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses", francais:"Abus de CGI");
 script_copyright(english:"This script is Copyright (C) 2001 SecurITeam");
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");

port = get_kb_item("Services/www");
if (!port) port = 80;

dir[0] = "/bin/";
dir[1] = "/cgi-local/cgiemail-1.4/";
dir[2] = "/cgi-local/";
dir[3] = "/cgi/cgiemail/";
dir[4] = "/html/cgi-bin/";
dir[5] = "/cgi-local/cgiemail-1.6/";


if (!get_port_state(port))exit(0);

for (i = 0; dir[i] ; i = i + 1)
{
 data = string(dir[i], "cgicso?query=AAA");
 req = http_get(item:data, port:port);
 soc = http_open_socket(port);
 if (soc)
 {
   send(socket:soc, data:req);
   buf = http_recv(socket:soc);
   http_close_socket(soc);
   if ("400 Required field missing: fingerhost" >< buf)
   {
    security_hole(port:port);
    exit(0);
   }
  }
  else exit(0);
}
 
 
# Check with cgibin()

data =  string(cgibin(), "/cgicso?query=AAA");
req = http_get(item:data, port:port);
soc = http_open_socket(port);
if(soc)
{
 send(socket:soc, data:req);
 buf = http_recv(socket:soc);
 http_close_socket(soc);
 if ("400 Required field missing: fingerhost" >< buf)
   {
     security_hole(port:port);
     exit(0);
   }
}
 


