'\"
'\" Generated from ./modules/struct/stack.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "stack" n 1.2.1 struct "Tcl Data Structures"
.BS
.SH NAME
stack \- Create and manipulate stack objects
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBstruct ?1.2.1?\fR
.sp
\fIstackName\fR \fBoption\fR ?\fIarg arg ...\fR?\fR
.sp
\fIstackName\fR \fBclear\fR\fR
.sp
\fIstackName\fR \fBdestroy\fR\fR
.sp
\fIstackName\fR \fBpeek\fR ?\fIcount\fR?\fR
.sp
\fIstackName\fR \fBpop\fR ?\fIcount\fR?\fR
.sp
\fIstackName\fR \fBpush\fR \fIitem\fR ?\fIitem ...\fR?\fR
.sp
\fIstackName\fR \fBsize\fR\fR
.sp
.BE
.SH "DESCRIPTION"
The \fB::struct::stack\fR command creates a new stack object with an
associated global Tcl command whose name is \fIstackName\fR.  This
command may be used to invoke various operations on the stack.  It has
the following general form:
.TP
\fIstackName\fR \fBoption\fR ?\fIarg arg ...\fR?\fR
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following commands are possible for stack objects:
.TP
\fIstackName\fR \fBclear\fR\fR
Remove all items from the stack.
.TP
\fIstackName\fR \fBdestroy\fR\fR
Destroy the stack, including its storage space and associated command.
.TP
\fIstackName\fR \fBpeek\fR ?\fIcount\fR?\fR
Return the top \fIcount\fR items of the stack, without removing them from
the stack.  If \fIcount\fR is not specified, it defaults to 1.  If
\fIcount\fR is 1, the result is a simple string; otherwise, it is a
list.  If specified, \fIcount\fR must be greater than or equal to 1.
If there are no items on the stack, this command will return
\fIcount\fR empty strings.
.TP
\fIstackName\fR \fBpop\fR ?\fIcount\fR?\fR
Return the top \fIcount\fR items of the stack, and remove them
from the stack.  If \fIcount\fR is not specified, it defaults to 1.
If \fIcount\fR is 1, the result is a simple string; otherwise, it is a
list.  If specified, \fIcount\fR must be greater than or equal to 1.
If there are no items on the stack, this command will return
\fIcount\fR empty strings.
.TP
\fIstackName\fR \fBpush\fR \fIitem\fR ?\fIitem ...\fR?\fR
Push the \fIitem\fR or items specified onto the stack.  If more than
one \fIitem\fR is given, they will be pushed in the order they are
listed.
.TP
\fIstackName\fR \fBsize\fR\fR
Return the number of items on the stack.
.SH "KEYWORDS"
queue, matrix, tree, graph
