'\"
'\" Generated from ./modules/exif/exif.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "exif" n 1.0 exif "EXIF parsing"
.BS
.SH NAME
exif \- Tcl EXIF extracts and parses EXIF fields from digital images
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBexif ?1.0?\fR
.sp
\fBexif::analyze\fR \fIchannel\fR\fR
.sp
\fBexif::fieldnames\fR \fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The EXIF package is a recoding of Chris Breeze's Perl package to do
the same thing.  This version accepts a channel as input and returns a
serialized array with all the recognised fields parsed out.
.PP
There is also a function to obtain a list of all possible field names
that might be present, which is useful in building GUIs that present
such information.
.SH "COMMANDS"
.TP
\fBexif::analyze\fR \fIchannel\fR\fR
\fIchannel\fR should be an open file handle rewound to the start.  It
does not need to be seekable.  \fIchannel\fR will be set to binary
mode and is left wherever it happens to stop being parsed, usually at
the end of the file or the start of the image data.  You must open and
close the stream yourself.  If no error is thrown, the return value is
a serialized array with informative English text about what was found
in the EXIF block.  Failure during parsing or I/O throw errors.
.TP
\fBexif::fieldnames\fR \fR
This returns a list of all possible field names.  That is, the array
returned by \fBexif::analyze\fR will not contain keys that are not
listed in the return from \fBexif::fieldnames\fR.  Of course, if
information is missing in the image file, \fBexif::analyze\fR may not
return all the fields listed in the return from exif::fieldnames.
This function is expected to be primarily useful for building GUIs to
display results.
.sp
N.B.: Read the implementation of \fBexif::fieldnames\fR before
modifying the implementation of \fBexif::analyze\fR.
.SH "COPYRIGHTS"
(c) 2002 Darren New
Hold harmless the author, and any lawful use is allowed.
.SH "ACKNOWLEDGEMENTS"
This code is a direct translation of version 1.3 of exif.pl by Chris
Breeze.  See the source for full headers, references, etc.
