'\"
'\" Generated from ./modules/doctools/dtformat.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "format" n 1.0 doctools "Documentation tools"
.BS
.SH NAME
format \- Specification of simple tcl markup for manpages
.SH "SYNOPSIS"
\fBmanpage_begin\fR \fIcommand\fR \fIsection\fR \fIversion\fR\fR
.sp
\fBmanpage_end\fR \fR
.sp
\fBmoddesc\fR \fIdesc\fR\fR
.sp
\fBtitledesc\fR \fIdesc\fR\fR
.sp
\fBdescription\fR \fR
.sp
\fBrequire\fR \fIpkg\fR ?\fIversion\fR?\fR
.sp
\fBsection\fR \fIname\fR\fR
.sp
\fBpara\fR \fR
.sp
\fBsee_also\fR \fIargs\fR\fR
.sp
\fBkeywords\fR \fIargs\fR\fR
.sp
\fBarg\fR \fItext\fR\fR
.sp
\fBcmd\fR \fItext\fR\fR
.sp
\fBopt\fR \fItext\fR\fR
.sp
\fBemph\fR \fItext\fR\fR
.sp
\fBstrong\fR \fItext\fR\fR
.sp
\fBcomment\fR \fItext\fR\fR
.sp
\fBsectref\fR \fItext\fR\fR
.sp
\fBsyscmd\fR \fItext\fR\fR
.sp
\fBmethod\fR \fItext\fR\fR
.sp
\fBoption\fR \fItext\fR\fR
.sp
\fBwidget\fR \fItext\fR\fR
.sp
\fBfun\fR \fItext\fR\fR
.sp
\fBtype\fR \fItext\fR\fR
.sp
\fBpackage\fR \fItext\fR\fR
.sp
\fBclass\fR \fItext\fR\fR
.sp
\fBvar\fR \fItext\fR\fR
.sp
\fBfile\fR \fItext\fR\fR
.sp
\fBuri\fR \fItext\fR\fR
.sp
\fBterm\fR \fItext\fR\fR
.sp
\fBconst\fR \fItext\fR\fR
.sp
\fBnl\fR \fR
.sp
\fBlb\fR \fR
.sp
\fBrb\fR \fR
.sp
\fBexample_begin\fR \fR
.sp
\fBexample_end\fR \fR
.sp
\fBexample\fR \fItext\fR\fR
.sp
\fBlist_begin\fR \fIwhat\fR\fR
.sp
\fBlist_end\fR \fR
.sp
\fBbullet\fR \fR
.sp
\fBenum\fR \fR
.sp
\fBlst_item\fR \fItext\fR\fR
.sp
\fBcall\fR \fIargs\fR\fR
.sp
\fBarg_def\fR \fItype\fR \fIname\fR ?\fImode\fR?\fR
.sp
\fBopt_def\fR \fIname\fR ?\fIarg\fR?\fR
.sp
\fBcmd_def\fR \fIcommand\fR\fR
.sp
\fBtkoption_def\fR \fIname\fR \fIdbname\fR \fIdbclass\fR\fR
.sp
\fBusage\fR \fIargs\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This manpage specifies
.IP [1]
The overall format of manpages using this markup, and
.IP [2]
the tcl commands used as the markup
.PP
The manpage format described here is simpler than TMML, but
convertible into it (and other formats, like HTML and nroff).
.PP
The tcl sources of this manpage can serve as an example for all of the
markup described by it. Every possible construct (with the exception
of \fBrequire\fR) is used here.
.SH "OVERVIEW"
.IP \(bu
The main commands are \fBmanpage_begin\fR, \fBmanpage_end\fR,
\fBmoddesc\fR, \fBtitledesc\fR, and \fBdescription\fR. Four of these
five are required for a manpage. The optional command is
\fBtitledesc\fR. The first two are the first and last commands in a
manpage. Neither text nor other commands may precede
\fBmanpage_begin\fR nor follow \fBmanpage_end\fR.  The command
\fBdescription\fR separates header and body of the manpage and may not
be omitted.
.sp
The remaining commands (\fBmoddesc\fR and \fBtitledesc\fR) provide
one-line descriptions of module and specific title respectively.
.IP \(bu
The only text allowed between \fBmanpage_begin\fR and
\fBdescription\fR is the command \fBrequire\fR. Other commands or
normal text are not permitted. \fBrequire\fR is used to list the
packages the described command(s) depend(s) on for its operation. This
list can be empty.
.IP \(bu
After \fBdescription\fR text and all other commands are allowed. The
text can be separated into highlevel blocks using named
\fBsection\fRs.  Each block can be further divided into paragraphs via
\fBpara\fR.
.IP \(bu
The commands \fBsee_also\fR and \fBkeywords\fR define whole sections
named \fISEE ALSO\fR and \fIKEYWORDS\fR. They can occur everywhere
in the manpage but making them the last section is the usual thing to
do. They can be omitted.
.IP \(bu
There are five commands available to markup words, \fBarg\fR,
\fBcmd\fR, \fBopt\fR, \fBemph\fR and \fBstrong\fR. The first three are
used to mark words as \fIcommand arguments\fR, as
\fIcommand names\fR and as \fIoptional\fR. The other two are visual
markup to emphasize words in two different ways. The term \fIwords\fR
is used in a loose sense here, i.e application of the commands to a
sequence of words is entierely possible, if they are properly quoted.
.IP \(bu
Another set of commands is available to construct (possibly nested)
lists. These are \fBlist_begin\fR, \fBlist_end\fR, \fBlst_item\fR,
\fBbullet\fR, \fBenum\fR, \fBcall\fR, \fBarg_def\fR, \fBopt_def\fR,
\fBcmd_def\fR, and \fBtkoption_def\fR. The first two of these begin
and end a list respectively.
.sp
The argument to the first command denotes the type of the list. The
allowed values and their associated item command are explained later,
in the section detailing the \fBCommands\fR.
.sp
The other commands start list items and each can be used only inside a
list of their type. In other words, \fBbullet\fR is allowed in
bulleted lists but nowhere else, \fBenum\fR in enumerated lists and
\fBlst_item\fR and \fBcall\fR are for definition lists. These two
commands also have some text directly associated with the item
although the major bulk of the item is the text following the item
until the next list command.
.sp
The last list command, \fBcall\fR is special. It is used to describe
the syntax of a command and its arguments. It should not only cause
the appropriate markup of a list item at its place but also add the
syntax to the table of contents (synopsis) if supported by the output
format in question. nroff and HTML for example do. A format focused on
logical markup, like TMML, may not.
.IP \(bu
The command \fBusage\fR is similar to \fBcall\fR in that it adds the
syntax to the table of contents (synopsis) if supported by the output
format. Unlike \fBcall\fR,  this command doens't add any text to the
output as a direct result of the command. Thus, it can be used
anywhere within the document to add usage information. Typically it is
used near the top of the document, in cases where it is not desireable
to use \fBcall\fR elsehere in the document, or where additional usage
information is desired (eg: to document a "package require" command).
.SH "Commands"
.TP
\fBmanpage_begin\fR \fIcommand\fR \fIsection\fR \fIversion\fR\fR
This command begins a manpage. Nothing is allowed to precede
it. Arguments are the name of the command described by the manpage,
the section of the manpages this manpages lives in, the version of the
module containing the command, the name of the module itself and two
descriptions, one short for the command and one a bit longer for the
module. Both have to fit on one line.
.TP
\fBmanpage_end\fR \fR
This command closes a manpage. Nothing is allowed to follow it.
.TP
\fBmoddesc\fR \fIdesc\fR\fR
This command is required and comes after \fBmanpage_begin\fR, but
before either \fBrequire\fR or \fBdescription\fR. Its argument
provides a one-line description of the module described by the manpage.
.TP
\fBtitledesc\fR \fIdesc\fR\fR
This command is optional and comes after \fBmanpage_begin\fR, but
before either \fBrequire\fR or \fBdescription\fR. Its argument
provides a one-line expansion of the title for the manpage. If this
command is not used the manpage processor has to use information from
\fBmoddesc\fR instead.
.TP
\fBdescription\fR \fR
This command separates the header part of the manpage from the main
body. Only \fBrequire\fR, \fBmoddesc\fR, or \fBtitledesc\fR may
precede it.
.TP
\fBrequire\fR \fIpkg\fR ?\fIversion\fR?\fR
May occur only between \fBmanpage_begin\fR and \fBdescription\fR. Is
used to list the packages which are required for the described command
to be operational.
.TP
\fBsection\fR \fIname\fR\fR
Used to structure the body of the manpage into named sections. This
command is not allowed inside of a list or example. It implicitly
closes the last \fBpara\fRgraph before the command and also implicitly
opens the first paragraph of the new section.
.TP
\fBpara\fR \fR
Used to structure sections into paragraphs. Must not be used inside of
a list or example.
.TP
\fBsee_also\fR \fIargs\fR\fR
Creates a section \fISEE ALSO\fR containing the arguments as
cross-references. Must not be used inside of a list or example.
.TP
\fBkeywords\fR \fIargs\fR\fR
Creates a section \fIKEYWORDS\fR containing the arguments as words
indexing the manpage. Must not be used inside of a list or example.
.TP
\fBarg\fR \fItext\fR\fR
Declares that the marked \fItext\fR is the name of a command argument.
.TP
\fBcmd\fR \fItext\fR\fR
Declares that the marked \fItext\fR is the name of a command.
.TP
\fBopt\fR \fItext\fR\fR
Declares that the marked \fItext\fR is something optional. Most often used
in conjunction with \fBarg\fR to denote optional command arguments.
.TP
\fBemph\fR \fItext\fR\fR
One way to emphasize \fItext\fR in a general manner.
.TP
\fBstrong\fR \fItext\fR\fR
Another way to emphasize \fItext\fR in a general manner.
.TP
\fBcomment\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a comment.
.TP
\fBsectref\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a section reference.
.TP
\fBsyscmd\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a system command.
.TP
\fBmethod\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a object method.
.TP
\fBoption\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a option.
.TP
\fBwidget\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a widget.
.TP
\fBfun\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a function.
.TP
\fBtype\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a data type.
.TP
\fBpackage\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a package.
.TP
\fBclass\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a class.
.TP
\fBvar\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a variable.
.TP
\fBfile\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a file .
.TP
\fBuri\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a uri.
.TP
\fBterm\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a unspecific terminology.
.TP
\fBconst\fR \fItext\fR\fR
Declares that the marked \fItext\fR is a constant value.
.TP
\fBnl\fR \fR
Vertical space to separate text without breaking it into a new
paragraph.
.TP
\fBlb\fR \fR
Introduces a left bracket into the output.
.TP
\fBrb\fR \fR
Introduces a right bracket into the output. The bracket commands are
necessary as plain brackets are used to denote the beginnings and
endings of the formatting commands.
.TP
\fBexample_begin\fR \fR
Formats subsequent text as a code sample:
line breaks, spaces, and tabs are preserved and,
where appropriate, text is presented in a fixed-width font.
.TP
\fBexample_end\fR \fR
End of a code sample block.
.TP
\fBexample\fR \fItext\fR\fR
Formats \fItext\fR as a multi-line block of sample code.
\fItext\fR should be enclosed in braces.
.TP
\fBlist_begin\fR \fIwhat\fR\fR
Starts new list of type \fIwhat\fR. The allowed types (and their
associated item commands) are:
.RS
.TP
\fIbullet\fR
\fBbullet\fR
.TP
\fIenum\fR
\fBenum\fR
.TP
\fIdefinitions\fR
\fBlst_item\fR and \fBcall\fR
.TP
\fIarg\fR
\fBarg_def\fR
.TP
\fIcmd\fR
\fBcmd_def\fR
.TP
\fIopt\fR
\fBopt_def\fR
.TP
\fItkoption\fR
\fBtkoption_def\fR
.RE
.TP
\fBlist_end\fR \fR
Ends the list opened by the last \fBlist_begin\fR.
.TP
\fBbullet\fR \fR
Starts a new item in a bulleted list.
.TP
\fBenum\fR \fR
Starts a new item in an enumerated list.
.TP
\fBlst_item\fR \fItext\fR\fR
Starts a new item in a definition list. The argument is the term to be
defined.
.TP
\fBcall\fR \fIargs\fR\fR
Starts a new item in a definition list, but the term defined by it is
a command and its arguments.
.TP
\fBarg_def\fR \fItype\fR \fIname\fR ?\fImode\fR?\fR
Starts a new item in an argument list. Specifies the data-\fItype\fR
of the described argument, its \fIname\fR and possibly its
i/o-\fImode\fR.
.TP
\fBopt_def\fR \fIname\fR ?\fIarg\fR?\fR
Starts a new item in an option list. Specifies the \fIname\fR of the
option and possible (i.e. optional) \fIarg\fRuments.
.TP
\fBcmd_def\fR \fIcommand\fR\fR
Starts a new item in a command list. Specifies the name of the
\fIcommand\fR.
.TP
\fBtkoption_def\fR \fIname\fR \fIdbname\fR \fIdbclass\fR\fR
Starts a new item in a widget option list.  Specifies the \fIname\fR
of the option, i.e.  the name used in scripts, name used by the option
database, and the class (type) of the option.
.TP
\fBusage\fR \fIargs\fR\fR
Defines a term to be used in the table of contents or synopsis section,
depending on the format. This command is \fIsilent\fR, as it doesn't
add any text to the output as a direct result of the call. It merely
defines data to appear in another section.
.SH "SEE ALSO"
expander(n), formatter(n), mpexpand(n)
.SH "KEYWORDS"
manpage, TMML, HTML, nroff, conversion, markup
