import sys
import os
import string
import getopt as org_getopt

use_color=0
scale_factor = 1
output_format = None   # "ps", "pdf", "png", or "x11"
compress_output = 1
output_file = ""

default_font_family = "Helvetica"
default_font_size = 9
default_font_line_height = 9
default_font_halign = "L"
default_font_valign = "B"
default_font_angle = 0
default_line_width = 0.4

debug_level = 1

def parse_yesno(str):
    if str in ("yes", "true", "1"):
        return 1
    else:
        return 0
    
def parse_option(opt, arg):
    global use_color, scale_factor
    global output_format, output_file, compress_output
    global default_font_family, default_font_size
    global default_font_line_height
    global default_line_width, debug_level
    if opt == "format":
        if arg in ("ps", "eps"):
            output_format = "ps"
        elif arg == "png":
            output_format = "png"
        elif arg == "x11":
            output_format = "x11"
        elif arg == "pdf-uncompressed":
            output_format = "pdf"
            compress_output = 0
        elif arg in ("pdf-compressed", "pdf"):
            output_format = "pdf"
            compress_output = 1
        else:
            raise ValueError, "Unknown output option: " + str(arg)
    elif opt == "output":
        output_file = arg
    elif opt == "color":
        use_color = parse_yesno(arg)
    elif opt == "scale":
        scale_factor = float(arg)
    elif opt == "font-family":
        default_font_family = arg
    elif opt == "font-size":
        default_font_size = int(arg)
        default_font_line_height = int(arg)            
    elif opt == "line-width":
        default_line_width = int(arg)
    elif opt == "debug-level":
        debug_level = int(arg)
    else:
        raise org_getopt.GetoptError, "Unknown option: " + opt + " " + arg
    
if os.environ.has_key("PYCHART_OPTIONS"):
    for opt in string.split(os.environ["PYCHART_OPTIONS"]):
        arg = string.split(opt, "=")
        parse_option(arg[0], arg[1])

hooks = []        
def add_reinitialization_hook(proc):
    global hooks
    hooks.append(proc)

def usage():
    print "Usage: %s [options..]" % sys.argv[0]
    print """
    --scale=X: Set the scaling factor to X (default: 1.0).
    --format=[ps|png|pdf|x11]: Set the output format (default: ps).
    --font-family=NAME: Set the default font family (default: Helvetica).
    --font-size=NAME: Set the default font size (default: 9pts).
    --line-width=NAME: Set the default line width (default: 0.4).
    --debug-level=N: Set the messaging verbosity (default: 0).
    """

def reinitialize():
    for proc in hooks:
        proc()
    
def getopt(argv = None):
    """This procedure takes a list of command line arguments in ARGV and parses
    options. It returns the un-parsed portion of the ARGV. ARGV can be
    omitted, in which case its value defaults to sys.argv[1:].  The options
    supported are: "--format=[ps|png|pdf|x11]", "--output=FILE", "--color=[yes|no]"
    "--scale=X", "--font-family=NAME", "--font-size=X", "--line-width=X",
    "--debug-level=N". The below code shows an example.

from pychart import *
import sys
args = theme.getopt(sys.argv[1:])

ar = area.T(...)
...
    """
    if argv == None:
        argv = sys.argv[1:]
    try:
        opts, args = org_getopt.getopt(argv, "d:co:f:",
                                   ["format=", "output=", "color=",
                                    "scale=", "font-family=", "font-size=",
                                    "line-width", "debug-level"])
    except org_getopt.GetoptError, foo:
        print foo
        usage()
        raise org_getopt.GetoptError
    for opt, arg in opts:
        if opt == "-d":
            parse_option("debug-level", arg)
        elif opt == "-c":
            parse_option("color", "yes")
        elif opt == "-o":
            parse_option("output", arg)
        elif opt == "-f":
            parse_option("format", arg)
        else:
            parse_option(opt[2:], arg)
    reinitialize()
    return args

