/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pudl;

import de.tu_darmstadt.sp.paul.PDFArray;
import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFInteger;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;

class PageLabel {
    PDFDictionary PageLabelDict;

    PageLabel(PDFDictionary dict) {
        this.PageLabelDict = dict;
        if (!this.PageLabelDict.containsKey(PDFName.TYPE)) {
            this.PageLabelDict.put(PDFName.TYPE, (PDFObject)PDFName.PAGELABEL);
        }
    }

    void addSection(int index, int length) {
        PDFArray sections;
        if (!this.PageLabelDict.containsKey(PDFName.NUMS)) {
            this.PageLabelDict.put(PDFName.NUMS, (PDFObject)new PDFArray());
        }
        if ((sections = (PDFArray)this.PageLabelDict.get(PDFName.NUMS)).size() % 2 == 0) {
            int i;
            if (sections.size() > 0) {
                i = sections.size() - 2;
                while (i >= 0) {
                    if (((PDFInteger)sections.get(i)).intValue() >= index) {
                        i -= 2;
                        continue;
                    }
                    break;
                }
            } else {
                i = -2;
            }
            sections.add(i + 2, PDFInteger.forInt(index));
            sections.add(i + 3, new PDFDictionary());
            int j = i + 4;
            while (j < sections.size()) {
                int zahl = length + ((PDFInteger)sections.get(j)).intValue();
                sections.remove(j);
                sections.add(j, PDFInteger.forInt(zahl));
                j += 2;
            }
        }
    }

    PDFArray getSection(int index) {
        PDFArray sections;
        PDFArray retArray = new PDFArray();
        if (this.PageLabelDict.containsKey(PDFName.NUMS) && (sections = (PDFArray)this.PageLabelDict.get(PDFName.NUMS)).size() % 2 == 0 && sections.size() > 0) {
            int i = sections.size() - 2;
            while (i >= 0) {
                if (((PDFInteger)sections.get(i)).intValue() <= index) break;
                i -= 2;
            }
            retArray.add(sections.get(i));
            retArray.add(sections.get(i + 1));
            return retArray;
        }
        retArray.add(PDFInteger.forInt(index));
        retArray.add(new PDFDictionary());
        return retArray;
    }

    static PDFName getValidStyle(char style) {
        switch (style) {
            case 'R': {
                return PDFName.R;
            }
            case 'r': {
                return PDFName.r;
            }
            case 'A': {
                return PDFName.A;
            }
            case 'a': {
                return PDFName.a;
            }
        }
        return PDFName.D;
    }

    void mergeSections() {
        PDFArray numsDict = (PDFArray)this.PageLabelDict.get(PDFName.NUMS);
        int j = numsDict.size();
        if (j % 2 == 0 && j >= 4) {
            int i = j - 4;
            while (i >= 0) {
                int indA = ((PDFInteger)numsDict.get(i)).intValue();
                int indB = ((PDFInteger)numsDict.get(i + 2)).intValue();
                PDFDictionary styleA = new PDFDictionary((PDFDictionary)numsDict.get(i + 1));
                PDFDictionary styleB = new PDFDictionary((PDFDictionary)numsDict.get(i + 3));
                int stA = ((PDFInteger)styleA.get(PDFName.St)).intValue();
                styleA.remove(PDFName.St);
                int stB = ((PDFInteger)styleB.get(PDFName.St)).intValue();
                styleB.remove(PDFName.St);
                if (styleA.equiv(styleB) && indA + 1 == indB && stA + 1 == stB) {
                    numsDict.remove(i + 3);
                    numsDict.remove(i + 2);
                }
                i -= 2;
            }
        }
        if (numsDict.size() == 2) {
            PDFDictionary styleC = new PDFDictionary((PDFDictionary)numsDict.get(1));
            int stC = ((PDFInteger)styleC.get(PDFName.St)).intValue();
            styleC.remove(PDFName.St);
            if (stC == 1 && ((PDFName)styleC.get(PDFName.S)).equals(PDFName.D) && styleC.size() == 1) {
                numsDict.remove(1);
                numsDict.remove(0);
            }
        }
    }

    void remSection(int index) {
        if (index > 0) {
            PDFArray sections = (PDFArray)this.PageLabelDict.get(PDFName.NUMS);
            int i = sections.size() - 2;
            while (i >= 0) {
                if (((PDFInteger)sections.get(i)).intValue() <= index) break;
                i -= 2;
            }
            sections.remove(i);
            sections.remove(i + 1);
        }
    }
}

