#
# This script was written by Georges Dagousset <georges.dagousset@alert4web.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10816); 
 script_version("$Revision: 1.4.2.1 $");
 script_bugtraq_id(3473);
 script_cve_id("CAN-2001-0835");
 name["english"] = "Webalizer Cross Site Scripting Vulnerability";
 script_name(english:name["english"]);

 desc["english"] = "Webalizer have a cross-site scripting vulnerability,
that could allow malicious HTML tags to be injected
in the reports generated by the Webalizer.

Solution:
Upgrade to Version 2.01-09 and change the directory in 'OutputDir'
Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Checks for the Webalizer version";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 Alert4Web.com");
 family["english"] = "Gain root remotely";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");


dir[0] = "/usage/";	#Standard directory
dir[1] = "/webalizer/";	#Popular directory

port = get_kb_item("Services/www");
if (!port) port = 80;

if (get_port_state(port))
{
 for (i = 0; dir[i] ; i = i + 1)
 {
  req = http_get(item:dir[i], port:port);
  soc = http_open_socket(port);
  if (soc)
  {
   send(socket:soc, data:req);
   buf = http_recv(socket:soc);
   http_close_socket(soc);
   if ("Generated by The Webalizer" >< buf)
   {
    if (ereg(pattern:"Generated by The Webalizer  Ver(\.|sion) ([01]\.|2\.00|2\.01( |\-0[0-6]))", string:buf))
    {
     security_hole(port:port);
    }
    exit(0);
   }
  } else exit(0);
 }
}

