#
# This script was written by Javier Fernandez-Sanguino Pea <jfs@computer.org>
# based on the iis_samples.nasl script written by Renaud Deraison
# Script was modified by Jasmin Amidzic <jasminsabina@yahoo.com>.
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10629);
 script_version ("$Revision: 1.11 $");
 script_bugtraq_id(881);
 script_cve_id("CAN-2000-0021");

 name["english"] = "Lotus Domino administration databases";
 script_name(english:name["english"]);
 
 desc["english"] = "
Some of the following database files can be accessed anonymously :

/log.nsf
/domlog.nsf
/catalog.nsf
/mab.nsf
/names.nsf
/cersvr.nsf
/setup.nsf
/statrep.nsf
/webadmin.nsf
/events4.nsf
/ntsync4.nsf
/collect4.nsf
/mailw46.nsf
/bookmark.nsf
/agentrunner.nsf
/mail.box


An anonymous user can retrieve information from this
Lotus Domino server: users, databases, configuration
of servers (including operating system and hard
disk partitioning), logs of access to users (which
could expose sensitive data if GET html forms are used)..

This issues are discussed in  'Lotus White Paper:
A Guide to Developing Secure Domino Applications' (december 1999)
http://www.lotus.com/developers/devbase.nsf/articles/doc1999112200

Solution: verify all the ACLs for these databases and remove those not needed
Risk factor : Medium/Serious";
# This really could be high if, for example some 
# sensitive data, but same databases do not give
# much information. Make separate tests for each?


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks if Lotus Domino administration databases can be anonymously accessed";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Javier Fernndez-Sanguino Pea",
		francais:"Ce script est Copyright (C) 2001 Javier Fernndez-Sanguino Pea");
# Maybe instead of CGI abuses this family should be called HTTP server abuses
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
# This should also depend on finding a Lotus Domino server
 script_dependencie("find_service.nes", "http_version.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/domino");
 exit(0);
}

#
# The script code starts here
#

function test_cgi(port, db, output)
{
 ok = is_cgi_installed(port:port, item:db);
 if(ok)
  {
	report = string(report, ". ", db, " this must be considerd a security risk since ", output,"\n");
  }
 return(0);
}
 
 
report = "";

port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(!soc)exit(0);
 
 req = http_head(item:"/", port:port);
 send(socket:soc, data:req);
 r = recv(socket:soc, length:1024);
 close(soc);
 

 
 
  test_cgi(port:port, 
 	  db:"/log.nsf",
	  output:"the server log can be retrieved");
 
  test_cgi(port:port, 
 	  db:"/setup.nsf",
	  output:"the server might be configured remotely or the current setup might be downloaded");
	  
  test_cgi(port:port, 
 	  db:"/catalog.nsf",
	  output:"the list of databases in the server can be retrieved");
 
  test_cgi(port:port, 
 	  db:"/statrep.nsf",
	  output:"the reports generated by administrators can be read anoymously");


  test_cgi(port:port, 
 	  db:"/names.nsf",
	  output:"the users and groups in the server can be accessed anonymously, in some cases, access to the hashed passwords will be possible");
	  
  test_cgi(port:port, 
 	  db:"/domlog.nsf",
	  output:"the logs of the domain servers  can be read anonymously");

  test_cgi(port:port, 
 	  db:"/webadmin.nsf",
	  output:"the server administration database can be read anonymously");

  test_cgi(port:port, 
 	  db:"/cersvr.nsf",
	  output:"the information on the server certificates can be read anonymously");
	  
  test_cgi(port:port, 
 	  db:"/events4.nsf",
	  output:"the list of events that have taken place can be read anonymously, this might lead to information disclosure of users and hidden databases");

 # We should add more info here on the output: on how this database
 # affects the server
  test_cgi(port:port, 
 	  db:"/mab.nsf",
	  output:"the database can be read anonymously");

  test_cgi(port:port, 
 	  db:"/ntsync4.nsf",
	  output:"the database can be read anonymously");

  test_cgi(port:port, 
 	  db:"/collect4.nsf",
	  output:"the database can be read anonymously");

  test_cgi(port:port, 
 	  db:"/mailw46.nsf",
	  output:"the database can be read anonymously");
	  
  test_cgi(port:port, 
 	  db:"/bookmark.nsf",
	  output:"The database can be read anonymously");
	  
  test_cgi(port:port, 
 	  db:"/agentrunner.nsf",
	  output:"The database can be read anonymously");

  test_cgi(port:port, 
 	  db:"/mail.box",
	  output:"The database can be read anonymously");

 if(report)
  {
  report = string("We found the following domino databases :\n", report);
  security_hole(port:port, data:report);
  }
    exit(0);

}




