/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
// written by Karsten Laux, June 1999  

#ifndef _PAINTER_H_
#define _PAINTER_H_

#include "surface.h"


namespace uta {

///
class Painter
{
 public:
  ///
  Painter(Surface* surf);
  ///
  ~Painter() {};

  ///
  enum Mode {OP_REPLACE, OP_AND, OP_OR, OP_XOR};

  ///set active color
  void setColor(const Color& col) { color_ = col; };
  ///set filling for boxes and circles on/off 
  void setFilling(bool flag) { fill_ = flag;};
  ///set drawing mode (OP_OR, OP_AND, OP_REPLACE, OP_XOR)
  void setMode(Mode mode) { mode_ = mode;};

  ///set pixel to given Color
  void setPixel(const Point&, const Color&);
  ///return color of pixel
  Color getPixel (const Point&);

  ///horizontal line
  void hLine(const Point&, const Point&, const Color&);
  ///vertical line
  void vLine(const Point&, const Point&, const Color&);
  ///horizontal line
  void hLine(const Point&, const Point&);
  ///vertical line
  void vLine(const Point&, const Point&);

  ///bresemham line (calls vLine or hLine if possible)
  void line(const Point&, const Point&, const Color&);
  ///bresenham line (calls vLine or hLine if possible)
  void line(const Point&, const Point&);

  ///
  void circle(const Point&, unsigned int r, unsigned int t=1);
  ///
  void ellipse(const Point&, unsigned int rx, 
	       unsigned int ry, unsigned int t=1);
  ///
  void box(const Point&, const Point&);

  ///
  void trigon(const Point& p1, const Point& p2, const Point& p3, const Color& c);
  ///
  void trigon(const Point& p1, const Point& p2, const Point& p3);

  ///
  void shadedTrigon(const Point& d1, const Point& d2, const Point& d3,
		    const Color& c1, const Color& c2, const Color& c3);
  ///
  void texturedTrigon(const Point& d1, const Point& d2, const Point& d3,
		      const Point& s1, const Point& s2, const Point& s3, Surface* texture);
   
  
 protected:
  ///
  void  ellipseFill(const Point& c, unsigned int rx, unsigned int ry);
  ///
  void writePixel(Uint32, Uint32);

  ///
  Surface* surface_;
  ///
  Color color_;
  ///
  bool fill_;
  ///
  Rect drawingArea_;
  ///
  Mode mode_;

};


}



#endif //!_PAINTER_H_
