/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/


#ifndef _MULTILINEDIT_H
#define _MULTILINEDIT_H

#include "lineedit.h"
#include "font.h"

namespace uta {

///
class MultiLineEdit : public LineEdit
{
  //OBJECT

 public:

  ///
  MultiLineEdit(Widget* parent, int x, int y, int w, int h, 
		 const Font *font=0, bool readonly = true);
  ///
  virtual ~MultiLineEdit();

  ///
  void setWrapping(bool flag);
  ///
  void setMaxLinesToStore(unsigned n) 
    { maxLinesToStore_ = n; textChanged_ = true; needsUpdate_ = true; };

  ///add Text 
  virtual void addText(const char*);  
  ///
  virtual void timer();

  ///
  virtual bool processEvent(const Event *event);

 protected:
  ///
  void breakText(string&, vector<string>&, unsigned);
  ///
  void renderTextLines(const vector<string>&);
  /**jump to a new line.
     the parameter is always ignored !
   */
  void newline(const char*);
  ///
  virtual void create();
  ///
  vector<Surface*> renderedLines_;
  ///
  bool wordWrap_;
  ///
  bool readOnly_;
  ///
  unsigned maxLinesToStore_;

};

}

#endif // _MULTILINEDIT_
