<?php
/*
 * $Horde: imp/contacts.php,v 2.39.2.10 2003/06/04 17:34:38 chuck Exp $
 *
 * Copyright 2002-2003 Marcus I. Ryan <marcus@riboflavin.net>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Registry.php';

if (!Auth::getAuth()) {
    echo '<script language="JavaScript" type="text/javascript">window.close()</script>';
    exit;
}

/* Get the lists of address books through API */
$source_list = $registry->call('contacts/sources');

// If we self-submitted, use that source. Otherwise, choose a good
// source.
if (!($source = Horde::getFormData('source'))) {
    if ($prefs->getValue('add_source')) {
        // The most likely personal address book is the one we add to.
        $source = $prefs->getValue('add_source');
    } elseif ($prefs->getValue('search_sources')) {
        // If we can't/don't add, do we search?  If so take the first.
        $search_sources = $prefs->getValue('search_sources');
        $source = $search_sources[0];
    }
}
if (empty($source) || !isset($source_list[$source])) {
    $source = key($source_list);
}

/* Get the search as submitted (defaults to '' which should list everyone). */
$search = Horde::getFormData('search');
$apiargs = array();
$apiargs['addresses'] = array($search);
$apiargs['addressbooks'] = array($source);
$apiargs['fields'] = array();

if ($search_fields_pref = $prefs->getValue('search_fields')) {
    foreach (explode("\n", $search_fields_pref) as $s) {
        $s = trim($s);
        $s = explode("\t", $s);
        if (!empty($s[0]) && ($s[0] == $source)) {
            $apiargs['fields'][array_shift($s)] = $s;
            break;
        }
    }
}

$results = $registry->call('contacts/search', $apiargs);

/* The results list returns an array for each source searched - at
   least that's how it looks to me. Make it all one array instead. */
$addresses = array();
if (!PEAR::isError($results)) {
    foreach ($results as $r) {
        $addresses = array_merge($addresses, $r);
    }
}

/* If self-submitted, preserve the currently selected users encoded by
   javascript to pass as value|text. */
$selected_addresses = array();
foreach ($_GET as $key => $value) {
    if (substr($key, 0, 2) == 'sa') {
        $a = explode('|', $value);
        $selected_addresses[$a[0]] = $a[1];
    }
}

/* Set the default list display (name or email). */
$display = Horde::getFormData('display', 'name');

/* Display the form. */
$tabindex = 1;
$title = _("Contact List");
$js_onLoad = null;
require IMP_TEMPLATES . '/common-header.inc';
require IMP_TEMPLATES . '/contacts/javascript.inc';
require IMP_TEMPLATES . '/contacts/contacts.inc';
require IMP_TEMPLATES . '/common-footer.inc';

?>
