/* GKrellM
|  Copyright (C) 1999-2002 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.  Version 2 is in the
|  COPYRIGHT file in the top level directory of this distribution.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/* Public GKrellM function prototypes available for all monitors and plugins */

  /* ---- Data structure allocation ---- */
Chart		*gkrellm_chart_new0(void);
ChartConfig	*gkrellm_chartconfig_new0(void);
Panel		*gkrellm_panel_new0(void);
Krell		*gkrellm_krell_new0(void);
Decal		*gkrellm_decal_new0(void);
Label		*gkrellm_label_new0(void);
Style		*gkrellm_style_new0(void);
Style		*gkrellm_copy_style(Style *);
void		gkrellm_copy_style_values(Style *, Style *);
TextStyle	*gkrellm_textstyle_new0(void);
TextStyle	*gkrellm_copy_textstyle(TextStyle *);


/* ---- Chart functions ---- */
void		gkrellm_chart_create(GtkWidget *, Monitor *, Chart *,
						ChartConfig **);
void		gkrellm_chart_destroy(Chart *);
void		gkrellm_chart_hide(Chart *, gboolean);
void		gkrellm_chart_show(Chart *, gboolean);
gboolean	gkrellm_chart_enable_visibility(Chart *cp, gboolean, gboolean *);
gboolean	gkrellm_is_chart_visible(Chart *);
void		gkrellm_set_draw_chart_function(Chart *, void (*func)(), gpointer);
void		gkrellm_draw_chart_to_screen(Chart *);
gint		gkrellm_draw_chart_label(Chart *, TextStyle *, gint, gint,gchar *);
void		gkrellm_draw_chart_text(Chart *, gint, gchar *);
void		gkrellm_reset_chart(Chart *);
void		gkrellm_reset_and_draw_chart(Chart *);
void		gkrellm_refresh_chart(Chart *);
void		gkrellm_rescale_chart(Chart *);
void		gkrellm_clear_chart(Chart *);
void		gkrellm_clear_chart_pixmap(Chart *);
void		gkrellm_clean_bg_src_pixmap(Chart *);
void		gkrellm_draw_chart_grid_line(Chart *, GdkPixmap *, gint);
void		gkrellm_chart_bg_image_override(Chart *, GdkImlibImage *,
						GdkImlibImage *);
gint		gkrellm_chart_width(void);
void		gkrellm_allow_scaling(gboolean *, gint *);
void		gkrellm_set_chart_height_default(Chart *, gint);
void		gkrellm_set_chart_height(Chart *, gint);
gint		gkrellm_get_chart_scalemax(Chart *);
void		gkrellm_render_data_pixmap(GdkImlibImage *, GdkPixmap **,
						GdkColor *, gint);
void		gkrellm_render_data_grid_pixmap(GdkImlibImage *, GdkPixmap **,
						GdkColor *);


/* ---- ChartData functions ---- */
ChartData *gkrellm_add_chartdata(Chart *, GdkPixmap **, GdkPixmap *, gchar *);
ChartData *gkrellm_add_default_chartdata(Chart *, gchar *);
void		gkrellm_alloc_chartdata(Chart *);
void		gkrellm_store_chartdata(Chart *, gulong, ...);
void		gkrellm_draw_chartdata(Chart *);
void		gkrellm_monotonic_chartdata(ChartData *, gboolean);
gboolean	gkrellm_get_chartdata_hide(ChartData *);
gint		gkrellm_get_current_chartdata(ChartData *);
gint		gkrellm_get_chartdata_data(ChartData *, gint);
void		gkrellm_set_chartdata_draw_style(ChartData *, gint);
void		gkrellm_set_chartdata_draw_style_default(ChartData *, gint);
void		gkrellm_set_chartdata_flags(ChartData *, gint);
void		gkrellm_scale_chartdata(ChartData *, gint, gint);


/* ---- ChartConfig functions ---- */
void		gkrellm_chartconfig_window_create(Chart *);
void		gkrellm_chartconfig_window_destroy(Chart *);
void		gkrellm_chartconfig_grid_resolution_adjustment(ChartConfig *,
				gboolean, gfloat, gfloat, gfloat, gfloat, gfloat, gint, gint);
void		gkrellm_set_chartconfig_grid_resolution(ChartConfig *, gint);
gint		gkrellm_get_chartconfig_grid_resolution(ChartConfig *);
void		gkrellm_chartconfig_grid_resolution_connect(ChartConfig *,
					void (*fn)(), gpointer);
void		gkrellm_set_chartconfig_flags(ChartConfig *, gint);

void		gkrellm_chartconfig_grid_resolution_label(ChartConfig *, gchar *);
void		gkrellm_set_chartconfig_auto_grid_resolution(ChartConfig *,
					gboolean);
void		gkrellm_set_chartconfig_auto_resolution_stick(ChartConfig *,
					gboolean);
void		gkrellm_set_chartconfig_sequence_125(ChartConfig *, gboolean);
void		gkrellm_set_chartconfig_fixed_grids(ChartConfig *, gint);
gint		gkrellm_get_chartconfig_fixed_grids(ChartConfig *);
void		gkrellm_chartconfig_fixed_grids_connect(ChartConfig *,
					void (*fn)(), gpointer);
gint		gkrellm_get_chartconfig_height(ChartConfig *);
void		gkrellm_chartconfig_height_connect(ChartConfig *,
					void (*fn)(), gpointer);

void		gkrellm_save_chartconfig(FILE *, ChartConfig *, gchar *, gchar *);
void		gkrellm_load_chartconfig(ChartConfig **, gchar *, gint);
void		gkrellm_chartconfig_destroy(ChartConfig **);


/* ---- Panel functions ---- */
void		gkrellm_panel_configure(Panel *, gchar *, Style *);
void		gkrellm_panel_configure_add_height(Panel *, gint);
void		gkrellm_panel_create(GtkWidget *, Monitor *, Panel *);
void		gkrellm_panel_destroy(Panel *);
void		gkrellm_panel_hide(Panel *);
void		gkrellm_panel_show(Panel *);
gboolean	gkrellm_panel_enable_visibility(Panel *p, gboolean, gboolean *);
gboolean	gkrellm_is_panel_visible(Panel *);
void		gkrellm_panel_keep_lists(Panel *, gboolean);
void		gkrellm_draw_panel_label(Panel *, GdkImlibImage *);
void		gkrellm_draw_panel_layers(Panel *);
void		gkrellm_draw_panel_layers_force(Panel *);
void		gkrellm_panel_bg_image_override(Panel *, GdkImlibImage *);

/* ---- Krell functions ---- */
Krell		*gkrellm_create_krell(Panel *, GdkImlibImage *, Style *);
void		gkrellm_set_krell_full_scale(Krell *, gint, gint);
void		gkrellm_set_style_krell_values(Style *, gint, gint, gint,
						gint, gint, gint);
void		gkrellm_set_krell_margins(Panel *, Krell *k, gint, gint);
void		gkrellm_set_krell_expand(Style *, gchar *);
void		gkrellm_update_krell(Panel *, Krell *, gulong);
void		gkrellm_monotonic_krell_values(Krell *k, gboolean);
void		gkrellm_destroy_krell_list(Panel *);
void		gkrellm_destroy_krell(Krell *);
void		gkrellm_move_krell_yoff(Panel *, Krell *, gint);
void		gkrellm_remove_krell(Panel *, Krell *);
void		gkrellm_remove_and_destroy_krell(Panel *, Krell *);
void		gkrellm_insert_krell(Panel *, Krell *, gboolean);
void		gkrellm_insert_krell_nth(Panel *, Krell *, gint);

/* ---- Decal and DecalButton functions ---- */
Decal		*gkrellm_create_decal_text(Panel *p, gchar *, TextStyle *, Style *,
						gint, gint, gint);
Decal		*gkrellm_create_decal_pixmap(Panel *, GdkPixmap *, GdkBitmap *,
						gint, Style *, gint, gint);
void		gkrellm_draw_decal_pixmap(Panel *, Decal *, gint);
void		gkrellm_draw_decal_text(Panel *, Decal *, gchar *, gint);
void		gkrellm_draw_decal_on_chart(Chart *, Decal *, gint, gint);
void		gkrellm_move_decal(Panel *, Decal *, gint, gint);
void		gkrellm_decal_on_top_layer(Decal *, gboolean);
void		gkrellm_destroy_decal(Decal *);
void		gkrellm_make_decal_visible(Panel *, Decal *);
void		gkrellm_make_decal_invisible(Panel *, Decal *);
gint		gkrellm_is_decal_visible(Decal *);
void		gkrellm_remove_decal(Panel *, Decal *);
void		gkrellm_remove_and_destroy_decal(Panel *, Decal *);
void		gkrellm_insert_decal(Panel *, Decal *, gboolean);
void		gkrellm_insert_decal_nth(Panel *, Decal *, gint);
void		gkrellm_destroy_decal_list(Panel *);
void		gkrellm_set_decal_button_index(DecalButton *, gint);
DecalButton  *gkrellm_make_decal_button(Panel *, Decal *, void (*func)(),
						void *, gint, gint);
DecalButton *gkrellm_make_overlay_button(Panel *, void (*func)(), void *,
						gint, gint, gint, gint,
						GdkImlibImage *, GdkImlibImage *);
DecalButton *gkrellm_put_decal_in_panel_button(Panel *, Decal *,
						void (*func)(), void *);
DecalButton *gkrellm_put_decal_in_meter_button(Panel *, Decal *,
						void (*func)(), void *);
DecalButton *gkrellm_put_label_in_panel_button(Panel *, void (*func)(),
						void *, gint pad);
DecalButton *gkrellm_put_label_in_meter_button(Panel *, void (*func)(),
						void *, gint pad);
DecalButton *gkrellm_decal_is_button(Decal *);
void		gkrellm_set_in_button_callback(DecalButton *, gint (*func)());
gboolean	gkrellm_in_decal(Decal *, GdkEventButton *);
void		gkrellm_decal_button_connect(DecalButton *, void (*func)(),
						void *);
void		gkrellm_decal_button_right_connect(DecalButton *, void (*func)(),
						void *);
void		gkrellm_set_button_sensitive(DecalButton *, gboolean);
void		gkrellm_hide_button(DecalButton *);
void		gkrellm_show_button(DecalButton *);
void		gkrellm_destroy_button(DecalButton *);


/* ---- Misc support functions ---- */
GtkWidget	*gkrellm_get_top_window(void);
gboolean	gkrellm_load_image(gchar *, gchar **, GdkImlibImage **, gchar *);
gint		gkrellm_render_to_pixmap(GdkImlibImage *, GdkPixmap **,
						GdkBitmap **, gint, gint);
gboolean	gkrellm_set_image_border(gchar *, GdkImlibImage *, Style *);
gboolean	gkrellm_get_gkrellmrc_integer(gchar *, gint *);
gchar		*gkrellm_get_gkrellmrc_string(gchar *);
gboolean	gkrellm_get_gkrellmrc_image_border(gchar *image_name,
						GdkImlibImage *image, GdkImlibBorder *border);
void		gkrellm_freeze_side_frame_packing(void);
void		gkrellm_thaw_side_frame_packing(void);
void		gkrellm_pack_side_frames(void);
void		gkrellm_draw_string(GdkDrawable *, TextStyle *, gint, gint,
						gchar *);
void		gkrellm_draw_text(GdkDrawable *, TextStyle *, gint, gint,
						gchar *, gint);
void		gkrellm_apply_launcher(GtkWidget **, GtkWidget **, Panel *,
						Launcher *, void (*func)());
GtkWidget	*gkrellm_launcher_table_new(GtkWidget *, gint);
void		gkrellm_config_launcher(GtkWidget *, gint, GtkWidget **, GtkWidget **,
						gchar *, Launcher *);
void		gkrellm_setup_launcher(Panel *, Launcher *, gint, gint);
void		gkrellm_setup_decal_launcher(Panel *, Launcher *, Decal *);
void		gkrellm_configure_tooltip(Panel *, Launcher *);
void		gkrellm_launch_button_cb(DecalButton *);
void		gkrellm_disable_plugin_connect(Monitor *, void (*func)());
pid_t		gkrellm_get_pid(void);
void		gkrellm_monitor_height_adjust(gint);
gboolean	gkrellm_using_default_theme(void);
void		gkrellm_open_config_window(Monitor *);
gboolean	gkrellm_config_window_shown(void);
void		gkrellm_config_modified(void);
void		gkrellm_message_window(gchar *title, gchar *message, GtkWidget *);
void		gkrellm_config_message_window(gchar *title, gchar *message,
						GtkWidget *);
void		gkrellm_add_info_text(GtkWidget *, gchar **, gint);
void		gkrellm_add_info_text_string(GtkWidget *, gchar *);
Margin		*gkrellm_get_style_margins(Style *);
void		gkrellm_set_style_margins(Style *, Margin *);
void		gkrellm_get_top_bottom_margins(Style *, gint *, gint *);
gboolean	gkrellm_style_is_themed(Style *);


  /* ---- Alerts ---- */
Alert		*gkrellm_alert_create(Panel *, gchar *, gchar *,
						gboolean, gboolean, gboolean,
						gfloat, gfloat, gfloat, gfloat, gint);
void		gkrellm_alert_destroy(Alert **);
void		gkrellm_check_alert(Alert *, gfloat);
void		gkrellm_reset_alert(Alert *);
void		gkrellm_reset_panel_alerts(Panel *);
void		gkrellm_freeze_alert(Alert *);
void		gkrellm_thaw_alert(Alert *);
void		gkrellm_alert_trigger_connect(Alert *, void (*func)(), gpointer);
void		gkrellm_alert_stop_connect(Alert *, void (*func)(), gpointer);
void		gkrellm_alert_config_connect(Alert *, void (*func)(), gpointer);
void		gkrellm_render_default_alert_decal(Alert *);
void		gkrellm_alert_config_window(Alert **);
void		gkrellm_alert_window_destroy(Alert **);
void		gkrellm_save_alertconfig(FILE *, Alert *, gchar *, gchar *);
void		gkrellm_load_alertconfig(Alert **, gchar *);


  /* ---- GKrellM Styles and TextStyles ---- */
gint		gkrellm_add_chart_style(Monitor *, gchar *);
gint		gkrellm_add_meter_style(Monitor *, gchar *);
gint		gkrellm_lookup_chart_style_id(gchar *);
gint		gkrellm_lookup_meter_style_id(gchar *);
Style		*gkrellm_meter_style(gint);
Style		*gkrellm_panel_style(gint);
Style		*gkrellm_chart_style(gint);
Style		*gkrellm_meter_style(gint);
Style		*gkrellm_meter_style_by_name(gchar *);
Style		*gkrellm_panel_style_by_name(gchar *);
Style		*gkrellm_chart_style_by_name(gchar *);
Style		*gkrellm_krell_slider_style(void);
Style		*gkrellm_krell_mini_style(void);
TextStyle 	*gkrellm_chart_textstyle(gint);
TextStyle 	*gkrellm_panel_textstyle(gint);
TextStyle 	*gkrellm_meter_textstyle(gint);
TextStyle 	*gkrellm_chart_alt_textstyle(gint);
TextStyle 	*gkrellm_panel_alt_textstyle(gint);
TextStyle 	*gkrellm_meter_alt_textstyle(gint);


/* ---- Accessing GKrellM images and pixmaps ---- */
GdkImlibImage *gkrellm_bg_chart_image(gint);
GdkImlibImage *gkrellm_bg_grid_image(gint);
GdkImlibImage *gkrellm_bg_panel_image(gint);
GdkImlibImage *gkrellm_bg_meter_image(gint);
GdkImlibImage *gkrellm_bg_slider_image(gint);
GdkImlibImage *gkrellm_krell_panel_image(gint);
GdkImlibImage *gkrellm_krell_meter_image(gint);
GdkImlibImage *gkrellm_krell_slider_image(void);
GdkImlibImage *gkrellm_krell_mini_image(void);
GdkImlibBorder *gkrellm_bg_slider_border(gint);
void		gkrellm_get_decal_alarm_image(GdkImlibImage **, gint *);
void		gkrellm_get_decal_warn_image(GdkImlibImage **, gint *);
GdkPixmap	**gkrellm_data_in_pixmap(void);
GdkPixmap	*gkrellm_data_in_grid_pixmap(void);
GdkPixmap	**gkrellm_data_out_pixmap(void);
GdkPixmap	*gkrellm_data_out_grid_pixmap(void);
GdkPixmap	*gkrellm_decal_misc_pixmap(void);
GdkBitmap	*gkrellm_decal_misc_mask(void);


  /* ---- Accessing other data from the GK struct ---- */
GdkGC		*gkrellm_draw_GC(gint);
GdkGC		*gkrellm_bit_GC(gint);
GdkFont		*gkrellm_default_font(gint);
GdkColor	*gkrellm_white_color(void);
GdkColor	*gkrellm_black_color(void);
GdkColor	*gkrellm_in_color(void);
GdkColor	*gkrellm_out_color(void);
gboolean	gkrellm_demo_mode(void);
gint		gkrellm_update_HZ(void);
gchar		*gkrellm_get_theme_path(void);


  /* ---- Some handy utility functions ---- */
GtkWidget	*gkrellm_create_tab(GtkWidget *, gchar *);
GtkWidget	*gkrellm_create_framed_tab(GtkWidget *, char *);
gchar		*gkrellm_entry_get_text(GtkWidget **);
void		gkrellm_spin_button(GtkWidget *, GtkWidget **, gfloat, gfloat,
						gfloat, gfloat, gfloat, gint, gint, void (*func)(),
						gpointer, gboolean, gchar *);
void		gkrellm_check_button(GtkWidget *, GtkWidget **, gboolean, gboolean,
						gint, gchar *);
void		gkrellm_check_button_connected(GtkWidget *, GtkWidget **, gboolean,
						gboolean, gboolean, gint, void (*func)(), gpointer,
						gchar *);
void		gkrellm_button_connected(GtkWidget *, GtkWidget **, gboolean,
						gboolean, gint, void (*func)(), gpointer, gchar *);
GtkWidget	*gkrellm_scrolled_vbox(GtkWidget *, GtkWidget **,
						GtkPolicyType, GtkPolicyType);
GtkWidget	*gkrellm_scrolled_text(GtkWidget *, GtkWidget **,
						GtkPolicyType, GtkPolicyType);
GtkWidget	*gkrellm_framed_vbox(GtkWidget *, gchar *, gint, gboolean,
						gint, gint);
GtkWidget	*gkrellm_framed_vbox_end(GtkWidget *, gchar *, gint, gboolean,
						gint, gint);

gchar		*gkrellm_homedir(void);
gboolean	gkrellm_dup_string(gchar **, gchar *);
void		gkrellm_free_pixmap(GdkPixmap **);
gchar		*gkrellm_make_config_file_name(gchar *, gchar *);
gchar		*gkrellm_make_data_file_name(gchar *, gchar *);
struct tm	*gkrellm_get_current_time(void);
gint		gkrellm_system(gchar *);
gint		gkrellm_125_sequence(gint, gboolean, gint, gint,
						gboolean, gboolean);


  /* ---- Session manager plugin helpers ---- */
gint		gkrellm_get_sm_argc(void);
gchar		**gkrellm_get_sm_argv(void);
gint		gkrellm_get_restart_options(gchar **, gint);
void		gkrellm_save_all(void);



  /* --- Some builtin monitor public functions --- */

  /* ---- Functions exported by cpu.c ---- */
gint		gkrellm_smp_cpus(void);
gboolean	gkrellm_cpu_stats(gint n, gulong *, gulong *, gulong *, gulong *);


  /* ---- Functions exported by net.c ---- */
gint		gkrellm_net_routes(void);
gboolean	gkrellm_net_stats(gint n, gchar *, gulong *, gulong *);


  /* ---- Functions exported by the Mail monitor - see bottom of mail.c ---- */
gboolean	gkrellm_get_mail_mute_mode(void);
gpointer 	gkrellm_add_external_mbox(gint (*func)(), gboolean, gpointer);
void		gkrellm_destroy_external_mbox(gpointer);
void		gkrellm_set_external_mbox_counts(gpointer, gint, gint);
void		gkrellm_set_external_mbox_tooltip(gpointer, gchar *);


  /* ---- Functions exported by sensors.c ---- */
gboolean	gkrellm_sensors_available(void);
void		gkrellm_sensor_draw_temperature_decal(Panel *, Decal *, gfloat, gchar);
void		gkrellm_sensor_draw_fan_decal(Panel *, Decal *, gfloat);
gint		gkrellm_sensor_read_temperature(gchar *, gfloat *, gchar *);
gint		gkrellm_sensor_read_fan(gchar *, gfloat *);
gint		gkrellm_sensor_read_voltage(gchar *, gfloat *);
Alert		*gkrellm_mapped_sensor_alert(gchar *, gint);
void		gkrellm_mapped_sensor_alert_connect(gchar *, gint,
							void (*fn)(), gpointer);

/* ---- Deprecated functions ---- */
int			gkrellm_enable_visibility(int,int *,GtkWidget *,gint);
void		gkrellm_configure_panel(Panel *, gchar *, Style *);
void		gkrellm_create_panel(GtkWidget *, Panel *, GdkImlibImage *);
void		gkrellm_destroy_panel(Panel *);
void		gkrellm_draw_layers(Panel *);
void		gkrellm_draw_layers_force(Panel *);
