%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.0, (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License at
%% http://www.erlang.org/EPL1_0.txt
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Original Code is Erlang-4.7.3, December, 1998.
%% 
%% The Initial Developer of the Original Code is Ericsson Telecom
%% AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
%% Telecom AB. All Rights Reserved.
%% 
%% Contributor(s): ______________________________________.''
%%
%% Copyright (C) 1992, 1996, Ericsson Telecom, Sweden
%% Author: Carl Wilhelm Welin 08/7273557

-module(yeccscan).
-copyright('Copyright (c) 1991-97 Ericsson Telecom AB').
-vsn('$Revision: /main/release/free/1').
-export([scan/1, scan/3]).

scan(Inport) ->
    scan(Inport, '', 1).

scan(Inport, Prompt, Line1) ->
    case catch io:scan_erl_form(Inport, Prompt, Line1) of
	{eof, Line2} ->
	    {eof, Line2};
	{ok, Tokens, Line2} ->
	    case Tokens of
		[] ->
		    scan(Inport, Prompt, Line2);
		_ ->
		    {ok, lex(Tokens), Line2}
	    end;
	{error, Descriptor, Line2} ->
	    {error, Descriptor, Line2};
	{'EXIT', Why} ->
	    io:format('yeccscan: Error scanning input line ~w~n', [Line1]),
	    exit(Why)
    end.

lex([]) ->
    [];
lex([Token | Tokens]) ->
    case Token of
	{'dot', Line} ->
	    [{'dot', Line} | lex(Tokens)];
	{':', Line} ->
            [{':', Line} | lex(Tokens)];
        {'->', Line} ->
            [{'->', Line} | lex(Tokens)];
	{Category, Line, Symbol} ->
	    [{Category, Line, Symbol} | lex(Tokens)];
	{Other, Line} ->
	    [{reserved_symbol, Line, Other} | lex(Tokens)]
    end.
