#!/usr/bin/perl -w
#
# $Id: agurify.pl,v 1.2 2003/03/03 11:39:38 kjc Exp $
#
# a script to archive aguri log files:
# (1) to read from pcap, run this script from cron(8) every two minutes.
#	agurify.pl -i <ifname>
# (2) to read from existing files
#	agurify.pl file [file2...]
#

$logdir  = "/var/log/aguri.log";
$pidfile = "$logdir/agr.pid";
$aguri   = "/usr/local/bin/aguri";
$create_images = 1;   # set to 0 not to create png images
$image_topdir  = $logdir; # by default, put images into $logdir
$save_original = 0;   # set to 1 to save raw outputs (they could become huge!)

# programs needed to create plots
$makeimages = "/usr/local/lib/aguri/makeimages.pl";

#
# usually, you don't need to edit below this line
#
$interface = "";
$logfile = "log.agr";
$tmpfile = "tmp.agr";

chomp($cwd = `pwd`);
chdir $logdir
    or die "can't cd to $logdir\n";

umask(022);

while ($file = shift @ARGV) {
    if ($file eq "-i") {
	$interface = shift @ARGV;
	# if interface is specified, use $logdir/$interface as $logdir
	$logdir = "$logdir/$interface";
	mkdir "$logdir", 0755 unless -d "$logdir";
	chdir $logdir;
	$pidfile = "$logdir/agr.pid";
    } else {
	$tmpfile = "$cwd/$file";
	unless (-r $tmpfile) { die "Can't read $tmpfile!\n"; }
	$save_original = 0;
    }

    if ($interface ne "") {
	# reading from pcap
	# try to avoid signaling in the middle of summary output
	sleep 1;

	#
	# if the program isn't running, run it and then exit.
	#
	if (-r $pidfile) {
	    $pid = eval `cat $pidfile`;
	    $cnt = kill 0, $pid;
	} else {
	    $cnt = 0;
	}
	if ($cnt != 1) {
	    system "$aguri -w $logdir/$logfile -i $interface -s 10 -p $pidfile &";
	    exit 0;
	}
	
	#
	# send a HUP signal to aguri
	#
	unless (-r $logfile) { die "can't read $logfile!\n"; }
	rename  $logfile, $tmpfile;
	kill 'HUP', $pid;
	# give time to aguri to flush the current log
	sleep 1;
    }

    #
    # find the start time and the end time in the log file
    #
    $year = 0;
    $eyear = 0;
    open(FOO, "< $tmpfile");
    while(<FOO>) {
	if ($year == 0) {
	    if (/^\%\%StartTime:.*\((\d\d\d\d)\/(\d\d)\/(\d\d) (\d\d):(\d\d):(\d\d)\)/) {
		$year = $1; $mon = $2; $day = $3;
		$hour = $4; $min = $5; $sec = $6;
	    }
	}
	if (/^\%\%EndTime:.*\((\d\d\d\d)\/(\d\d)\/(\d\d) (\d\d):\d\d:\d\d\)/) {
	    $eyear = $1; $emon = $2; $eday = $3; $ehour = $4;
	}
    }
    close(FOO);

    if ($year == 0 || $eyear == 0) {
	die "can't find start time and end time in $tmpfile!\n";
    }

    #
    # create directories if they don't exist.
    #
    mkdir "$year", 0755 unless -d "$year";
    mkdir "$year/$mon", 0755 unless -d "$year/$mon";
    mkdir "$year/$mon/$day", 0755 unless -d "$year/$mon/$day";
    mkdir "$year/$mon/$day/$hour", 0755 unless -d "$year/$mon/$day/$hour";

    #
    # create a 2-minute summary
    #
    $ofile = "$year$mon$day.$hour$min.agr";
    system "$aguri -w $year/$mon/$day/$hour/$ofile $tmpfile";

    if ($interface ne "") {
	if ($save_original != 0) {
	    # save original log files under the "orig" dir
	    mkdir "orig", 0755 unless -d "orig";
	    mkdir "orig/$year$mon$day", 0755 unless -d "orig/$year$mon$day";
	    $ofile = "$year$mon$day.$hour$min$sec.agr";
	    rename $tmpfile, "orig/$year$mon$day/$ofile";
	} else {
	    unlink $tmpfile;
	}
    }

    #
    # if the log has crossed an hour boundary, create an hour summary
    #
    if ($hour != $ehour) {
	$ofile = "$year$mon$day.$hour.agr";
	$ifile = "$year$mon$day.$hour??.agr";
	system "$aguri -w $year/$mon/$day/$ofile $year/$mon/$day/$hour/$ifile";
    }

    #
    # if the log has crossed a day boundary, create a day summary
    #
    if ($day != $eday) {
	$ofile = "$year$mon$day.agr";
	$ifile = "$year$mon$day.??.agr";
	system "$aguri -w $year/$mon/$ofile $year/$mon/$day/$ifile";
    }

    #
    # if the log has crossed a month boundary, create a month summary
    #
    if ($mon != $emon) {
	$ofile = "$year$mon.agr";
	$ifile = "$year$mon??.agr";
	system "$aguri -w $year/$ofile $year/$mon/$ifile";
    }

    #
    # if the log has crossed a year boundary, create a year summary
    #
    if ($year != $eyear) {
	$ofile = "$year.agr";
	$ifile = "$year??.agr";
	system "$aguri -w $ofile $year/$ifile";
    }

    #
    # if create_images is specified, make plot images every hour
    #
    if ($create_images != 0) {
	if ($hour != $ehour) {
	    unless (-d $image_topdir) { die "no image_topdir at $tmpfile\n"; }
	    if ($interface ne "") {
		$image_topdir = "$image_topdir/$interface";
		mkdir "$image_topdir", 0755 unless -d "$image_topdir";
	    }
	    chdir $image_topdir
		or die "can't cd to $image_topdir\n";
	    system "$makeimages -l $logdir $year$mon$day";
	}
    }

    if ($interface ne "") {
	last;
    }
}

exit 0;
